/*
 * Decompiled with CFR 0.152.
 */
package com.parad.alienfirstperson.config;

import com.mojang.blaze3d.systems.RenderSystem;
import com.parad.alienfirstperson.AlienFirstPersonMod;
import com.parad.alienfirstperson.AlienStateHandler;
import com.parad.alienfirstperson.config.ConfigChangeManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class ScrollableScreen
extends Screen {
    protected final Screen previousScreen;
    private int scrollOffset = 0;
    private int maxScrollOffset = 0;
    private int contentHeight = 0;
    private static final int SCROLL_SPEED = 10;
    protected float fadeInAlpha = 1.0f;
    private static final float FADE_SPEED = 0.01f;
    protected boolean isClosing = false;
    private final List<GuiEventListener> scrollableWidgets = new ArrayList<GuiEventListener>();
    private final List<Renderable> scrollableRenderables = new ArrayList<Renderable>();
    private GuiEventListener draggedWidget = null;
    protected Button applyButton;
    protected Button cancelButton;
    protected boolean hasUnsavedChanges = false;
    protected boolean showApplyCancelButtons = true;

    protected ScrollableScreen(Component title, Screen previousScreen) {
        super(title);
        this.previousScreen = previousScreen;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.scrollableWidgets.clear();
        this.scrollableRenderables.clear();
        this.draggedWidget = null;
        this.initScrollableContent();
        int availableHeight = this.f_96544_ - 100;
        this.maxScrollOffset = Math.max(0, this.contentHeight - availableHeight);
        this.scrollOffset = Math.min(this.scrollOffset, this.maxScrollOffset);
        if (this.showApplyCancelButtons) {
            this.applyButton = Button.m_253074_((Component)Component.m_237113_((String)"Apply"), button -> {
                this.applyChanges();
                this.hasUnsavedChanges = false;
                this.updateButtonStates();
            }).m_252987_(this.f_96543_ / 2 - 105, this.f_96544_ - 27, 50, 20).m_253136_();
            this.m_142416_((GuiEventListener)this.applyButton);
            this.cancelButton = Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), button -> {
                if (this.hasUnsavedChanges) {
                    this.discardChanges();
                    this.hasUnsavedChanges = false;
                    this.updateButtonStates();
                    this.reloadCurrentValues();
                    this.rebuildScrollableContent();
                }
            }).m_252987_(this.f_96543_ / 2 - 50, this.f_96544_ - 27, 50, 20).m_253136_();
            this.m_142416_((GuiEventListener)this.cancelButton);
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Back"), button -> {
            if (this.hasUnsavedChanges && this.showApplyCancelButtons) {
                this.discardChanges();
            }
            this.m_7379_();
        }).m_252987_(this.showApplyCancelButtons ? this.f_96543_ / 2 + 5 : this.f_96543_ / 2 - 100, this.f_96544_ - 27, this.showApplyCancelButtons ? 100 : 200, 20).m_253136_());
        this.updateButtonStates();
    }

    protected void reloadCurrentValues() {
    }

    protected void onConfigChanged() {
        this.hasUnsavedChanges = true;
        this.updateButtonStates();
    }

    protected void updateButtonStates() {
        if (this.applyButton != null) {
            this.applyButton.f_93623_ = this.hasUnsavedChanges;
        }
    }

    protected void applyChanges() {
        AlienFirstPersonMod.LOGGER.debug("Applying changes from {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
        ConfigChangeManager.getInstance().applyAllChanges();
        this.hasUnsavedChanges = false;
    }

    protected void discardChanges() {
        AlienFirstPersonMod.LOGGER.debug("Discarding changes from {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
        ConfigChangeManager.getInstance().discardAllChanges();
        if (this.f_96541_ != null) {
            this.f_96541_.execute(() -> AlienStateHandler.reapplyCurrentAlienSettings());
        }
        this.hasUnsavedChanges = false;
    }

    protected void rebuildScrollableContent() {
        this.scrollableWidgets.clear();
        this.scrollableRenderables.clear();
        this.draggedWidget = null;
        this.m_7856_();
    }

    protected abstract void initScrollableContent();

    protected <T extends GuiEventListener & Renderable> T addScrollableWidget(T widget) {
        this.scrollableWidgets.add(widget);
        this.scrollableRenderables.add(widget);
        return widget;
    }

    protected void setContentHeight(int height) {
        this.contentHeight = height;
        int availableHeight = this.f_96544_ - 100;
        this.maxScrollOffset = Math.max(0, this.contentHeight - availableHeight);
        this.scrollOffset = Math.min(this.scrollOffset, this.maxScrollOffset);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        int scrollAreaTop = 50;
        int scrollAreaBottom = this.f_96544_ - 50;
        int scrollAreaHeight = scrollAreaBottom - scrollAreaTop;
        int scale = (int)this.f_96541_.m_91268_().m_85449_();
        int scissorX = 0;
        int scissorY = this.f_96541_.m_91268_().m_85442_() - scrollAreaBottom * scale;
        int scissorWidth = this.f_96541_.m_91268_().m_85441_();
        int scissorHeight = scrollAreaHeight * scale;
        RenderSystem.enableScissor((int)scissorX, (int)scissorY, (int)scissorWidth, (int)scissorHeight);
        int renderMouseX = mouseX;
        int renderMouseY = mouseY + this.scrollOffset - scrollAreaTop;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, (float)(scrollAreaTop - this.scrollOffset), 0.0f);
        for (Renderable renderable : this.scrollableRenderables) {
            renderable.m_88315_(guiGraphics, renderMouseX, renderMouseY, partialTick);
        }
        guiGraphics.m_280168_().m_85849_();
        RenderSystem.disableScissor();
        if (this.maxScrollOffset > 0) {
            this.drawScrollIndicators(guiGraphics);
        }
        if (this.hasUnsavedChanges) {
            guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"* Unsaved Changes").m_130938_(style -> style.m_178520_(0xFFFF55)), 5, this.f_96544_ - 45, 0xFFFF55);
        }
        if (this.fadeInAlpha > 0.0f && !this.isClosing) {
            this.fadeInAlpha = Math.max(this.fadeInAlpha - 0.01f, 0.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableDepthTest();
            int greenColor = (int)(this.fadeInAlpha * 0.8f * 255.0f) << 24 | 0xFF00;
            guiGraphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, greenColor);
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
        }
    }

    private void drawScrollIndicators(GuiGraphics guiGraphics) {
        int barX = this.f_96543_ - 10;
        int barTop = 55;
        int barBottom = this.f_96544_ - 55;
        int barHeight = barBottom - barTop;
        guiGraphics.m_280509_(barX, barTop, barX + 6, barBottom, Integer.MIN_VALUE);
        float contentRatio = (float)(this.f_96544_ - 100) / (float)this.contentHeight;
        int thumbHeight = Math.max(10, (int)((float)barHeight * contentRatio));
        float scrollRatio = this.maxScrollOffset > 0 ? (float)this.scrollOffset / (float)this.maxScrollOffset : 0.0f;
        int thumbY = barTop + (int)((float)(barHeight - thumbHeight) * scrollRatio);
        guiGraphics.m_280509_(barX + 1, thumbY, barX + 5, thumbY + thumbHeight, -16711936);
        if (this.scrollOffset > 0) {
            guiGraphics.m_280137_(this.f_96547_, "^", this.f_96543_ - 20, 35, 0xFFFFFF);
        }
        if (this.scrollOffset < this.maxScrollOffset) {
            guiGraphics.m_280137_(this.f_96547_, "v", this.f_96543_ - 20, this.f_96544_ - 35, 0xFFFFFF);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.maxScrollOffset > 0) {
            this.scrollOffset = (int)Math.max(0.0, Math.min((double)this.maxScrollOffset, (double)this.scrollOffset - delta * 10.0));
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (mouseY >= 50.0 && mouseY <= (double)(this.f_96544_ - 50)) {
            double widgetMouseX = mouseX;
            double widgetMouseY = mouseY + (double)this.scrollOffset - 50.0;
            for (GuiEventListener widget : this.scrollableWidgets) {
                if (!widget.m_6375_(widgetMouseX, widgetMouseY, button)) continue;
                this.m_7522_(widget);
                this.draggedWidget = widget;
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        double widgetMouseY;
        double widgetMouseX;
        boolean result;
        if (this.draggedWidget != null && (result = this.draggedWidget.m_7979_(widgetMouseX = mouseX, widgetMouseY = mouseY + (double)this.scrollOffset - 50.0, button, deltaX, deltaY))) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.draggedWidget != null) {
            double widgetMouseX = mouseX;
            double widgetMouseY = mouseY + (double)this.scrollOffset - 50.0;
            boolean result = this.draggedWidget.m_6348_(widgetMouseX, widgetMouseY, button);
            this.draggedWidget = null;
            return result;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void m_94757_(double mouseX, double mouseY) {
        if (mouseY >= 50.0 && mouseY <= (double)(this.f_96544_ - 50)) {
            double widgetMouseX = mouseX;
            double widgetMouseY = mouseY + (double)this.scrollOffset - 50.0;
            for (GuiEventListener widget : this.scrollableWidgets) {
                widget.m_94757_(widgetMouseX, widgetMouseY);
            }
        }
        super.m_94757_(mouseX, mouseY);
    }

    protected void resetMainScreenState() {
    }

    public void m_7379_() {
        AlienFirstPersonMod.LOGGER.debug("{} onClose called", (Object)((Object)((Object)this)).getClass().getSimpleName());
        if (this.hasUnsavedChanges) {
            this.discardChanges();
        }
        this.isClosing = true;
        this.draggedWidget = null;
        this.resetMainScreenState();
        if (this.f_96541_ != null) {
            AlienFirstPersonMod.LOGGER.debug("Setting screen back to: {}", (Object)this.previousScreen);
            this.f_96541_.m_91152_(this.previousScreen);
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

