/*
 * Decompiled with CFR 0.152.
 */
package com.parad.alienfirstperson.config;

import com.mojang.blaze3d.systems.RenderSystem;
import com.parad.alienfirstperson.AlienSoundEvents;
import com.parad.alienfirstperson.config.AlienFirstPersonConfig;
import com.parad.alienfirstperson.config.ConfigChangeManager;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

@OnlyIn(value=Dist.CLIENT)
public class UICustomizationScreens {

    @OnlyIn(value=Dist.CLIENT)
    public static class CustomizationButton
    extends Button {
        private final ResourceLocation iconTexture;
        private float hoverAnimation = 0.0f;

        public CustomizationButton(int x, int y, int width, int height, ResourceLocation iconTexture, Component message, Button.OnPress onPress) {
            super(x, y, width, height, message, onPress, f_252438_);
            this.iconTexture = iconTexture;
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.hoverAnimation = this.f_93622_ ? Math.min(this.hoverAnimation + 0.2f, 1.0f) : Math.max(this.hoverAnimation - 0.2f, 0.0f);
            RenderSystem.enableBlend();
            int bgColor = 0x40000000 | (int)(this.hoverAnimation * 64.0f) << 16 | (int)(this.hoverAnimation * 64.0f) << 8;
            guiGraphics.m_280509_(this.m_252754_() - 2, this.m_252907_() - 2, this.m_252754_() + this.f_93618_ + 2, this.m_252907_() + this.f_93619_ + 2, bgColor);
            if (this.hoverAnimation > 0.0f) {
                int alpha = (int)(255.0f * this.hoverAnimation);
                int borderColor = alpha << 24 | 0x34AB2A;
                guiGraphics.m_280509_(this.m_252754_() - 2, this.m_252907_() - 2, this.m_252754_() + this.f_93618_ + 2, this.m_252907_() - 1, borderColor);
                guiGraphics.m_280509_(this.m_252754_() - 2, this.m_252907_() + this.f_93619_ + 1, this.m_252754_() + this.f_93618_ + 2, this.m_252907_() + this.f_93619_ + 2, borderColor);
                guiGraphics.m_280509_(this.m_252754_() - 2, this.m_252907_() - 2, this.m_252754_() - 1, this.m_252907_() + this.f_93619_ + 2, borderColor);
                guiGraphics.m_280509_(this.m_252754_() + this.f_93618_ + 1, this.m_252907_() - 2, this.m_252754_() + this.f_93618_ + 2, this.m_252907_() + this.f_93619_ + 2, borderColor);
            }
            float scale = 1.0f + this.hoverAnimation * 0.1f;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)this.m_252754_() + (float)this.f_93618_ / 2.0f, (float)this.m_252907_() + (float)this.f_93619_ / 2.0f, 0.0f);
            guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
            guiGraphics.m_280168_().m_252880_(-((float)this.m_252754_() + (float)this.f_93618_ / 2.0f), -((float)this.m_252907_() + (float)this.f_93619_ / 2.0f), 0.0f);
            if (this.iconTexture != null) {
                int iconSize = 20;
                int iconX = this.m_252754_() + 8;
                int iconY = this.m_252907_() + (this.f_93619_ - iconSize) / 2;
                guiGraphics.m_280411_(this.iconTexture, iconX, iconY, iconSize, iconSize, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            int textX = this.m_252754_() + (this.iconTexture != null ? 36 : 0) + 8;
            int n = this.m_252907_();
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            int textY = n + (this.f_93619_ - 9) / 2;
            guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, this.m_6035_(), textX, textY, 0xFFFFFF);
            guiGraphics.m_280168_().m_85849_();
            RenderSystem.disableBlend();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class IntSlider
    extends AbstractSliderButton {
        private final Component prefix;
        private final Component suffix;
        private final int minValue;
        private final int maxValue;
        private final boolean showDefault;
        private final Consumer<Integer> onValueChange;
        private int intValue;

        public IntSlider(int x, int y, int width, int height, Component prefix, Component suffix, int minValue, int maxValue, int value, Consumer<Integer> onValueChange, boolean showDefault) {
            super(x, y, width, height, (Component)Component.m_237119_(), 0.0);
            this.prefix = prefix;
            this.suffix = suffix;
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.intValue = value;
            this.onValueChange = onValueChange;
            this.showDefault = showDefault;
            this.f_93577_ = (double)(value - minValue) / (double)(maxValue - minValue);
            this.m_5695_();
        }

        protected void m_5695_() {
            String valueText = this.showDefault && this.intValue == 0 ? "Default" : (this.intValue > 0 ? "+" + this.intValue : String.valueOf(this.intValue));
            this.m_93666_((Component)Component.m_237113_((String)"").m_7220_(this.prefix).m_130946_(valueText).m_7220_(this.suffix));
        }

        protected void m_5697_() {
            this.intValue = (int)(this.f_93577_ * (double)(this.maxValue - this.minValue) + (double)this.minValue);
            if (this.onValueChange != null) {
                this.onValueChange.accept(this.intValue);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DoubleSlider
    extends AbstractSliderButton {
        private final Component prefix;
        private final Component suffix;
        private final double minValue;
        private final double maxValue;
        private final Consumer<Double> onValueChange;
        private double doubleValue;

        public DoubleSlider(int x, int y, int width, int height, Component prefix, Component suffix, double minValue, double maxValue, double value, Consumer<Double> onValueChange) {
            super(x, y, width, height, (Component)Component.m_237119_(), 0.0);
            this.prefix = prefix;
            this.suffix = suffix;
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.doubleValue = value;
            this.onValueChange = onValueChange;
            this.f_93577_ = (value - minValue) / (maxValue - minValue);
            this.m_5695_();
        }

        protected void m_5695_() {
            this.m_93666_((Component)Component.m_237113_((String)"").m_7220_(this.prefix).m_130946_(String.format("%.2f", this.doubleValue)).m_7220_(this.suffix));
        }

        protected void m_5697_() {
            this.doubleValue = this.f_93577_ * (this.maxValue - this.minValue) + this.minValue;
            if (this.onValueChange != null) {
                this.onValueChange.accept(this.doubleValue);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class AlienSelectionScreenRenderer {
        private final int screenWidth;
        private final int screenHeight;
        private double iconSizeMultiplier;
        private double iconSpacingMultiplier;
        private int textOffsetFromIcons;
        private double textScaleMultiplier;
        private float currentPanelOffset = 0.0f;
        private static final ResourceLocation[] ROW1_ICONS = new ResourceLocation[]{new ResourceLocation("alien_first_person", "textures/gui/alien_1.png"), new ResourceLocation("alien_first_person", "textures/gui/alien_2.png"), new ResourceLocation("alien_first_person", "textures/gui/alien_3.png"), new ResourceLocation("alien_first_person", "textures/gui/alien_4.png"), new ResourceLocation("alien_first_person", "textures/gui/alien_5.png")};
        private static final String[] ROW1_NAMES = new String[]{"Pyronite", "Vulpimancer", "Petrosapien", "Kineceleran", "Galvan"};
        private static final ResourceLocation[] ROW2_ICONS = new ResourceLocation[]{new ResourceLocation("alien_first_person", "textures/gui/alien_6.png"), new ResourceLocation("alien_first_person", "textures/gui/alien_7.png"), new ResourceLocation("alien_first_person", "textures/gui/alien_8.png"), new ResourceLocation("alien_first_person", "textures/gui/alien_9.png"), new ResourceLocation("alien_first_person", "textures/gui/alien_10.png")};
        private static final String[] ROW2_NAMES = new String[]{"Tetramand", "Lepidopterran", "Piscciss Volann", "Galvanic Mechamorph", "Ectonurite"};

        public AlienSelectionScreenRenderer(int screenWidth, int screenHeight, double iconSizeMultiplier, double iconSpacingMultiplier, int textOffsetFromIcons, double textScaleMultiplier) {
            this.screenWidth = screenWidth;
            this.screenHeight = screenHeight;
            this.iconSizeMultiplier = iconSizeMultiplier;
            this.iconSpacingMultiplier = iconSpacingMultiplier;
            this.textOffsetFromIcons = textOffsetFromIcons;
            this.textScaleMultiplier = textScaleMultiplier;
        }

        public void updateSettings(double iconSizeMultiplier, double iconSpacingMultiplier, int textOffsetFromIcons, double textScaleMultiplier) {
            this.iconSizeMultiplier = iconSizeMultiplier;
            this.iconSpacingMultiplier = iconSpacingMultiplier;
            this.textOffsetFromIcons = textOffsetFromIcons;
            this.textScaleMultiplier = textScaleMultiplier;
        }

        public void setCurrentPanelOffset(float offset) {
            this.currentPanelOffset = offset;
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            double guiScale = Minecraft.m_91087_().m_91268_().m_85449_();
            int maxIconsPerRow = 5;
            int maxScreenWidth = Math.min(this.screenWidth - 40, 800);
            int maxIconSize = maxScreenWidth / (maxIconsPerRow + 1);
            int baseIconSize = 56;
            if (guiScale >= 4.0) {
                baseIconSize = 40;
            } else if (guiScale >= 3.0) {
                baseIconSize = 48;
            }
            int iconSize = (int)((double)Math.min(maxIconSize, baseIconSize) * this.iconSizeMultiplier);
            int baseSpacing = Math.max(iconSize / 2, 30);
            int spacing = (int)((double)baseSpacing * this.iconSpacingMultiplier);
            float baseTextScale = 0.85f;
            int baseTextYOffset = 6;
            if (guiScale >= 4.0) {
                baseTextYOffset = 8;
                baseTextScale = 0.6f;
            } else if (guiScale >= 3.0) {
                baseTextYOffset = 7;
                baseTextScale = 0.65f;
            }
            float finalTextScale = (float)((double)baseTextScale * this.textScaleMultiplier);
            int finalTextYOffset = baseTextYOffset + this.textOffsetFromIcons;
            int centerX = this.screenWidth / 2;
            int startY = 70;
            int firstRowCount = 5;
            int totalWidth = iconSize * firstRowCount + spacing * (firstRowCount - 1);
            int startX = centerX - totalWidth / 2;
            if (startX < 20) {
                startX = 20;
                int availableWidth = this.screenWidth - 40 - iconSize * firstRowCount;
                spacing = Math.max(availableWidth / (firstRowCount - 1), 10);
            }
            for (int i = 0; i < 5; ++i) {
                int iconX = startX + i * (iconSize + spacing);
                this.renderAlienIcon(guiGraphics, iconX, startY, iconSize, ROW1_ICONS[i], ROW1_NAMES[i], finalTextScale, finalTextYOffset);
            }
            int rowVerticalSpacing = iconSize + 50;
            int secondRowY = startY + rowVerticalSpacing;
            int secondRowTotalWidth = iconSize * 5 + spacing * 4;
            int secondRowStartX = centerX - secondRowTotalWidth / 2;
            for (int i = 0; i < 5; ++i) {
                int iconX = secondRowStartX + i * (iconSize + spacing);
                this.renderAlienIcon(guiGraphics, iconX, secondRowY, iconSize, ROW2_ICONS[i], ROW2_NAMES[i], finalTextScale, finalTextYOffset);
            }
        }

        private void renderAlienIcon(GuiGraphics guiGraphics, int x, int y, int size, ResourceLocation icon, String name, float textScale, int textYOffset) {
            guiGraphics.m_280509_(x - 2, y - 2, x + size + 2, y + size + 2, -2143272896);
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)0.6f, (float)0.6f, (float)0.6f, (float)0.8f);
            guiGraphics.m_280411_(icon, x, y, size, size, 0.0f, 0.0f, 16, 16, 16, 16);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int textX = x + size / 2;
            int textY = y + size + textYOffset;
            int panelHeight = 120;
            int panelY = (int)((float)(this.screenHeight - panelHeight) + this.currentPanelOffset);
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            if (textY + (int)(9.0f * textScale) + 5 < panelY) {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_((float)textX, (float)textY, 0.0f);
                guiGraphics.m_280168_().m_85841_(textScale, textScale, 1.0f);
                guiGraphics.m_280168_().m_252880_((float)(-textX), (float)(-textY), 0.0f);
                guiGraphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)name), textX, textY, -8355712);
                guiGraphics.m_280168_().m_85849_();
            }
            RenderSystem.disableBlend();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ToggleMenuButton
    extends Button {
        private float hoverAnimation = 0.0f;

        public ToggleMenuButton(int x, int y, int width, int height, Button.OnPress onPress) {
            super(x, y, width, height, (Component)Component.m_237119_(), onPress, f_252438_);
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.hoverAnimation = this.f_93622_ ? Math.min(this.hoverAnimation + 0.2f, 1.0f) : Math.max(this.hoverAnimation - 0.2f, 0.0f);
            RenderSystem.enableBlend();
            int bgAlpha = (int)(this.hoverAnimation * 128.0f);
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, bgAlpha << 24 | 0x34AB2A);
            int lineWidth = 20;
            int lineHeight = 2;
            int lineSpacing = 2;
            int startX = this.m_252754_() + (this.f_93618_ - lineWidth) / 2;
            int startY = this.m_252907_() + (this.f_93619_ - (3 * lineHeight + 2 * lineSpacing)) / 2;
            int arrowColor = -13325526;
            guiGraphics.m_280509_(startX, startY, startX + lineWidth, startY + lineHeight, arrowColor);
            guiGraphics.m_280509_(startX, startY + lineHeight + lineSpacing, startX + lineWidth, startY + 2 * lineHeight + lineSpacing, arrowColor);
            guiGraphics.m_280509_(startX, startY + 2 * (lineHeight + lineSpacing), startX + lineWidth, startY + 3 * lineHeight + 2 * lineSpacing, arrowColor);
            RenderSystem.disableBlend();
        }

        public void m_7435_(SoundManager soundManager) {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class UICustomizationScreen
    extends Screen {
        private final Screen previousScreen;
        private float fadeInAlpha = 1.0f;
        private boolean isClosing = false;
        private double iconSizeMultiplier;
        private double iconSpacingMultiplier;
        private int textOffsetFromIcons;
        private double textScaleMultiplier;
        private AlienSelectionScreenRenderer backgroundRenderer;
        private float panelOffset = 0.0f;
        private static final float ANIMATION_SPEED = 12.0f;
        private boolean isAnimating = true;
        private boolean panelVisible = true;
        private boolean isToggleAnimating = false;
        private float targetOffset = 0.0f;
        private Button resetButton;
        private Button cancelButton;
        private Button doneButton;
        private ToggleMenuButton toggleButton;
        private DoubleSlider iconSizeSlider;
        private DoubleSlider iconSpacingSlider;
        private IntSlider textOffsetSlider;
        private DoubleSlider textScaleSlider;
        private int baseSliderY;
        private int baseButtonY;
        private int baseToggleY;

        public UICustomizationScreen(Screen previousScreen) {
            super((Component)Component.m_237113_((String)"UI Customization"));
            this.previousScreen = previousScreen;
            ConfigChangeManager manager = ConfigChangeManager.getInstance();
            this.iconSizeMultiplier = (Double)manager.getPendingOrCurrentValue("ui_customization.iconSizeMultiplier", AlienFirstPersonConfig.UI_ICON_SIZE_MULTIPLIER);
            this.iconSpacingMultiplier = (Double)manager.getPendingOrCurrentValue("ui_customization.iconSpacingMultiplier", AlienFirstPersonConfig.UI_ICON_SPACING_MULTIPLIER);
            this.textOffsetFromIcons = (Integer)manager.getPendingOrCurrentValue("ui_customization.textOffsetFromIcons", AlienFirstPersonConfig.UI_TEXT_OFFSET_FROM_ICONS);
            this.textScaleMultiplier = (Double)manager.getPendingOrCurrentValue("ui_customization.textScaleMultiplier", AlienFirstPersonConfig.UI_TEXT_SCALE_MULTIPLIER);
            this.panelOffset = 120.0f;
            this.targetOffset = 0.0f;
        }

        protected void m_7856_() {
            int buttonsY;
            int slidersY;
            super.m_7856_();
            this.backgroundRenderer = new AlienSelectionScreenRenderer(this.f_96543_, this.f_96544_, this.iconSizeMultiplier, this.iconSpacingMultiplier, this.textOffsetFromIcons, this.textScaleMultiplier);
            int panelWidth = this.f_96543_;
            int panelHeight = 120;
            int panelX = 0;
            int panelY = this.f_96544_ - panelHeight;
            this.baseToggleY = panelY - 12 - 2;
            int absoluteMinMargin = 5;
            int minSliderWidth = 80;
            int maxSliderWidth = 160;
            int minSliderSpacing = 4;
            int preferredSliderSpacing = 8;
            int availableWidth = panelWidth - absoluteMinMargin * 2;
            int numSliders = 4;
            int sliderWidth = maxSliderWidth;
            int sliderSpacing = preferredSliderSpacing;
            int totalWidth = sliderWidth * numSliders + sliderSpacing * (numSliders - 1);
            if (totalWidth > availableWidth) {
                int maxPossibleWidth = (availableWidth - minSliderSpacing * (numSliders - 1)) / numSliders;
                if (maxPossibleWidth >= minSliderWidth) {
                    sliderWidth = Math.min(maxSliderWidth, maxPossibleWidth);
                    int remainingSpace = availableWidth - sliderWidth * numSliders;
                    sliderSpacing = Math.max(minSliderSpacing, remainingSpace / (numSliders - 1));
                    totalWidth = sliderWidth * numSliders + sliderSpacing * (numSliders - 1);
                } else {
                    sliderWidth = minSliderWidth;
                    sliderSpacing = minSliderSpacing;
                    totalWidth = sliderWidth * numSliders + sliderSpacing * (numSliders - 1);
                    if (totalWidth > availableWidth) {
                        sliderWidth = Math.max(60, availableWidth / numSliders - minSliderSpacing);
                        sliderSpacing = Math.max(2, (availableWidth - sliderWidth * numSliders) / (numSliders - 1));
                        totalWidth = sliderWidth * numSliders + sliderSpacing * (numSliders - 1);
                    }
                }
            }
            int slidersStartX = panelX + (panelWidth - totalWidth) / 2;
            int slidersEndX = (slidersStartX = Math.max(absoluteMinMargin, slidersStartX)) + totalWidth;
            if (slidersEndX > panelWidth - absoluteMinMargin && (slidersStartX = panelWidth - absoluteMinMargin - totalWidth) < absoluteMinMargin) {
                slidersStartX = absoluteMinMargin;
                availableWidth = panelWidth - absoluteMinMargin * 2;
                sliderWidth = Math.max(50, (availableWidth - 2 * (numSliders - 1)) / numSliders);
                sliderSpacing = 2;
            }
            this.baseSliderY = slidersY = panelY + 35;
            this.iconSizeSlider = new DoubleSlider(slidersStartX, slidersY, sliderWidth, 20, (Component)Component.m_237113_((String)"Icon Size: "), (Component)Component.m_237113_((String)"x"), 0.5, 2.0, this.iconSizeMultiplier, value -> {
                this.iconSizeMultiplier = value;
                ConfigChangeManager.getInstance().setPendingValue("ui_customization.iconSizeMultiplier", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.UI_ICON_SIZE_MULTIPLIER);
                this.updatePreview();
            });
            this.m_142416_((GuiEventListener)this.iconSizeSlider);
            this.iconSpacingSlider = new DoubleSlider(slidersStartX + sliderWidth + sliderSpacing, slidersY, sliderWidth, 20, (Component)Component.m_237113_((String)"Spacing: "), (Component)Component.m_237113_((String)"x"), 0.5, 3.0, this.iconSpacingMultiplier, value -> {
                this.iconSpacingMultiplier = value;
                ConfigChangeManager.getInstance().setPendingValue("ui_customization.iconSpacingMultiplier", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.UI_ICON_SPACING_MULTIPLIER);
                this.updatePreview();
            });
            this.m_142416_((GuiEventListener)this.iconSpacingSlider);
            this.textOffsetSlider = new IntSlider(slidersStartX + (sliderWidth + sliderSpacing) * 2, slidersY, sliderWidth, 20, (Component)Component.m_237113_((String)"Text Y: "), (Component)Component.m_237113_((String)"px"), -20, 40, this.textOffsetFromIcons, value -> {
                this.textOffsetFromIcons = value;
                ConfigChangeManager.getInstance().setPendingValue("ui_customization.textOffsetFromIcons", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.UI_TEXT_OFFSET_FROM_ICONS);
                this.updatePreview();
            }, true);
            this.m_142416_((GuiEventListener)this.textOffsetSlider);
            this.textScaleSlider = new DoubleSlider(slidersStartX + (sliderWidth + sliderSpacing) * 3, slidersY, sliderWidth, 20, (Component)Component.m_237113_((String)"Text: "), (Component)Component.m_237113_((String)"x"), 0.3, 1.5, this.textScaleMultiplier, value -> {
                this.textScaleMultiplier = value;
                ConfigChangeManager.getInstance().setPendingValue("ui_customization.textScaleMultiplier", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.UI_TEXT_SCALE_MULTIPLIER);
                this.updatePreview();
            });
            this.m_142416_((GuiEventListener)this.textScaleSlider);
            this.baseButtonY = buttonsY = slidersY + 35;
            int buttonSpacing = 10;
            int preferredButtonWidth = 80;
            int minButtonWidth = 60;
            int numButtons = 3;
            int totalButtonWidth = preferredButtonWidth * numButtons + buttonSpacing * (numButtons - 1);
            int buttonsStartX = panelX + (panelWidth - totalButtonWidth) / 2;
            if (totalButtonWidth > availableWidth) {
                int maxButtonWidth = (availableWidth - buttonSpacing * (numButtons - 1)) / numButtons;
                preferredButtonWidth = Math.max(minButtonWidth, maxButtonWidth);
                totalButtonWidth = preferredButtonWidth * numButtons + buttonSpacing * (numButtons - 1);
                buttonsStartX = panelX + (panelWidth - totalButtonWidth) / 2;
            }
            if ((buttonsStartX = Math.max(absoluteMinMargin, buttonsStartX)) + totalButtonWidth > panelWidth - absoluteMinMargin && (buttonsStartX = panelWidth - absoluteMinMargin - totalButtonWidth) < absoluteMinMargin) {
                buttonsStartX = absoluteMinMargin;
                preferredButtonWidth = Math.max(50, (availableWidth - buttonSpacing * (numButtons - 1)) / numButtons);
            }
            this.resetButton = Button.m_253074_((Component)Component.m_237113_((String)"Reset All"), button -> {
                ConfigChangeManager manager = ConfigChangeManager.getInstance();
                manager.setPendingValue("ui_customization.iconSizeMultiplier", 1.0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.UI_ICON_SIZE_MULTIPLIER);
                manager.setPendingValue("ui_customization.iconSpacingMultiplier", 1.0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.UI_ICON_SPACING_MULTIPLIER);
                manager.setPendingValue("ui_customization.textOffsetFromIcons", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.UI_TEXT_OFFSET_FROM_ICONS);
                manager.setPendingValue("ui_customization.textScaleMultiplier", 1.0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.UI_TEXT_SCALE_MULTIPLIER);
                this.iconSizeMultiplier = 1.0;
                this.iconSpacingMultiplier = 1.0;
                this.textOffsetFromIcons = 0;
                this.textScaleMultiplier = 1.0;
                this.updatePreview();
                this.m_169413_();
                this.m_7856_();
            }).m_252987_(buttonsStartX, buttonsY, preferredButtonWidth, 20).m_253136_();
            this.m_142416_((GuiEventListener)this.resetButton);
            this.cancelButton = Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), button -> {
                ConfigChangeManager.getInstance().discardAllChanges();
                this.iconSizeMultiplier = (Double)AlienFirstPersonConfig.UI_ICON_SIZE_MULTIPLIER.get();
                this.iconSpacingMultiplier = (Double)AlienFirstPersonConfig.UI_ICON_SPACING_MULTIPLIER.get();
                this.textOffsetFromIcons = (Integer)AlienFirstPersonConfig.UI_TEXT_OFFSET_FROM_ICONS.get();
                this.textScaleMultiplier = (Double)AlienFirstPersonConfig.UI_TEXT_SCALE_MULTIPLIER.get();
                this.updatePreview();
                this.m_169413_();
                this.m_7856_();
            }).m_252987_(buttonsStartX + preferredButtonWidth + buttonSpacing, buttonsY, preferredButtonWidth, 20).m_253136_();
            this.m_142416_((GuiEventListener)this.cancelButton);
            this.doneButton = Button.m_253074_((Component)Component.m_237113_((String)"Done"), button -> this.m_7379_()).m_252987_(buttonsStartX + (preferredButtonWidth + buttonSpacing) * 2, buttonsY, preferredButtonWidth, 20).m_253136_();
            this.m_142416_((GuiEventListener)this.doneButton);
            int toggleWidth = 40;
            int toggleHeight = 12;
            int toggleX = this.f_96543_ / 2 - toggleWidth / 2;
            int toggleY = this.baseToggleY;
            this.toggleButton = new ToggleMenuButton(toggleX, toggleY, toggleWidth, toggleHeight, button -> this.togglePanel());
            this.m_142416_((GuiEventListener)this.toggleButton);
        }

        private void updatePreview() {
            this.backgroundRenderer.updateSettings(this.iconSizeMultiplier, this.iconSpacingMultiplier, this.textOffsetFromIcons, this.textScaleMultiplier);
        }

        private void togglePanel() {
            if (!this.isToggleAnimating) {
                this.isToggleAnimating = true;
                boolean bl = this.panelVisible = !this.panelVisible;
                if (this.panelVisible) {
                    this.targetOffset = 0.0f;
                    if (this.f_96541_ != null) {
                        this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)AlienSoundEvents.CUSTOM_OPEN.get()), (float)1.0f));
                    }
                } else {
                    this.targetOffset = 120.0f;
                    if (this.f_96541_ != null) {
                        this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)AlienSoundEvents.CUSTOM_CLOSE.get()), (float)1.0f));
                    }
                }
            }
        }

        public void m_86600_() {
            super.m_86600_();
            if (this.isAnimating || this.isToggleAnimating) {
                float difference = this.targetOffset - this.panelOffset;
                if (Math.abs(difference) < 0.5f) {
                    this.panelOffset = this.targetOffset;
                    this.isAnimating = false;
                    this.isToggleAnimating = false;
                } else {
                    this.panelOffset += difference * 0.3f;
                }
                this.updateWidgetPositions();
            }
            if (this.backgroundRenderer != null) {
                this.backgroundRenderer.setCurrentPanelOffset(this.panelOffset);
            }
        }

        private void updateWidgetPositions() {
            int offset = (int)this.panelOffset;
            if (this.iconSizeSlider != null) {
                this.iconSizeSlider.m_253211_(this.baseSliderY + offset);
            }
            if (this.iconSpacingSlider != null) {
                this.iconSpacingSlider.m_253211_(this.baseSliderY + offset);
            }
            if (this.textOffsetSlider != null) {
                this.textOffsetSlider.m_253211_(this.baseSliderY + offset);
            }
            if (this.textScaleSlider != null) {
                this.textScaleSlider.m_253211_(this.baseSliderY + offset);
            }
            if (this.resetButton != null) {
                this.resetButton.m_253211_(this.baseButtonY + offset);
            }
            if (this.cancelButton != null) {
                this.cancelButton.m_253211_(this.baseButtonY + offset);
            }
            if (this.doneButton != null) {
                this.doneButton.m_253211_(this.baseButtonY + offset);
            }
            if (this.toggleButton != null) {
                this.toggleButton.m_253211_(this.baseToggleY + offset);
            }
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.m_280273_(guiGraphics);
            if (this.backgroundRenderer != null) {
                this.backgroundRenderer.render(guiGraphics, mouseX, mouseY, partialTick);
            }
            int panelY = this.f_96544_ - 120 + (int)this.panelOffset;
            guiGraphics.m_280509_(0, panelY, this.f_96543_, this.f_96544_, -536870912);
            guiGraphics.m_280509_(0, panelY, this.f_96543_, panelY + 2, -13325526);
            guiGraphics.m_280137_(this.f_96547_, "UI Customization", this.f_96543_ / 2, panelY + 10, -13325526);
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            if (this.fadeInAlpha > 0.0f && !this.isClosing) {
                this.fadeInAlpha = Math.max(this.fadeInAlpha - 0.02f, 0.0f);
                int greenColor = (int)(this.fadeInAlpha * 0.8f * 255.0f) << 24 | 0xFF00;
                guiGraphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, greenColor);
            }
        }

        public void m_7379_() {
            this.isClosing = true;
            ConfigChangeManager.getInstance().applyAllChanges();
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.previousScreen);
            }
        }

        public boolean m_7043_() {
            return false;
        }
    }
}

