/*
 * Decompiled with CFR 0.152.
 */
package com.parad.alienfirstperson.config.aliens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.parad.alienfirstperson.AlienFirstPersonMod;
import com.parad.alienfirstperson.AlienOffsetManager;
import com.parad.alienfirstperson.config.AlienFirstPersonConfig;
import com.parad.alienfirstperson.config.ConfigChangeManager;
import com.parad.alienfirstperson.config.SafeIntSlider;
import com.parad.alienfirstperson.config.ScrollableScreen;
import dev.tr7zw.firstperson.FirstPersonModelCore;
import dev.tr7zw.firstperson.versionless.config.VanillaHands;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;

@OnlyIn(value=Dist.CLIENT)
public class GalvanConfigScreen
extends ScrollableScreen {
    private static final ResourceLocation GALVAN_LIMBS_ICON = new ResourceLocation("alien_first_person", "textures/gui/galvan_limbs.png");
    private static final ResourceLocation GALVAN_SUIT_ICON = new ResourceLocation("alien_first_person", "textures/gui/galvan_suit.png");
    private boolean firstPersonEnabled;
    private int standingXOffset;
    private int sneakingXOffset;
    private int fovScaler;
    private boolean fovAffectsHands;
    private boolean dynamicMode;
    private String vanillaHandsMode;

    @Override
    protected void reloadCurrentValues() {
        this.firstPersonEnabled = (Boolean)AlienFirstPersonConfig.GALVAN_FIRST_PERSON_ENABLED.get();
        this.standingXOffset = (Integer)AlienFirstPersonConfig.GALVAN_STANDING_X_OFFSET.get();
        this.sneakingXOffset = (Integer)AlienFirstPersonConfig.GALVAN_SNEAKING_X_OFFSET.get();
        this.fovScaler = (Integer)AlienFirstPersonConfig.GALVAN_FOV_SCALER.get();
        this.fovAffectsHands = (Boolean)AlienFirstPersonConfig.GALVAN_FOV_AFFECTS_HANDS.get();
        this.dynamicMode = (Boolean)AlienFirstPersonConfig.GALVAN_DYNAMIC_MODE.get();
        this.vanillaHandsMode = (String)AlienFirstPersonConfig.GALVAN_VANILLA_HANDS_MODE.get();
    }

    public GalvanConfigScreen(Screen previousScreen) {
        super((Component)Component.m_237113_((String)"Galvan Configuration"), previousScreen);
        ConfigChangeManager manager = ConfigChangeManager.getInstance();
        this.firstPersonEnabled = (Boolean)manager.getPendingOrCurrentValue("galvan.firstPersonEnabled", AlienFirstPersonConfig.GALVAN_FIRST_PERSON_ENABLED);
        this.standingXOffset = (Integer)manager.getPendingOrCurrentValue("galvan.standingXOffset", AlienFirstPersonConfig.GALVAN_STANDING_X_OFFSET);
        this.sneakingXOffset = (Integer)manager.getPendingOrCurrentValue("galvan.sneakingXOffset", AlienFirstPersonConfig.GALVAN_SNEAKING_X_OFFSET);
        this.fovScaler = (Integer)manager.getPendingOrCurrentValue("galvan.fovScaler", AlienFirstPersonConfig.GALVAN_FOV_SCALER);
        this.fovAffectsHands = (Boolean)manager.getPendingOrCurrentValue("galvan.fovAffectsHands", AlienFirstPersonConfig.GALVAN_FOV_AFFECTS_HANDS);
        this.dynamicMode = (Boolean)manager.getPendingOrCurrentValue("galvan.dynamicMode", AlienFirstPersonConfig.GALVAN_DYNAMIC_MODE);
        this.vanillaHandsMode = manager.getPendingOrCurrentValue("galvan.vanillaHandsMode", AlienFirstPersonConfig.GALVAN_VANILLA_HANDS_MODE);
    }

    @Override
    protected void initScrollableContent() {
        ConfigChangeManager manager = ConfigChangeManager.getInstance();
        this.firstPersonEnabled = (Boolean)manager.getPendingOrCurrentValue("galvan.firstPersonEnabled", AlienFirstPersonConfig.GALVAN_FIRST_PERSON_ENABLED);
        this.standingXOffset = (Integer)manager.getPendingOrCurrentValue("galvan.standingXOffset", AlienFirstPersonConfig.GALVAN_STANDING_X_OFFSET);
        this.sneakingXOffset = (Integer)manager.getPendingOrCurrentValue("galvan.sneakingXOffset", AlienFirstPersonConfig.GALVAN_SNEAKING_X_OFFSET);
        this.fovScaler = (Integer)manager.getPendingOrCurrentValue("galvan.fovScaler", AlienFirstPersonConfig.GALVAN_FOV_SCALER);
        this.fovAffectsHands = (Boolean)manager.getPendingOrCurrentValue("galvan.fovAffectsHands", AlienFirstPersonConfig.GALVAN_FOV_AFFECTS_HANDS);
        this.dynamicMode = (Boolean)manager.getPendingOrCurrentValue("galvan.dynamicMode", AlienFirstPersonConfig.GALVAN_DYNAMIC_MODE);
        this.vanillaHandsMode = manager.getPendingOrCurrentValue("galvan.vanillaHandsMode", AlienFirstPersonConfig.GALVAN_VANILLA_HANDS_MODE);
        int centerX = this.f_96543_ / 2;
        int currentY = 20;
        int ySpacing = 40;
        int sliderWidth = 200;
        Button toggleButton = Button.m_253074_((Component)Component.m_237113_((String)("First Person Model: " + (this.firstPersonEnabled ? "ENABLED" : "DISABLED"))), button -> {
            this.firstPersonEnabled = !this.firstPersonEnabled;
            manager.setPendingValue("galvan.firstPersonEnabled", this.firstPersonEnabled, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_FIRST_PERSON_ENABLED);
            button.m_93666_((Component)Component.m_237113_((String)("First Person Model: " + (this.firstPersonEnabled ? "ENABLED" : "DISABLED"))));
            if (this.firstPersonEnabled && this.isCurrentlyInBaseGalvan() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                FirstPersonModelCore.instance.setEnabled(true);
                FirstPersonModelCore.instance.getConfig().dynamicMode = this.dynamicMode;
                try {
                    VanillaHands vanillaHands;
                    FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHands = VanillaHands.valueOf((String)this.vanillaHandsMode);
                    AlienFirstPersonMod.LOGGER.info("Synced visual preview with pending base Galvan settings");
                }
                catch (IllegalArgumentException e) {
                    AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: {}", (Object)this.vanillaHandsMode);
                }
            }
            this.onConfigChanged();
            this.rebuildScrollableContent();
        }).m_252987_(centerX - 100, currentY, 200, 20).m_253136_();
        this.addScrollableWidget(toggleButton);
        currentY += ySpacing;
        if (this.firstPersonEnabled) {
            this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("  Dynamic Mode: " + (this.dynamicMode ? "ON" : "OFF"))), button -> {
                this.dynamicMode = !this.dynamicMode;
                manager.setPendingValue("galvan.dynamicMode", this.dynamicMode, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_DYNAMIC_MODE);
                button.m_93666_((Component)Component.m_237113_((String)("  Dynamic Mode: " + (this.dynamicMode ? "ON" : "OFF"))));
                if (this.isCurrentlyInBaseGalvan() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                    FirstPersonModelCore.instance.getConfig().dynamicMode = this.dynamicMode;
                    AlienFirstPersonMod.LOGGER.info("Applied base Galvan dynamic mode to visual preview");
                }
                this.onConfigChanged();
            }).m_252987_(centerX - 90, currentY, 180, 20).m_253136_());
            this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("  Vanilla Hands: " + this.getVanillaHandsDisplayName(this.vanillaHandsMode))), button -> {
                this.vanillaHandsMode = this.getNextVanillaHandsMode(this.vanillaHandsMode);
                manager.setPendingValue("galvan.vanillaHandsMode", this.vanillaHandsMode, AlienFirstPersonConfig.GALVAN_VANILLA_HANDS_MODE);
                button.m_93666_((Component)Component.m_237113_((String)("  Vanilla Hands: " + this.getVanillaHandsDisplayName(this.vanillaHandsMode))));
                if (this.isCurrentlyInBaseGalvan() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                    try {
                        VanillaHands vanillaHandsEnum;
                        FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHandsEnum = VanillaHands.valueOf((String)this.vanillaHandsMode);
                        AlienFirstPersonMod.LOGGER.info("Applied base Galvan vanilla hands to visual preview");
                    }
                    catch (IllegalArgumentException e) {
                        AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: {}", (Object)this.vanillaHandsMode);
                    }
                }
                this.onConfigChanged();
            }).m_252987_(centerX - 90, currentY += 30, 180, 20).m_253136_());
            this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2, currentY += ySpacing, sliderWidth, 20, (Component)Component.m_237113_((String)"Standing X Offset: "), (Component)Component.m_237113_((String)""), -60, 60, this.standingXOffset, value -> {
                this.standingXOffset = value;
                manager.setPendingValue("galvan.standingXOffset", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_STANDING_X_OFFSET);
                this.onConfigChanged();
            }, true));
            this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2, currentY += ySpacing, sliderWidth, 20, (Component)Component.m_237113_((String)"Sneaking X Offset: "), (Component)Component.m_237113_((String)""), -60, 60, this.sneakingXOffset, value -> {
                this.sneakingXOffset = value;
                manager.setPendingValue("galvan.sneakingXOffset", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_SNEAKING_X_OFFSET);
                this.onConfigChanged();
            }, true));
            currentY += ySpacing;
        }
        this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2, currentY, sliderWidth, 20, (Component)Component.m_237113_((String)"FOV Scaler: "), (Component)Component.m_237113_((String)""), -60, 60, this.fovScaler, value -> {
            this.fovScaler = value;
            manager.setPendingValue("galvan.fovScaler", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_FOV_SCALER);
            this.onConfigChanged();
        }, true));
        this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("FOV on Vanilla Hands: " + (this.fovAffectsHands ? "ENABLED" : "DISABLED"))), button -> {
            this.fovAffectsHands = !this.fovAffectsHands;
            manager.setPendingValue("galvan.fovAffectsHands", this.fovAffectsHands, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_FOV_AFFECTS_HANDS);
            button.m_93666_((Component)Component.m_237113_((String)("FOV on Vanilla Hands: " + (this.fovAffectsHands ? "ENABLED" : "DISABLED"))));
            this.onConfigChanged();
        }).m_252987_(centerX - 100, currentY += ySpacing, 200, 20).m_253136_());
        this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)"Reset to Defaults"), button -> {
            this.firstPersonEnabled = true;
            this.standingXOffset = 0;
            this.sneakingXOffset = 0;
            this.fovScaler = 0;
            this.fovAffectsHands = true;
            this.dynamicMode = true;
            this.vanillaHandsMode = "OFF";
            manager.setPendingValue("galvan.firstPersonEnabled", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_FIRST_PERSON_ENABLED);
            manager.setPendingValue("galvan.standingXOffset", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_STANDING_X_OFFSET);
            manager.setPendingValue("galvan.sneakingXOffset", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_SNEAKING_X_OFFSET);
            manager.setPendingValue("galvan.fovScaler", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_FOV_SCALER);
            manager.setPendingValue("galvan.fovAffectsHands", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_FOV_AFFECTS_HANDS);
            manager.setPendingValue("galvan.dynamicMode", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_DYNAMIC_MODE);
            manager.setPendingValue("galvan.vanillaHandsMode", "OFF", AlienFirstPersonConfig.GALVAN_VANILLA_HANDS_MODE);
            if (this.isCurrentlyInBaseGalvan() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                FirstPersonModelCore.instance.getConfig().dynamicMode = true;
                try {
                    VanillaHands vanillaHands;
                    FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHands = VanillaHands.valueOf((String)"OFF");
                    AlienFirstPersonMod.LOGGER.info("Applied reset defaults to visual preview (base Galvan)");
                }
                catch (IllegalArgumentException e) {
                    AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: OFF");
                }
            }
            this.onConfigChanged();
            this.rebuildScrollableContent();
            AlienFirstPersonMod.LOGGER.info("Reset Galvan config to defaults (pending)");
        }).m_252987_(centerX - 75, currentY += ySpacing, 150, 20).m_253136_());
        int iconSize = 64;
        int spacing = 100;
        int totalWidth = iconSize * 2 + spacing;
        int startX = centerX - totalWidth / 2;
        this.addScrollableWidget(new GalvanAbilityButton(startX, currentY += ySpacing + 20, iconSize, iconSize, GALVAN_LIMBS_ICON, (Component)Component.m_237113_((String)"Limbs"), button -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new GalvanLimbsConfigScreen(this));
            }
        }));
        this.addScrollableWidget(new GalvanAbilityButton(startX + iconSize + spacing, currentY, iconSize, iconSize, GALVAN_SUIT_ICON, (Component)Component.m_237113_((String)"Suit"), button -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new GalvanSuitConfigScreen(this));
            }
        }));
        this.setContentHeight(currentY + 90);
    }

    private boolean isCurrentlyInBaseGalvan() {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return false;
        }
        String currentAlien = AlienOffsetManager.getCurrentAlienForm();
        if (!"galvan".equals(currentAlien)) {
            return false;
        }
        try {
            Collection allAbilities = AbilityUtil.getInstances((LivingEntity)Minecraft.m_91087_().f_91074_);
            if (allAbilities != null) {
                for (AbilityInstance ability : allAbilities) {
                    String abilityId;
                    if (ability == null || !ability.isEnabled() || !"galvan_limbs".equals(abilityId = ability.getConfiguration().getId()) && !"galvan_suit".equals(abilityId)) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            AlienFirstPersonMod.LOGGER.debug("Error checking if in base Galvan: {}", (Object)e.getMessage());
        }
        return true;
    }

    private String getVanillaHandsDisplayName(String mode) {
        switch (mode) {
            case "OFF": {
                return "OFF";
            }
            case "ITEMS": {
                return "Only Items";
            }
            case "ALL": {
                return "One Hand";
            }
            case "ALL_DOUBLE": {
                return "Both Hands";
            }
        }
        return "OFF";
    }

    private String getNextVanillaHandsMode(String current) {
        switch (current) {
            case "OFF": {
                return "ITEMS";
            }
            case "ITEMS": {
                return "ALL";
            }
            case "ALL": {
                return "ALL_DOUBLE";
            }
            case "ALL_DOUBLE": {
                return "OFF";
            }
        }
        return "OFF";
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class GalvanAbilityButton
    extends Button {
        private final ResourceLocation iconTexture;
        private float hoverAnimation = 0.0f;
        private static final float HOVER_SPEED = 0.2f;

        public GalvanAbilityButton(int x, int y, int width, int height, ResourceLocation iconTexture, Component message, Button.OnPress onPress) {
            super(x, y, width, height, message, onPress, f_252438_);
            this.iconTexture = iconTexture;
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.hoverAnimation = this.f_93622_ ? Math.min(this.hoverAnimation + 0.2f, 1.0f) : Math.max(this.hoverAnimation - 0.2f, 0.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            if (this.hoverAnimation > 0.0f) {
                int glowAlpha = (int)(64.0f * this.hoverAnimation);
                int glowColor = glowAlpha << 24 | 0xFF00;
                guiGraphics.m_280509_(this.m_252754_() - 4, this.m_252907_() - 4, this.m_252754_() + this.f_93618_ + 4, this.m_252907_() + this.f_93619_ + 4, glowColor);
            }
            float scale = 1.0f + this.hoverAnimation * 0.1f;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)this.m_252754_() + (float)this.f_93618_ / 2.0f, (float)this.m_252907_() + (float)this.f_93619_ / 2.0f, 0.0f);
            guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
            guiGraphics.m_280168_().m_252880_(-((float)this.m_252754_() + (float)this.f_93618_ / 2.0f), -((float)this.m_252907_() + (float)this.f_93619_ / 2.0f), 0.0f);
            guiGraphics.m_280411_(this.iconTexture, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, 0.0f, 0.0f, 16, 16, 16, 16);
            guiGraphics.m_280168_().m_85849_();
            guiGraphics.m_280653_(Minecraft.m_91087_().f_91062_, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + this.f_93619_ + 6, 0xFFFFFF);
            RenderSystem.disableBlend();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class GalvanSuitConfigScreen
    extends ScrollableScreen {
        private boolean suitFirstPersonEnabled;
        private int suitStandingXOffset;
        private int suitSneakingXOffset;
        private int suitFovScaler;
        private boolean suitFovAffectsHands;
        private boolean suitDynamicMode;
        private String suitVanillaHandsMode;
        private boolean suitDropdownOpen = false;

        @Override
        protected void reloadCurrentValues() {
            this.suitFirstPersonEnabled = (Boolean)AlienFirstPersonConfig.GALVAN_SUIT_FIRST_PERSON_ENABLED.get();
            this.suitStandingXOffset = (Integer)AlienFirstPersonConfig.GALVAN_SUIT_STANDING_X_OFFSET.get();
            this.suitSneakingXOffset = (Integer)AlienFirstPersonConfig.GALVAN_SUIT_SNEAKING_X_OFFSET.get();
            this.suitFovScaler = (Integer)AlienFirstPersonConfig.GALVAN_SUIT_FOV_SCALER.get();
            this.suitFovAffectsHands = (Boolean)AlienFirstPersonConfig.GALVAN_SUIT_FOV_AFFECTS_HANDS.get();
            this.suitDynamicMode = (Boolean)AlienFirstPersonConfig.GALVAN_SUIT_DYNAMIC_MODE.get();
            this.suitVanillaHandsMode = (String)AlienFirstPersonConfig.GALVAN_SUIT_VANILLA_HANDS_MODE.get();
        }

        public GalvanSuitConfigScreen(Screen previousScreen) {
            super((Component)Component.m_237113_((String)"Galvan Suit Configuration"), previousScreen);
            ConfigChangeManager manager = ConfigChangeManager.getInstance();
            this.suitFirstPersonEnabled = (Boolean)manager.getPendingOrCurrentValue("galvan.suit.firstPersonEnabled", AlienFirstPersonConfig.GALVAN_SUIT_FIRST_PERSON_ENABLED);
            this.suitStandingXOffset = (Integer)manager.getPendingOrCurrentValue("galvan.suit.standingXOffset", AlienFirstPersonConfig.GALVAN_SUIT_STANDING_X_OFFSET);
            this.suitSneakingXOffset = (Integer)manager.getPendingOrCurrentValue("galvan.suit.sneakingXOffset", AlienFirstPersonConfig.GALVAN_SUIT_SNEAKING_X_OFFSET);
            this.suitFovScaler = (Integer)manager.getPendingOrCurrentValue("galvan.suit.fovScaler", AlienFirstPersonConfig.GALVAN_SUIT_FOV_SCALER);
            this.suitFovAffectsHands = (Boolean)manager.getPendingOrCurrentValue("galvan.suit.fovAffectsHands", AlienFirstPersonConfig.GALVAN_SUIT_FOV_AFFECTS_HANDS);
            this.suitDynamicMode = (Boolean)manager.getPendingOrCurrentValue("galvan.suit.dynamicMode", AlienFirstPersonConfig.GALVAN_SUIT_DYNAMIC_MODE);
            this.suitVanillaHandsMode = manager.getPendingOrCurrentValue("galvan.suit.vanillaHandsMode", AlienFirstPersonConfig.GALVAN_SUIT_VANILLA_HANDS_MODE);
            this.suitDropdownOpen = this.suitFirstPersonEnabled;
        }

        @Override
        protected void initScrollableContent() {
            int centerX = this.f_96543_ / 2;
            int currentY = 20;
            int ySpacing = 30;
            int sliderWidth = 200;
            ConfigChangeManager manager = ConfigChangeManager.getInstance();
            Button suitToggle = Button.m_253074_((Component)Component.m_237113_((String)("Suit First Person: " + (this.suitFirstPersonEnabled ? "ENABLED" : "DISABLED"))), button -> {
                this.suitFirstPersonEnabled = !this.suitFirstPersonEnabled;
                manager.setPendingValue("galvan.suit.firstPersonEnabled", this.suitFirstPersonEnabled, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_SUIT_FIRST_PERSON_ENABLED);
                button.m_93666_((Component)Component.m_237113_((String)("Suit First Person: " + (this.suitFirstPersonEnabled ? "ENABLED" : "DISABLED"))));
                this.suitDropdownOpen = this.suitFirstPersonEnabled;
                if (this.suitFirstPersonEnabled && this.isCurrentlyInSuitMode() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                    FirstPersonModelCore.instance.setEnabled(true);
                    FirstPersonModelCore.instance.getConfig().dynamicMode = this.suitDynamicMode;
                    try {
                        VanillaHands vanillaHands;
                        FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHands = VanillaHands.valueOf((String)this.suitVanillaHandsMode);
                        AlienFirstPersonMod.LOGGER.info("Synced visual preview with pending suit settings");
                    }
                    catch (IllegalArgumentException e) {
                        AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: {}", (Object)this.suitVanillaHandsMode);
                    }
                }
                this.onConfigChanged();
                this.rebuildScrollableContent();
            }).m_252987_(centerX - 100, currentY, 200, 20).m_253136_();
            this.addScrollableWidget(suitToggle);
            currentY += ySpacing;
            if (this.suitDropdownOpen && this.suitFirstPersonEnabled) {
                this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("  Dynamic Mode: " + (this.suitDynamicMode ? "ON" : "OFF"))), button -> {
                    this.suitDynamicMode = !this.suitDynamicMode;
                    manager.setPendingValue("galvan.suit.dynamicMode", this.suitDynamicMode, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_SUIT_DYNAMIC_MODE);
                    button.m_93666_((Component)Component.m_237113_((String)("  Dynamic Mode: " + (this.suitDynamicMode ? "ON" : "OFF"))));
                    if (this.isCurrentlyInSuitMode() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                        FirstPersonModelCore.instance.getConfig().dynamicMode = this.suitDynamicMode;
                        AlienFirstPersonMod.LOGGER.info("Applied suit dynamic mode to visual preview");
                    }
                    this.onConfigChanged();
                }).m_252987_(centerX - 90, currentY, 180, 20).m_253136_());
                this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("  Vanilla Hands: " + this.getVanillaHandsDisplayName(this.suitVanillaHandsMode))), button -> {
                    this.suitVanillaHandsMode = this.getNextVanillaHandsMode(this.suitVanillaHandsMode);
                    manager.setPendingValue("galvan.suit.vanillaHandsMode", this.suitVanillaHandsMode, AlienFirstPersonConfig.GALVAN_SUIT_VANILLA_HANDS_MODE);
                    button.m_93666_((Component)Component.m_237113_((String)("  Vanilla Hands: " + this.getVanillaHandsDisplayName(this.suitVanillaHandsMode))));
                    if (this.isCurrentlyInSuitMode() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                        try {
                            VanillaHands vanillaHandsEnum;
                            FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHandsEnum = VanillaHands.valueOf((String)this.suitVanillaHandsMode);
                            AlienFirstPersonMod.LOGGER.info("Applied suit vanilla hands to visual preview");
                        }
                        catch (IllegalArgumentException e) {
                            AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: {}", (Object)this.suitVanillaHandsMode);
                        }
                    }
                    this.onConfigChanged();
                }).m_252987_(centerX - 90, currentY += 25, 180, 20).m_253136_());
                this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2 + 20, currentY += 30, sliderWidth - 40, 20, (Component)Component.m_237113_((String)"Standing X: "), (Component)Component.m_237113_((String)""), -60, 60, this.suitStandingXOffset, value -> {
                    this.suitStandingXOffset = value;
                    manager.setPendingValue("galvan.suit.standingXOffset", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_SUIT_STANDING_X_OFFSET);
                    this.onConfigChanged();
                }, true));
                this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2 + 20, currentY += 25, sliderWidth - 40, 20, (Component)Component.m_237113_((String)"Sneaking X: "), (Component)Component.m_237113_((String)""), -60, 60, this.suitSneakingXOffset, value -> {
                    this.suitSneakingXOffset = value;
                    manager.setPendingValue("galvan.suit.sneakingXOffset", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_SUIT_SNEAKING_X_OFFSET);
                    this.onConfigChanged();
                }, true));
                currentY += 25;
            }
            this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2, currentY, sliderWidth, 20, (Component)Component.m_237113_((String)"Suit FOV: "), (Component)Component.m_237113_((String)""), -60, 60, this.suitFovScaler, value -> {
                this.suitFovScaler = value;
                manager.setPendingValue("galvan.suit.fovScaler", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_SUIT_FOV_SCALER);
                this.onConfigChanged();
            }, true));
            this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("Suit FOV on Hands: " + (this.suitFovAffectsHands ? "ENABLED" : "DISABLED"))), button -> {
                this.suitFovAffectsHands = !this.suitFovAffectsHands;
                manager.setPendingValue("galvan.suit.fovAffectsHands", this.suitFovAffectsHands, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_SUIT_FOV_AFFECTS_HANDS);
                button.m_93666_((Component)Component.m_237113_((String)("Suit FOV on Hands: " + (this.suitFovAffectsHands ? "ENABLED" : "DISABLED"))));
                this.onConfigChanged();
            }).m_252987_(centerX - 100, currentY += 30, 200, 20).m_253136_());
            this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)"Reset All"), button -> {
                this.suitFirstPersonEnabled = true;
                this.suitStandingXOffset = 0;
                this.suitSneakingXOffset = 0;
                this.suitFovScaler = 0;
                this.suitFovAffectsHands = true;
                this.suitDynamicMode = true;
                this.suitVanillaHandsMode = "OFF";
                manager.setPendingValue("galvan.suit.firstPersonEnabled", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_SUIT_FIRST_PERSON_ENABLED);
                manager.setPendingValue("galvan.suit.standingXOffset", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_SUIT_STANDING_X_OFFSET);
                manager.setPendingValue("galvan.suit.sneakingXOffset", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_SUIT_SNEAKING_X_OFFSET);
                manager.setPendingValue("galvan.suit.fovScaler", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_SUIT_FOV_SCALER);
                manager.setPendingValue("galvan.suit.fovAffectsHands", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_SUIT_FOV_AFFECTS_HANDS);
                manager.setPendingValue("galvan.suit.dynamicMode", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_SUIT_DYNAMIC_MODE);
                manager.setPendingValue("galvan.suit.vanillaHandsMode", "OFF", AlienFirstPersonConfig.GALVAN_SUIT_VANILLA_HANDS_MODE);
                if (this.isCurrentlyInSuitMode() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                    FirstPersonModelCore.instance.getConfig().dynamicMode = true;
                    try {
                        VanillaHands vanillaHands;
                        FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHands = VanillaHands.valueOf((String)"OFF");
                        AlienFirstPersonMod.LOGGER.info("Applied suit reset defaults to visual preview");
                    }
                    catch (IllegalArgumentException e) {
                        AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: OFF");
                    }
                }
                this.suitDropdownOpen = true;
                this.onConfigChanged();
                this.rebuildScrollableContent();
                AlienFirstPersonMod.LOGGER.info("Reset Galvan Suit config to defaults (pending)");
            }).m_252987_(centerX - 50, currentY += ySpacing, 100, 20).m_253136_());
            this.setContentHeight(currentY + 50);
        }

        private boolean isCurrentlyInSuitMode() {
            if (Minecraft.m_91087_().f_91074_ == null) {
                return false;
            }
            String currentAlien = AlienOffsetManager.getCurrentAlienForm();
            if (!"galvan".equals(currentAlien)) {
                return false;
            }
            try {
                Collection allAbilities = AbilityUtil.getInstances((LivingEntity)Minecraft.m_91087_().f_91074_);
                if (allAbilities != null) {
                    for (AbilityInstance ability : allAbilities) {
                        String abilityId;
                        if (ability == null || !ability.isEnabled() || !"galvan_suit".equals(abilityId = ability.getConfiguration().getId())) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                AlienFirstPersonMod.LOGGER.debug("Error checking if in suit mode: {}", (Object)e.getMessage());
            }
            return false;
        }

        private String getVanillaHandsDisplayName(String mode) {
            switch (mode) {
                case "OFF": {
                    return "OFF";
                }
                case "ITEMS": {
                    return "Only Items";
                }
                case "ALL": {
                    return "One Hand";
                }
                case "ALL_DOUBLE": {
                    return "Both Hands";
                }
            }
            return "OFF";
        }

        private String getNextVanillaHandsMode(String current) {
            switch (current) {
                case "OFF": {
                    return "ITEMS";
                }
                case "ITEMS": {
                    return "ALL";
                }
                case "ALL": {
                    return "ALL_DOUBLE";
                }
                case "ALL_DOUBLE": {
                    return "OFF";
                }
            }
            return "OFF";
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class GalvanLimbsConfigScreen
    extends ScrollableScreen {
        private boolean limbsFirstPersonEnabled;
        private int limbsStandingXOffset;
        private int limbsSneakingXOffset;
        private int limbsFovScaler;
        private boolean limbsFovAffectsHands;
        private boolean limbsDynamicMode;
        private String limbsVanillaHandsMode;
        private boolean limbsDropdownOpen = false;

        @Override
        protected void reloadCurrentValues() {
            this.limbsFirstPersonEnabled = (Boolean)AlienFirstPersonConfig.GALVAN_LIMBS_FIRST_PERSON_ENABLED.get();
            this.limbsStandingXOffset = (Integer)AlienFirstPersonConfig.GALVAN_LIMBS_STANDING_X_OFFSET.get();
            this.limbsSneakingXOffset = (Integer)AlienFirstPersonConfig.GALVAN_LIMBS_SNEAKING_X_OFFSET.get();
            this.limbsFovScaler = (Integer)AlienFirstPersonConfig.GALVAN_LIMBS_FOV_SCALER.get();
            this.limbsFovAffectsHands = (Boolean)AlienFirstPersonConfig.GALVAN_LIMBS_FOV_AFFECTS_HANDS.get();
            this.limbsDynamicMode = (Boolean)AlienFirstPersonConfig.GALVAN_LIMBS_DYNAMIC_MODE.get();
            this.limbsVanillaHandsMode = (String)AlienFirstPersonConfig.GALVAN_LIMBS_VANILLA_HANDS_MODE.get();
        }

        public GalvanLimbsConfigScreen(Screen previousScreen) {
            super((Component)Component.m_237113_((String)"Galvan Limbs Configuration"), previousScreen);
            ConfigChangeManager manager = ConfigChangeManager.getInstance();
            this.limbsFirstPersonEnabled = (Boolean)manager.getPendingOrCurrentValue("galvan.limbs.firstPersonEnabled", AlienFirstPersonConfig.GALVAN_LIMBS_FIRST_PERSON_ENABLED);
            this.limbsStandingXOffset = (Integer)manager.getPendingOrCurrentValue("galvan.limbs.standingXOffset", AlienFirstPersonConfig.GALVAN_LIMBS_STANDING_X_OFFSET);
            this.limbsSneakingXOffset = (Integer)manager.getPendingOrCurrentValue("galvan.limbs.sneakingXOffset", AlienFirstPersonConfig.GALVAN_LIMBS_SNEAKING_X_OFFSET);
            this.limbsFovScaler = (Integer)manager.getPendingOrCurrentValue("galvan.limbs.fovScaler", AlienFirstPersonConfig.GALVAN_LIMBS_FOV_SCALER);
            this.limbsFovAffectsHands = (Boolean)manager.getPendingOrCurrentValue("galvan.limbs.fovAffectsHands", AlienFirstPersonConfig.GALVAN_LIMBS_FOV_AFFECTS_HANDS);
            this.limbsDynamicMode = (Boolean)manager.getPendingOrCurrentValue("galvan.limbs.dynamicMode", AlienFirstPersonConfig.GALVAN_LIMBS_DYNAMIC_MODE);
            this.limbsVanillaHandsMode = manager.getPendingOrCurrentValue("galvan.limbs.vanillaHandsMode", AlienFirstPersonConfig.GALVAN_LIMBS_VANILLA_HANDS_MODE);
            this.limbsDropdownOpen = this.limbsFirstPersonEnabled;
        }

        @Override
        protected void initScrollableContent() {
            int centerX = this.f_96543_ / 2;
            int currentY = 20;
            int ySpacing = 30;
            int sliderWidth = 200;
            ConfigChangeManager manager = ConfigChangeManager.getInstance();
            Button limbsToggle = Button.m_253074_((Component)Component.m_237113_((String)("Limbs First Person: " + (this.limbsFirstPersonEnabled ? "ENABLED" : "DISABLED"))), button -> {
                this.limbsFirstPersonEnabled = !this.limbsFirstPersonEnabled;
                manager.setPendingValue("galvan.limbs.firstPersonEnabled", this.limbsFirstPersonEnabled, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_LIMBS_FIRST_PERSON_ENABLED);
                button.m_93666_((Component)Component.m_237113_((String)("Limbs First Person: " + (this.limbsFirstPersonEnabled ? "ENABLED" : "DISABLED"))));
                this.limbsDropdownOpen = this.limbsFirstPersonEnabled;
                if (this.limbsFirstPersonEnabled && this.isCurrentlyInLimbsMode() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                    FirstPersonModelCore.instance.setEnabled(true);
                    FirstPersonModelCore.instance.getConfig().dynamicMode = this.limbsDynamicMode;
                    try {
                        VanillaHands vanillaHands;
                        FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHands = VanillaHands.valueOf((String)this.limbsVanillaHandsMode);
                        AlienFirstPersonMod.LOGGER.info("Synced visual preview with pending limbs settings");
                    }
                    catch (IllegalArgumentException e) {
                        AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: {}", (Object)this.limbsVanillaHandsMode);
                    }
                }
                this.onConfigChanged();
                this.rebuildScrollableContent();
            }).m_252987_(centerX - 100, currentY, 200, 20).m_253136_();
            this.addScrollableWidget(limbsToggle);
            currentY += ySpacing;
            if (this.limbsDropdownOpen && this.limbsFirstPersonEnabled) {
                this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("  Dynamic Mode: " + (this.limbsDynamicMode ? "ON" : "OFF"))), button -> {
                    this.limbsDynamicMode = !this.limbsDynamicMode;
                    manager.setPendingValue("galvan.limbs.dynamicMode", this.limbsDynamicMode, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_LIMBS_DYNAMIC_MODE);
                    button.m_93666_((Component)Component.m_237113_((String)("  Dynamic Mode: " + (this.limbsDynamicMode ? "ON" : "OFF"))));
                    if (this.isCurrentlyInLimbsMode() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                        FirstPersonModelCore.instance.getConfig().dynamicMode = this.limbsDynamicMode;
                        AlienFirstPersonMod.LOGGER.info("Applied limbs dynamic mode to visual preview");
                    }
                    this.onConfigChanged();
                }).m_252987_(centerX - 90, currentY, 180, 20).m_253136_());
                this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("  Vanilla Hands: " + this.getVanillaHandsDisplayName(this.limbsVanillaHandsMode))), button -> {
                    this.limbsVanillaHandsMode = this.getNextVanillaHandsMode(this.limbsVanillaHandsMode);
                    manager.setPendingValue("galvan.limbs.vanillaHandsMode", this.limbsVanillaHandsMode, AlienFirstPersonConfig.GALVAN_LIMBS_VANILLA_HANDS_MODE);
                    button.m_93666_((Component)Component.m_237113_((String)("  Vanilla Hands: " + this.getVanillaHandsDisplayName(this.limbsVanillaHandsMode))));
                    if (this.isCurrentlyInLimbsMode() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                        try {
                            VanillaHands vanillaHandsEnum;
                            FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHandsEnum = VanillaHands.valueOf((String)this.limbsVanillaHandsMode);
                            AlienFirstPersonMod.LOGGER.info("Applied limbs vanilla hands to visual preview");
                        }
                        catch (IllegalArgumentException e) {
                            AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: {}", (Object)this.limbsVanillaHandsMode);
                        }
                    }
                    this.onConfigChanged();
                }).m_252987_(centerX - 90, currentY += 25, 180, 20).m_253136_());
                this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2 + 20, currentY += 30, sliderWidth - 40, 20, (Component)Component.m_237113_((String)"Standing X: "), (Component)Component.m_237113_((String)""), -60, 60, this.limbsStandingXOffset, value -> {
                    this.limbsStandingXOffset = value;
                    manager.setPendingValue("galvan.limbs.standingXOffset", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_LIMBS_STANDING_X_OFFSET);
                    this.onConfigChanged();
                }, true));
                this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2 + 20, currentY += 25, sliderWidth - 40, 20, (Component)Component.m_237113_((String)"Sneaking X: "), (Component)Component.m_237113_((String)""), -60, 60, this.limbsSneakingXOffset, value -> {
                    this.limbsSneakingXOffset = value;
                    manager.setPendingValue("galvan.limbs.sneakingXOffset", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_LIMBS_SNEAKING_X_OFFSET);
                    this.onConfigChanged();
                }, true));
                currentY += 25;
            }
            this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2, currentY, sliderWidth, 20, (Component)Component.m_237113_((String)"Limbs FOV: "), (Component)Component.m_237113_((String)""), -60, 60, this.limbsFovScaler, value -> {
                this.limbsFovScaler = value;
                manager.setPendingValue("galvan.limbs.fovScaler", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_LIMBS_FOV_SCALER);
                this.onConfigChanged();
            }, true));
            this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("Limbs FOV on Hands: " + (this.limbsFovAffectsHands ? "ENABLED" : "DISABLED"))), button -> {
                this.limbsFovAffectsHands = !this.limbsFovAffectsHands;
                manager.setPendingValue("galvan.limbs.fovAffectsHands", this.limbsFovAffectsHands, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_LIMBS_FOV_AFFECTS_HANDS);
                button.m_93666_((Component)Component.m_237113_((String)("Limbs FOV on Hands: " + (this.limbsFovAffectsHands ? "ENABLED" : "DISABLED"))));
                this.onConfigChanged();
            }).m_252987_(centerX - 100, currentY += 30, 200, 20).m_253136_());
            this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)"Reset All"), button -> {
                this.limbsFirstPersonEnabled = true;
                this.limbsStandingXOffset = 0;
                this.limbsSneakingXOffset = 0;
                this.limbsFovScaler = 0;
                this.limbsFovAffectsHands = true;
                this.limbsDynamicMode = true;
                this.limbsVanillaHandsMode = "OFF";
                manager.setPendingValue("galvan.limbs.firstPersonEnabled", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_LIMBS_FIRST_PERSON_ENABLED);
                manager.setPendingValue("galvan.limbs.standingXOffset", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_LIMBS_STANDING_X_OFFSET);
                manager.setPendingValue("galvan.limbs.sneakingXOffset", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_LIMBS_SNEAKING_X_OFFSET);
                manager.setPendingValue("galvan.limbs.fovScaler", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_LIMBS_FOV_SCALER);
                manager.setPendingValue("galvan.limbs.fovAffectsHands", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_LIMBS_FOV_AFFECTS_HANDS);
                manager.setPendingValue("galvan.limbs.dynamicMode", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVAN_LIMBS_DYNAMIC_MODE);
                manager.setPendingValue("galvan.limbs.vanillaHandsMode", "OFF", AlienFirstPersonConfig.GALVAN_LIMBS_VANILLA_HANDS_MODE);
                if (this.isCurrentlyInLimbsMode() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                    FirstPersonModelCore.instance.getConfig().dynamicMode = true;
                    try {
                        VanillaHands vanillaHands;
                        FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHands = VanillaHands.valueOf((String)"OFF");
                        AlienFirstPersonMod.LOGGER.info("Applied limbs reset defaults to visual preview");
                    }
                    catch (IllegalArgumentException e) {
                        AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: OFF");
                    }
                }
                this.limbsDropdownOpen = true;
                this.onConfigChanged();
                this.rebuildScrollableContent();
                AlienFirstPersonMod.LOGGER.info("Reset Galvan Limbs config to defaults (pending)");
            }).m_252987_(centerX - 50, currentY += ySpacing, 100, 20).m_253136_());
            this.setContentHeight(currentY + 50);
        }

        private boolean isCurrentlyInLimbsMode() {
            if (Minecraft.m_91087_().f_91074_ == null) {
                return false;
            }
            String currentAlien = AlienOffsetManager.getCurrentAlienForm();
            if (!"galvan".equals(currentAlien)) {
                return false;
            }
            try {
                boolean hasLimbs = false;
                boolean hasSuit = false;
                Collection allAbilities = AbilityUtil.getInstances((LivingEntity)Minecraft.m_91087_().f_91074_);
                if (allAbilities != null) {
                    for (AbilityInstance ability : allAbilities) {
                        if (ability == null || !ability.isEnabled()) continue;
                        String abilityId = ability.getConfiguration().getId();
                        if ("galvan_limbs".equals(abilityId)) {
                            hasLimbs = true;
                        }
                        if (!"galvan_suit".equals(abilityId)) continue;
                        hasSuit = true;
                    }
                }
                return hasLimbs && !hasSuit;
            }
            catch (Exception e) {
                AlienFirstPersonMod.LOGGER.debug("Error checking if in limbs mode: {}", (Object)e.getMessage());
                return false;
            }
        }

        private String getVanillaHandsDisplayName(String mode) {
            switch (mode) {
                case "OFF": {
                    return "OFF";
                }
                case "ITEMS": {
                    return "Only Items";
                }
                case "ALL": {
                    return "One Hand";
                }
                case "ALL_DOUBLE": {
                    return "Both Hands";
                }
            }
            return "OFF";
        }

        private String getNextVanillaHandsMode(String current) {
            switch (current) {
                case "OFF": {
                    return "ITEMS";
                }
                case "ITEMS": {
                    return "ALL";
                }
                case "ALL": {
                    return "ALL_DOUBLE";
                }
                case "ALL_DOUBLE": {
                    return "OFF";
                }
            }
            return "OFF";
        }
    }
}

