/*
 * Decompiled with CFR 0.152.
 */
package com.parad.alienfirstperson.config.aliens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.parad.alienfirstperson.AlienFirstPersonMod;
import com.parad.alienfirstperson.AlienOffsetManager;
import com.parad.alienfirstperson.config.AlienFirstPersonConfig;
import com.parad.alienfirstperson.config.ConfigChangeManager;
import com.parad.alienfirstperson.config.SafeIntSlider;
import com.parad.alienfirstperson.config.ScrollableScreen;
import dev.tr7zw.firstperson.FirstPersonModelCore;
import dev.tr7zw.firstperson.versionless.config.VanillaHands;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;

@OnlyIn(value=Dist.CLIENT)
public class GalvanicMechamorphConfigScreen
extends ScrollableScreen {
    private static final ResourceLocation ROD_FORM_ICON = new ResourceLocation("alien_first_person", "textures/gui/rodform.png");
    private boolean firstPersonEnabled;
    private int standingXOffset;
    private int sneakingXOffset;
    private int fovScaler;
    private boolean fovAffectsHands;
    private boolean dynamicMode;
    private String vanillaHandsMode;
    private boolean glideFirstPersonEnabled;

    @Override
    protected void reloadCurrentValues() {
        this.firstPersonEnabled = (Boolean)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_FIRST_PERSON_ENABLED.get();
        this.standingXOffset = (Integer)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_STANDING_X_OFFSET.get();
        this.sneakingXOffset = (Integer)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_SNEAKING_X_OFFSET.get();
        this.fovScaler = (Integer)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_FOV_SCALER.get();
        this.fovAffectsHands = (Boolean)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_FOV_AFFECTS_HANDS.get();
        this.dynamicMode = (Boolean)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_DYNAMIC_MODE.get();
        this.vanillaHandsMode = (String)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_VANILLA_HANDS_MODE.get();
        this.glideFirstPersonEnabled = (Boolean)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_GLIDE_FIRST_PERSON_ENABLED.get();
    }

    public GalvanicMechamorphConfigScreen(Screen previousScreen) {
        super((Component)Component.m_237113_((String)"Galvanic Mechamorph Configuration"), previousScreen);
        ConfigChangeManager manager = ConfigChangeManager.getInstance();
        this.firstPersonEnabled = (Boolean)manager.getPendingOrCurrentValue("galvanic_mechamorph.firstPersonEnabled", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_FIRST_PERSON_ENABLED);
        this.standingXOffset = (Integer)manager.getPendingOrCurrentValue("galvanic_mechamorph.standingXOffset", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_STANDING_X_OFFSET);
        this.sneakingXOffset = (Integer)manager.getPendingOrCurrentValue("galvanic_mechamorph.sneakingXOffset", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_SNEAKING_X_OFFSET);
        this.fovScaler = (Integer)manager.getPendingOrCurrentValue("galvanic_mechamorph.fovScaler", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_FOV_SCALER);
        this.fovAffectsHands = (Boolean)manager.getPendingOrCurrentValue("galvanic_mechamorph.fovAffectsHands", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_FOV_AFFECTS_HANDS);
        this.dynamicMode = (Boolean)manager.getPendingOrCurrentValue("galvanic_mechamorph.dynamicMode", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_DYNAMIC_MODE);
        this.vanillaHandsMode = manager.getPendingOrCurrentValue("galvanic_mechamorph.vanillaHandsMode", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_VANILLA_HANDS_MODE);
        this.glideFirstPersonEnabled = (Boolean)manager.getPendingOrCurrentValue("galvanic_mechamorph.glideFirstPersonEnabled", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_GLIDE_FIRST_PERSON_ENABLED);
    }

    @Override
    protected void initScrollableContent() {
        ConfigChangeManager manager = ConfigChangeManager.getInstance();
        this.firstPersonEnabled = (Boolean)manager.getPendingOrCurrentValue("galvanic_mechamorph.firstPersonEnabled", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_FIRST_PERSON_ENABLED);
        this.standingXOffset = (Integer)manager.getPendingOrCurrentValue("galvanic_mechamorph.standingXOffset", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_STANDING_X_OFFSET);
        this.sneakingXOffset = (Integer)manager.getPendingOrCurrentValue("galvanic_mechamorph.sneakingXOffset", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_SNEAKING_X_OFFSET);
        this.fovScaler = (Integer)manager.getPendingOrCurrentValue("galvanic_mechamorph.fovScaler", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_FOV_SCALER);
        this.fovAffectsHands = (Boolean)manager.getPendingOrCurrentValue("galvanic_mechamorph.fovAffectsHands", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_FOV_AFFECTS_HANDS);
        this.dynamicMode = (Boolean)manager.getPendingOrCurrentValue("galvanic_mechamorph.dynamicMode", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_DYNAMIC_MODE);
        this.vanillaHandsMode = manager.getPendingOrCurrentValue("galvanic_mechamorph.vanillaHandsMode", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_VANILLA_HANDS_MODE);
        this.glideFirstPersonEnabled = (Boolean)manager.getPendingOrCurrentValue("galvanic_mechamorph.glideFirstPersonEnabled", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_GLIDE_FIRST_PERSON_ENABLED);
        int centerX = this.f_96543_ / 2;
        int currentY = 20;
        int ySpacing = 40;
        int sliderWidth = 200;
        Button toggleButton = Button.m_253074_((Component)Component.m_237113_((String)("First Person Model: " + (this.firstPersonEnabled ? "ENABLED" : "DISABLED"))), button -> {
            this.firstPersonEnabled = !this.firstPersonEnabled;
            manager.setPendingValue("galvanic_mechamorph.firstPersonEnabled", this.firstPersonEnabled, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_FIRST_PERSON_ENABLED);
            button.m_93666_((Component)Component.m_237113_((String)("First Person Model: " + (this.firstPersonEnabled ? "ENABLED" : "DISABLED"))));
            if (this.firstPersonEnabled && this.isCurrentlyInBaseGalvanicMechamorph() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                FirstPersonModelCore.instance.setEnabled(true);
                FirstPersonModelCore.instance.getConfig().dynamicMode = this.dynamicMode;
                try {
                    VanillaHands vanillaHands;
                    FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHands = VanillaHands.valueOf((String)this.vanillaHandsMode);
                    AlienFirstPersonMod.LOGGER.info("Synced visual preview with pending settings when enabling");
                }
                catch (IllegalArgumentException e) {
                    AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: {}", (Object)this.vanillaHandsMode);
                }
            }
            this.onConfigChanged();
            this.rebuildScrollableContent();
        }).m_252987_(centerX - 100, currentY, 200, 20).m_253136_();
        this.addScrollableWidget(toggleButton);
        currentY += ySpacing;
        if (this.firstPersonEnabled) {
            this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("  Dynamic Mode: " + (this.dynamicMode ? "ON" : "OFF"))), button -> {
                this.dynamicMode = !this.dynamicMode;
                manager.setPendingValue("galvanic_mechamorph.dynamicMode", this.dynamicMode, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_DYNAMIC_MODE);
                button.m_93666_((Component)Component.m_237113_((String)("  Dynamic Mode: " + (this.dynamicMode ? "ON" : "OFF"))));
                if (this.isCurrentlyInBaseGalvanicMechamorph() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                    FirstPersonModelCore.instance.getConfig().dynamicMode = this.dynamicMode;
                    AlienFirstPersonMod.LOGGER.info("Applied base Galvanic Mechamorph dynamic mode to visual preview");
                }
                this.onConfigChanged();
            }).m_252987_(centerX - 90, currentY, 180, 20).m_253136_());
            this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("  Vanilla Hands: " + this.getVanillaHandsDisplayName(this.vanillaHandsMode))), button -> {
                this.vanillaHandsMode = this.getNextVanillaHandsMode(this.vanillaHandsMode);
                manager.setPendingValue("galvanic_mechamorph.vanillaHandsMode", this.vanillaHandsMode, AlienFirstPersonConfig.GALVANIC_MECHAMORPH_VANILLA_HANDS_MODE);
                button.m_93666_((Component)Component.m_237113_((String)("  Vanilla Hands: " + this.getVanillaHandsDisplayName(this.vanillaHandsMode))));
                if (this.isCurrentlyInBaseGalvanicMechamorph() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                    try {
                        VanillaHands vanillaHandsEnum;
                        FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHandsEnum = VanillaHands.valueOf((String)this.vanillaHandsMode);
                        AlienFirstPersonMod.LOGGER.info("Applied base Galvanic Mechamorph vanilla hands to visual preview");
                    }
                    catch (IllegalArgumentException e) {
                        AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: {}", (Object)this.vanillaHandsMode);
                    }
                }
                this.onConfigChanged();
            }).m_252987_(centerX - 90, currentY += 30, 180, 20).m_253136_());
            this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2, currentY += ySpacing, sliderWidth, 20, (Component)Component.m_237113_((String)"Standing X Offset: "), (Component)Component.m_237113_((String)""), -60, 60, this.standingXOffset, value -> {
                this.standingXOffset = value;
                manager.setPendingValue("galvanic_mechamorph.standingXOffset", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_STANDING_X_OFFSET);
                this.onConfigChanged();
            }, true));
            this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2, currentY += ySpacing, sliderWidth, 20, (Component)Component.m_237113_((String)"Sneaking X Offset: "), (Component)Component.m_237113_((String)""), -60, 60, this.sneakingXOffset, value -> {
                this.sneakingXOffset = value;
                manager.setPendingValue("galvanic_mechamorph.sneakingXOffset", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_SNEAKING_X_OFFSET);
                this.onConfigChanged();
            }, true));
            currentY += ySpacing;
        }
        this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2, currentY, sliderWidth, 20, (Component)Component.m_237113_((String)"FOV Scaler: "), (Component)Component.m_237113_((String)""), -60, 60, this.fovScaler, value -> {
            this.fovScaler = value;
            manager.setPendingValue("galvanic_mechamorph.fovScaler", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_FOV_SCALER);
            this.onConfigChanged();
        }, true));
        this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("FOV on Vanilla Hands: " + (this.fovAffectsHands ? "ENABLED" : "DISABLED"))), button -> {
            this.fovAffectsHands = !this.fovAffectsHands;
            manager.setPendingValue("galvanic_mechamorph.fovAffectsHands", this.fovAffectsHands, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_FOV_AFFECTS_HANDS);
            button.m_93666_((Component)Component.m_237113_((String)("FOV on Vanilla Hands: " + (this.fovAffectsHands ? "ENABLED" : "DISABLED"))));
            this.onConfigChanged();
        }).m_252987_(centerX - 100, currentY += ySpacing, 200, 20).m_253136_());
        this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("Glide First Person: " + (this.glideFirstPersonEnabled ? "ENABLED" : "DISABLED"))), button -> {
            this.glideFirstPersonEnabled = !this.glideFirstPersonEnabled;
            manager.setPendingValue("galvanic_mechamorph.glideFirstPersonEnabled", this.glideFirstPersonEnabled, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_GLIDE_FIRST_PERSON_ENABLED);
            button.m_93666_((Component)Component.m_237113_((String)("Glide First Person: " + (this.glideFirstPersonEnabled ? "ENABLED" : "DISABLED"))));
            this.onConfigChanged();
        }).m_252987_(centerX - 100, currentY += ySpacing, 200, 20).m_253136_());
        this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)"Reset to Defaults"), button -> {
            this.firstPersonEnabled = true;
            this.standingXOffset = 0;
            this.sneakingXOffset = 0;
            this.fovScaler = 0;
            this.fovAffectsHands = true;
            this.dynamicMode = true;
            this.vanillaHandsMode = "OFF";
            this.glideFirstPersonEnabled = true;
            manager.setPendingValue("galvanic_mechamorph.firstPersonEnabled", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_FIRST_PERSON_ENABLED);
            manager.setPendingValue("galvanic_mechamorph.standingXOffset", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_STANDING_X_OFFSET);
            manager.setPendingValue("galvanic_mechamorph.sneakingXOffset", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_SNEAKING_X_OFFSET);
            manager.setPendingValue("galvanic_mechamorph.fovScaler", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_FOV_SCALER);
            manager.setPendingValue("galvanic_mechamorph.fovAffectsHands", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_FOV_AFFECTS_HANDS);
            manager.setPendingValue("galvanic_mechamorph.dynamicMode", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_DYNAMIC_MODE);
            manager.setPendingValue("galvanic_mechamorph.vanillaHandsMode", "OFF", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_VANILLA_HANDS_MODE);
            manager.setPendingValue("galvanic_mechamorph.glideFirstPersonEnabled", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_GLIDE_FIRST_PERSON_ENABLED);
            if (this.isCurrentlyInBaseGalvanicMechamorph() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                FirstPersonModelCore.instance.getConfig().dynamicMode = true;
                try {
                    VanillaHands vanillaHands;
                    FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHands = VanillaHands.valueOf((String)"OFF");
                    AlienFirstPersonMod.LOGGER.info("Applied reset defaults to visual preview (in base Galvanic Mechamorph)");
                }
                catch (IllegalArgumentException e) {
                    AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: OFF");
                }
            }
            this.onConfigChanged();
            this.rebuildScrollableContent();
            AlienFirstPersonMod.LOGGER.info("Reset Galvanic Mechamorph config to defaults (pending)");
        }).m_252987_(centerX - 75, currentY += ySpacing, 150, 20).m_253136_());
        this.addScrollableWidget(new RodFormButton(centerX - 32, currentY += ySpacing, 64, 64, ROD_FORM_ICON, (Component)Component.m_237113_((String)"Lightning Rod Form"), button -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new GalvanicMechamorphRodConfigScreen(this));
            }
        }));
        this.setContentHeight(currentY + 90);
    }

    private boolean isCurrentlyInBaseGalvanicMechamorph() {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return false;
        }
        String currentAlien = AlienOffsetManager.getCurrentAlienForm();
        if (!"galvanic_mechamorph".equals(currentAlien)) {
            return false;
        }
        try {
            Collection allAbilities = AbilityUtil.getInstances((LivingEntity)Minecraft.m_91087_().f_91074_);
            if (allAbilities != null) {
                for (AbilityInstance ability : allAbilities) {
                    String abilityId;
                    if (ability == null || !ability.isEnabled() || !"lightningpro".equals(abilityId = ability.getConfiguration().getId())) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            AlienFirstPersonMod.LOGGER.debug("Error checking if in base Galvanic Mechamorph: {}", (Object)e.getMessage());
        }
        return true;
    }

    private String getVanillaHandsDisplayName(String mode) {
        switch (mode) {
            case "OFF": {
                return "OFF";
            }
            case "ITEMS": {
                return "Only Items";
            }
            case "ALL": {
                return "One Hand";
            }
            case "ALL_DOUBLE": {
                return "Both Hands";
            }
        }
        return "OFF";
    }

    private String getNextVanillaHandsMode(String current) {
        switch (current) {
            case "OFF": {
                return "ITEMS";
            }
            case "ITEMS": {
                return "ALL";
            }
            case "ALL": {
                return "ALL_DOUBLE";
            }
            case "ALL_DOUBLE": {
                return "OFF";
            }
        }
        return "OFF";
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class RodFormButton
    extends Button {
        private final ResourceLocation iconTexture;
        private float hoverAnimation = 0.0f;
        private static final float HOVER_SPEED = 0.2f;

        public RodFormButton(int x, int y, int width, int height, ResourceLocation iconTexture, Component message, Button.OnPress onPress) {
            super(x, y, width, height, message, onPress, f_252438_);
            this.iconTexture = iconTexture;
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.hoverAnimation = this.f_93622_ ? Math.min(this.hoverAnimation + 0.2f, 1.0f) : Math.max(this.hoverAnimation - 0.2f, 0.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            if (this.hoverAnimation > 0.0f) {
                int glowAlpha = (int)(64.0f * this.hoverAnimation);
                int glowColor = glowAlpha << 24 | 0xFF00;
                guiGraphics.m_280509_(this.m_252754_() - 4, this.m_252907_() - 4, this.m_252754_() + this.f_93618_ + 4, this.m_252907_() + this.f_93619_ + 4, glowColor);
            }
            float scale = 1.0f + this.hoverAnimation * 0.1f;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)this.m_252754_() + (float)this.f_93618_ / 2.0f, (float)this.m_252907_() + (float)this.f_93619_ / 2.0f, 0.0f);
            guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
            guiGraphics.m_280168_().m_252880_(-((float)this.m_252754_() + (float)this.f_93618_ / 2.0f), -((float)this.m_252907_() + (float)this.f_93619_ / 2.0f), 0.0f);
            guiGraphics.m_280411_(this.iconTexture, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, 0.0f, 0.0f, 16, 16, 16, 16);
            guiGraphics.m_280168_().m_85849_();
            guiGraphics.m_280653_(Minecraft.m_91087_().f_91062_, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + this.f_93619_ + 6, 0xFFFFFF);
            RenderSystem.disableBlend();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class GalvanicMechamorphRodConfigScreen
    extends ScrollableScreen {
        private boolean rodFirstPersonEnabled;
        private int rodStandingXOffset;
        private int rodSneakingXOffset;
        private int rodFovScaler;
        private boolean rodFovAffectsHands;
        private boolean rodDynamicMode;
        private String rodVanillaHandsMode;
        private boolean rodDropdownOpen = false;

        @Override
        protected void reloadCurrentValues() {
            this.rodFirstPersonEnabled = (Boolean)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_FIRST_PERSON_ENABLED.get();
            this.rodStandingXOffset = (Integer)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_STANDING_X_OFFSET.get();
            this.rodSneakingXOffset = (Integer)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_SNEAKING_X_OFFSET.get();
            this.rodFovScaler = (Integer)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_FOV_SCALER.get();
            this.rodFovAffectsHands = (Boolean)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_FOV_AFFECTS_HANDS.get();
            this.rodDynamicMode = (Boolean)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_DYNAMIC_MODE.get();
            this.rodVanillaHandsMode = (String)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_VANILLA_HANDS_MODE.get();
        }

        public GalvanicMechamorphRodConfigScreen(Screen previousScreen) {
            super((Component)Component.m_237113_((String)"Lightning Rod Form Configuration"), previousScreen);
            ConfigChangeManager manager = ConfigChangeManager.getInstance();
            this.rodFirstPersonEnabled = (Boolean)manager.getPendingOrCurrentValue("galvanic_mechamorph.rod.firstPersonEnabled", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_FIRST_PERSON_ENABLED);
            this.rodStandingXOffset = (Integer)manager.getPendingOrCurrentValue("galvanic_mechamorph.rod.standingXOffset", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_STANDING_X_OFFSET);
            this.rodSneakingXOffset = (Integer)manager.getPendingOrCurrentValue("galvanic_mechamorph.rod.sneakingXOffset", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_SNEAKING_X_OFFSET);
            this.rodFovScaler = (Integer)manager.getPendingOrCurrentValue("galvanic_mechamorph.rod.fovScaler", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_FOV_SCALER);
            this.rodFovAffectsHands = (Boolean)manager.getPendingOrCurrentValue("galvanic_mechamorph.rod.fovAffectsHands", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_FOV_AFFECTS_HANDS);
            this.rodDynamicMode = (Boolean)manager.getPendingOrCurrentValue("galvanic_mechamorph.rod.dynamicMode", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_DYNAMIC_MODE);
            this.rodVanillaHandsMode = manager.getPendingOrCurrentValue("galvanic_mechamorph.rod.vanillaHandsMode", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_VANILLA_HANDS_MODE);
            this.rodDropdownOpen = this.rodFirstPersonEnabled;
        }

        @Override
        protected void initScrollableContent() {
            int centerX = this.f_96543_ / 2;
            int currentY = 20;
            int ySpacing = 30;
            int sliderWidth = 200;
            ConfigChangeManager manager = ConfigChangeManager.getInstance();
            Button rodToggle = Button.m_253074_((Component)Component.m_237113_((String)("Rod Form First Person: " + (this.rodFirstPersonEnabled ? "ENABLED" : "DISABLED"))), button -> {
                this.rodFirstPersonEnabled = !this.rodFirstPersonEnabled;
                manager.setPendingValue("galvanic_mechamorph.rod.firstPersonEnabled", this.rodFirstPersonEnabled, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_FIRST_PERSON_ENABLED);
                button.m_93666_((Component)Component.m_237113_((String)("Rod Form First Person: " + (this.rodFirstPersonEnabled ? "ENABLED" : "DISABLED"))));
                this.rodDropdownOpen = this.rodFirstPersonEnabled;
                if (this.rodFirstPersonEnabled && this.isCurrentlyInRodForm() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                    FirstPersonModelCore.instance.setEnabled(true);
                    FirstPersonModelCore.instance.getConfig().dynamicMode = this.rodDynamicMode;
                    try {
                        VanillaHands vanillaHands;
                        FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHands = VanillaHands.valueOf((String)this.rodVanillaHandsMode);
                        AlienFirstPersonMod.LOGGER.info("Synced visual preview with pending rod settings when enabling");
                    }
                    catch (IllegalArgumentException e) {
                        AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: {}", (Object)this.rodVanillaHandsMode);
                    }
                }
                this.onConfigChanged();
                this.rebuildScrollableContent();
            }).m_252987_(centerX - 100, currentY, 200, 20).m_253136_();
            this.addScrollableWidget(rodToggle);
            currentY += ySpacing;
            if (this.rodDropdownOpen && this.rodFirstPersonEnabled) {
                this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("  Dynamic Mode: " + (this.rodDynamicMode ? "ON" : "OFF"))), button -> {
                    this.rodDynamicMode = !this.rodDynamicMode;
                    manager.setPendingValue("galvanic_mechamorph.rod.dynamicMode", this.rodDynamicMode, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_DYNAMIC_MODE);
                    button.m_93666_((Component)Component.m_237113_((String)("  Dynamic Mode: " + (this.rodDynamicMode ? "ON" : "OFF"))));
                    if (this.isCurrentlyInRodForm() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                        FirstPersonModelCore.instance.getConfig().dynamicMode = this.rodDynamicMode;
                        AlienFirstPersonMod.LOGGER.info("Applied rod form dynamic mode to visual preview (in rod form)");
                    }
                    this.onConfigChanged();
                }).m_252987_(centerX - 80, currentY, 160, 20).m_253136_());
                this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("  Vanilla Hands: " + this.getVanillaHandsDisplayName(this.rodVanillaHandsMode))), button -> {
                    this.rodVanillaHandsMode = this.getNextVanillaHandsMode(this.rodVanillaHandsMode);
                    manager.setPendingValue("galvanic_mechamorph.rod.vanillaHandsMode", this.rodVanillaHandsMode, AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_VANILLA_HANDS_MODE);
                    button.m_93666_((Component)Component.m_237113_((String)("  Vanilla Hands: " + this.getVanillaHandsDisplayName(this.rodVanillaHandsMode))));
                    if (this.isCurrentlyInRodForm() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                        try {
                            VanillaHands vanillaHandsEnum;
                            FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHandsEnum = VanillaHands.valueOf((String)this.rodVanillaHandsMode);
                            AlienFirstPersonMod.LOGGER.info("Applied rod form vanilla hands to visual preview (in rod form)");
                        }
                        catch (IllegalArgumentException e) {
                            AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: {}", (Object)this.rodVanillaHandsMode);
                        }
                    }
                    this.onConfigChanged();
                }).m_252987_(centerX - 80, currentY += 25, 160, 20).m_253136_());
                this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2 + 20, currentY += 30, sliderWidth - 40, 20, (Component)Component.m_237113_((String)"Standing X: "), (Component)Component.m_237113_((String)""), -60, 60, this.rodStandingXOffset, value -> {
                    this.rodStandingXOffset = value;
                    manager.setPendingValue("galvanic_mechamorph.rod.standingXOffset", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_STANDING_X_OFFSET);
                    this.onConfigChanged();
                }, true));
                this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2 + 20, currentY += 25, sliderWidth - 40, 20, (Component)Component.m_237113_((String)"Sneaking X: "), (Component)Component.m_237113_((String)""), -60, 60, this.rodSneakingXOffset, value -> {
                    this.rodSneakingXOffset = value;
                    manager.setPendingValue("galvanic_mechamorph.rod.sneakingXOffset", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_SNEAKING_X_OFFSET);
                    this.onConfigChanged();
                }, true));
                currentY += 25;
            }
            this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2, currentY, sliderWidth, 20, (Component)Component.m_237113_((String)"Rod FOV: "), (Component)Component.m_237113_((String)""), -60, 60, this.rodFovScaler, value -> {
                this.rodFovScaler = value;
                manager.setPendingValue("galvanic_mechamorph.rod.fovScaler", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_FOV_SCALER);
                this.onConfigChanged();
            }, true));
            this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("Rod FOV on Hands: " + (this.rodFovAffectsHands ? "ENABLED" : "DISABLED"))), button -> {
                this.rodFovAffectsHands = !this.rodFovAffectsHands;
                manager.setPendingValue("galvanic_mechamorph.rod.fovAffectsHands", this.rodFovAffectsHands, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_FOV_AFFECTS_HANDS);
                button.m_93666_((Component)Component.m_237113_((String)("Rod FOV on Hands: " + (this.rodFovAffectsHands ? "ENABLED" : "DISABLED"))));
                this.onConfigChanged();
            }).m_252987_(centerX - 100, currentY += 30, 200, 20).m_253136_());
            this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)"Reset All"), button -> {
                this.rodFirstPersonEnabled = true;
                this.rodStandingXOffset = 0;
                this.rodSneakingXOffset = 0;
                this.rodFovScaler = 0;
                this.rodFovAffectsHands = true;
                this.rodDynamicMode = true;
                this.rodVanillaHandsMode = "OFF";
                manager.setPendingValue("galvanic_mechamorph.rod.firstPersonEnabled", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_FIRST_PERSON_ENABLED);
                manager.setPendingValue("galvanic_mechamorph.rod.standingXOffset", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_STANDING_X_OFFSET);
                manager.setPendingValue("galvanic_mechamorph.rod.sneakingXOffset", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_SNEAKING_X_OFFSET);
                manager.setPendingValue("galvanic_mechamorph.rod.fovScaler", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_FOV_SCALER);
                manager.setPendingValue("galvanic_mechamorph.rod.fovAffectsHands", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_FOV_AFFECTS_HANDS);
                manager.setPendingValue("galvanic_mechamorph.rod.dynamicMode", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_DYNAMIC_MODE);
                manager.setPendingValue("galvanic_mechamorph.rod.vanillaHandsMode", "OFF", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_VANILLA_HANDS_MODE);
                if (this.isCurrentlyInRodForm() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                    FirstPersonModelCore.instance.getConfig().dynamicMode = true;
                    try {
                        VanillaHands vanillaHands;
                        FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHands = VanillaHands.valueOf((String)"OFF");
                        AlienFirstPersonMod.LOGGER.info("Applied rod reset defaults to visual preview");
                    }
                    catch (IllegalArgumentException e) {
                        AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: OFF");
                    }
                }
                this.rodDropdownOpen = true;
                this.onConfigChanged();
                this.rebuildScrollableContent();
                AlienFirstPersonMod.LOGGER.info("Reset Galvanic Mechamorph Rod config to defaults (pending)");
            }).m_252987_(centerX - 50, currentY += ySpacing, 100, 20).m_253136_());
            this.setContentHeight(currentY + 50);
        }

        private boolean isCurrentlyInRodForm() {
            if (Minecraft.m_91087_().f_91074_ == null) {
                return false;
            }
            String currentAlien = AlienOffsetManager.getCurrentAlienForm();
            if (!"galvanic_mechamorph".equals(currentAlien)) {
                return false;
            }
            try {
                Collection allAbilities = AbilityUtil.getInstances((LivingEntity)Minecraft.m_91087_().f_91074_);
                if (allAbilities != null) {
                    for (AbilityInstance ability : allAbilities) {
                        String abilityId;
                        if (ability == null || !ability.isEnabled() || !"lightningpro".equals(abilityId = ability.getConfiguration().getId())) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                AlienFirstPersonMod.LOGGER.debug("Error checking if in rod form: {}", (Object)e.getMessage());
            }
            return false;
        }

        private String getVanillaHandsDisplayName(String mode) {
            switch (mode) {
                case "OFF": {
                    return "OFF";
                }
                case "ITEMS": {
                    return "Only Items";
                }
                case "ALL": {
                    return "One Hand";
                }
                case "ALL_DOUBLE": {
                    return "Both Hands";
                }
            }
            return "OFF";
        }

        private String getNextVanillaHandsMode(String current) {
            switch (current) {
                case "OFF": {
                    return "ITEMS";
                }
                case "ITEMS": {
                    return "ALL";
                }
                case "ALL": {
                    return "ALL_DOUBLE";
                }
                case "ALL_DOUBLE": {
                    return "OFF";
                }
            }
            return "OFF";
        }
    }
}

