/*
 * Decompiled with CFR 0.152.
 */
package com.parad.alienfirstperson.config.aliens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.parad.alienfirstperson.AlienFirstPersonMod;
import com.parad.alienfirstperson.AlienOffsetManager;
import com.parad.alienfirstperson.config.AlienFirstPersonConfig;
import com.parad.alienfirstperson.config.ConfigChangeManager;
import com.parad.alienfirstperson.config.SafeIntSlider;
import com.parad.alienfirstperson.config.ScrollableScreen;
import dev.tr7zw.firstperson.FirstPersonModelCore;
import dev.tr7zw.firstperson.versionless.config.VanillaHands;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;

@OnlyIn(value=Dist.CLIENT)
public class KineceleranConfigScreen
extends ScrollableScreen {
    private static final ResourceLocation SPEED_UP_ICON = new ResourceLocation("alien_first_person", "textures/gui/speed_up.png");
    private boolean firstPersonEnabled;
    private int standingXOffset;
    private int sneakingXOffset;
    private int fovScaler;
    private boolean fovAffectsHands;
    private boolean dynamicMode;
    private String vanillaHandsMode;

    @Override
    protected void reloadCurrentValues() {
        this.firstPersonEnabled = (Boolean)AlienFirstPersonConfig.KINECELERAN_FIRST_PERSON_ENABLED.get();
        this.standingXOffset = (Integer)AlienFirstPersonConfig.KINECELERAN_STANDING_X_OFFSET.get();
        this.sneakingXOffset = (Integer)AlienFirstPersonConfig.KINECELERAN_SNEAKING_X_OFFSET.get();
        this.fovScaler = (Integer)AlienFirstPersonConfig.KINECELERAN_FOV_SCALER.get();
        this.fovAffectsHands = (Boolean)AlienFirstPersonConfig.KINECELERAN_FOV_AFFECTS_HANDS.get();
        this.dynamicMode = (Boolean)AlienFirstPersonConfig.KINECELERAN_DYNAMIC_MODE.get();
        this.vanillaHandsMode = (String)AlienFirstPersonConfig.KINECELERAN_VANILLA_HANDS_MODE.get();
    }

    public KineceleranConfigScreen(Screen previousScreen) {
        super((Component)Component.m_237113_((String)"Kineceleran Configuration"), previousScreen);
        ConfigChangeManager manager = ConfigChangeManager.getInstance();
        this.firstPersonEnabled = (Boolean)manager.getPendingOrCurrentValue("kineceleran.firstPersonEnabled", AlienFirstPersonConfig.KINECELERAN_FIRST_PERSON_ENABLED);
        this.standingXOffset = (Integer)manager.getPendingOrCurrentValue("kineceleran.standingXOffset", AlienFirstPersonConfig.KINECELERAN_STANDING_X_OFFSET);
        this.sneakingXOffset = (Integer)manager.getPendingOrCurrentValue("kineceleran.sneakingXOffset", AlienFirstPersonConfig.KINECELERAN_SNEAKING_X_OFFSET);
        this.fovScaler = (Integer)manager.getPendingOrCurrentValue("kineceleran.fovScaler", AlienFirstPersonConfig.KINECELERAN_FOV_SCALER);
        this.fovAffectsHands = (Boolean)manager.getPendingOrCurrentValue("kineceleran.fovAffectsHands", AlienFirstPersonConfig.KINECELERAN_FOV_AFFECTS_HANDS);
        this.dynamicMode = (Boolean)manager.getPendingOrCurrentValue("kineceleran.dynamicMode", AlienFirstPersonConfig.KINECELERAN_DYNAMIC_MODE);
        this.vanillaHandsMode = manager.getPendingOrCurrentValue("kineceleran.vanillaHandsMode", AlienFirstPersonConfig.KINECELERAN_VANILLA_HANDS_MODE);
    }

    @Override
    protected void initScrollableContent() {
        ConfigChangeManager manager = ConfigChangeManager.getInstance();
        this.firstPersonEnabled = (Boolean)manager.getPendingOrCurrentValue("kineceleran.firstPersonEnabled", AlienFirstPersonConfig.KINECELERAN_FIRST_PERSON_ENABLED);
        this.standingXOffset = (Integer)manager.getPendingOrCurrentValue("kineceleran.standingXOffset", AlienFirstPersonConfig.KINECELERAN_STANDING_X_OFFSET);
        this.sneakingXOffset = (Integer)manager.getPendingOrCurrentValue("kineceleran.sneakingXOffset", AlienFirstPersonConfig.KINECELERAN_SNEAKING_X_OFFSET);
        this.fovScaler = (Integer)manager.getPendingOrCurrentValue("kineceleran.fovScaler", AlienFirstPersonConfig.KINECELERAN_FOV_SCALER);
        this.fovAffectsHands = (Boolean)manager.getPendingOrCurrentValue("kineceleran.fovAffectsHands", AlienFirstPersonConfig.KINECELERAN_FOV_AFFECTS_HANDS);
        this.dynamicMode = (Boolean)manager.getPendingOrCurrentValue("kineceleran.dynamicMode", AlienFirstPersonConfig.KINECELERAN_DYNAMIC_MODE);
        this.vanillaHandsMode = manager.getPendingOrCurrentValue("kineceleran.vanillaHandsMode", AlienFirstPersonConfig.KINECELERAN_VANILLA_HANDS_MODE);
        int centerX = this.f_96543_ / 2;
        int currentY = 20;
        int ySpacing = 40;
        int sliderWidth = 200;
        Button toggleButton = Button.m_253074_((Component)Component.m_237113_((String)("First Person Model: " + (this.firstPersonEnabled ? "ENABLED" : "DISABLED"))), button -> {
            this.firstPersonEnabled = !this.firstPersonEnabled;
            manager.setPendingValue("kineceleran.firstPersonEnabled", this.firstPersonEnabled, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_FIRST_PERSON_ENABLED);
            button.m_93666_((Component)Component.m_237113_((String)("First Person Model: " + (this.firstPersonEnabled ? "ENABLED" : "DISABLED"))));
            if (this.firstPersonEnabled && this.isCurrentlyInBaseKineceleran() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                FirstPersonModelCore.instance.setEnabled(true);
                FirstPersonModelCore.instance.getConfig().dynamicMode = this.dynamicMode;
                try {
                    VanillaHands vanillaHands;
                    FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHands = VanillaHands.valueOf((String)this.vanillaHandsMode);
                    AlienFirstPersonMod.LOGGER.info("Synced visual preview with pending base Kineceleran settings");
                }
                catch (IllegalArgumentException e) {
                    AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: {}", (Object)this.vanillaHandsMode);
                }
            }
            this.onConfigChanged();
            this.rebuildScrollableContent();
        }).m_252987_(centerX - 100, currentY, 200, 20).m_253136_();
        this.addScrollableWidget(toggleButton);
        currentY += ySpacing;
        if (this.firstPersonEnabled) {
            this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("  Dynamic Mode: " + (this.dynamicMode ? "ON" : "OFF"))), button -> {
                this.dynamicMode = !this.dynamicMode;
                manager.setPendingValue("kineceleran.dynamicMode", this.dynamicMode, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_DYNAMIC_MODE);
                button.m_93666_((Component)Component.m_237113_((String)("  Dynamic Mode: " + (this.dynamicMode ? "ON" : "OFF"))));
                if (this.isCurrentlyInBaseKineceleran() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                    FirstPersonModelCore.instance.getConfig().dynamicMode = this.dynamicMode;
                    AlienFirstPersonMod.LOGGER.info("Applied base Kineceleran dynamic mode to visual preview");
                }
                this.onConfigChanged();
            }).m_252987_(centerX - 90, currentY, 180, 20).m_253136_());
            this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("  Vanilla Hands: " + this.getVanillaHandsDisplayName(this.vanillaHandsMode))), button -> {
                this.vanillaHandsMode = this.getNextVanillaHandsMode(this.vanillaHandsMode);
                manager.setPendingValue("kineceleran.vanillaHandsMode", this.vanillaHandsMode, AlienFirstPersonConfig.KINECELERAN_VANILLA_HANDS_MODE);
                button.m_93666_((Component)Component.m_237113_((String)("  Vanilla Hands: " + this.getVanillaHandsDisplayName(this.vanillaHandsMode))));
                if (this.isCurrentlyInBaseKineceleran() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                    try {
                        VanillaHands vanillaHandsEnum;
                        FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHandsEnum = VanillaHands.valueOf((String)this.vanillaHandsMode);
                        AlienFirstPersonMod.LOGGER.info("Applied base Kineceleran vanilla hands to visual preview");
                    }
                    catch (IllegalArgumentException e) {
                        AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: {}", (Object)this.vanillaHandsMode);
                    }
                }
                this.onConfigChanged();
            }).m_252987_(centerX - 90, currentY += 30, 180, 20).m_253136_());
            this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2, currentY += ySpacing, sliderWidth, 20, (Component)Component.m_237113_((String)"Standing X Offset: "), (Component)Component.m_237113_((String)""), -60, 60, this.standingXOffset, value -> {
                this.standingXOffset = value;
                manager.setPendingValue("kineceleran.standingXOffset", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_STANDING_X_OFFSET);
                this.onConfigChanged();
            }, true));
            this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2, currentY += ySpacing, sliderWidth, 20, (Component)Component.m_237113_((String)"Sneaking X Offset: "), (Component)Component.m_237113_((String)""), -60, 60, this.sneakingXOffset, value -> {
                this.sneakingXOffset = value;
                manager.setPendingValue("kineceleran.sneakingXOffset", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_SNEAKING_X_OFFSET);
                this.onConfigChanged();
            }, true));
            currentY += ySpacing;
        }
        this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2, currentY, sliderWidth, 20, (Component)Component.m_237113_((String)"FOV Scaler: "), (Component)Component.m_237113_((String)""), -60, 60, this.fovScaler, value -> {
            this.fovScaler = value;
            manager.setPendingValue("kineceleran.fovScaler", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_FOV_SCALER);
            this.onConfigChanged();
        }, true));
        this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("FOV on Vanilla Hands: " + (this.fovAffectsHands ? "ENABLED" : "DISABLED"))), button -> {
            this.fovAffectsHands = !this.fovAffectsHands;
            manager.setPendingValue("kineceleran.fovAffectsHands", this.fovAffectsHands, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_FOV_AFFECTS_HANDS);
            button.m_93666_((Component)Component.m_237113_((String)("FOV on Vanilla Hands: " + (this.fovAffectsHands ? "ENABLED" : "DISABLED"))));
            this.onConfigChanged();
        }).m_252987_(centerX - 100, currentY += ySpacing, 200, 20).m_253136_());
        this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)"Reset to Defaults"), button -> {
            this.firstPersonEnabled = true;
            this.standingXOffset = 0;
            this.sneakingXOffset = 0;
            this.fovScaler = 0;
            this.fovAffectsHands = true;
            this.dynamicMode = true;
            this.vanillaHandsMode = "OFF";
            manager.setPendingValue("kineceleran.firstPersonEnabled", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_FIRST_PERSON_ENABLED);
            manager.setPendingValue("kineceleran.standingXOffset", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_STANDING_X_OFFSET);
            manager.setPendingValue("kineceleran.sneakingXOffset", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_SNEAKING_X_OFFSET);
            manager.setPendingValue("kineceleran.fovScaler", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_FOV_SCALER);
            manager.setPendingValue("kineceleran.fovAffectsHands", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_FOV_AFFECTS_HANDS);
            manager.setPendingValue("kineceleran.dynamicMode", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_DYNAMIC_MODE);
            manager.setPendingValue("kineceleran.vanillaHandsMode", "OFF", AlienFirstPersonConfig.KINECELERAN_VANILLA_HANDS_MODE);
            if (this.isCurrentlyInBaseKineceleran() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                FirstPersonModelCore.instance.getConfig().dynamicMode = true;
                try {
                    VanillaHands vanillaHands;
                    FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHands = VanillaHands.valueOf((String)"OFF");
                    AlienFirstPersonMod.LOGGER.info("Applied reset defaults to visual preview (base Kineceleran)");
                }
                catch (IllegalArgumentException e) {
                    AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: OFF");
                }
            }
            this.onConfigChanged();
            this.rebuildScrollableContent();
            AlienFirstPersonMod.LOGGER.info("Reset Kineceleran config to defaults (pending)");
        }).m_252987_(centerX - 75, currentY += ySpacing, 150, 20).m_253136_());
        this.addScrollableWidget(new SpeedUpButton(centerX - 32, currentY += ySpacing, 64, 64, SPEED_UP_ICON, (Component)Component.m_237113_((String)"Speed & Skate"), button -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new KineceleranAbilitiesScreen(this));
            }
        }));
        this.setContentHeight(currentY + 90);
    }

    private boolean isCurrentlyInBaseKineceleran() {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return false;
        }
        String currentAlien = AlienOffsetManager.getCurrentAlienForm();
        if (!"kineceleran".equals(currentAlien)) {
            return false;
        }
        try {
            Collection allAbilities = AbilityUtil.getInstances((LivingEntity)Minecraft.m_91087_().f_91074_);
            if (allAbilities != null) {
                for (AbilityInstance ability : allAbilities) {
                    String abilityId;
                    if (ability == null || !ability.isEnabled() || !"skate".equals(abilityId = ability.getConfiguration().getId()) && !"speed_1".equals(abilityId) && !"speed_2".equals(abilityId) && !"speed_3".equals(abilityId) && !"speed_4".equals(abilityId) && !"speed_5".equals(abilityId)) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            AlienFirstPersonMod.LOGGER.debug("Error checking if in base Kineceleran: {}", (Object)e.getMessage());
        }
        return true;
    }

    private String getVanillaHandsDisplayName(String mode) {
        switch (mode) {
            case "OFF": {
                return "OFF";
            }
            case "ITEMS": {
                return "Only Items";
            }
            case "ALL": {
                return "One Hand";
            }
            case "ALL_DOUBLE": {
                return "Both Hands";
            }
        }
        return "OFF";
    }

    private String getNextVanillaHandsMode(String current) {
        switch (current) {
            case "OFF": {
                return "ITEMS";
            }
            case "ITEMS": {
                return "ALL";
            }
            case "ALL": {
                return "ALL_DOUBLE";
            }
            case "ALL_DOUBLE": {
                return "OFF";
            }
        }
        return "OFF";
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SpeedUpButton
    extends Button {
        private final ResourceLocation iconTexture;
        private float hoverAnimation = 0.0f;
        private static final float HOVER_SPEED = 0.2f;

        public SpeedUpButton(int x, int y, int width, int height, ResourceLocation iconTexture, Component message, Button.OnPress onPress) {
            super(x, y, width, height, message, onPress, f_252438_);
            this.iconTexture = iconTexture;
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.hoverAnimation = this.f_93622_ ? Math.min(this.hoverAnimation + 0.2f, 1.0f) : Math.max(this.hoverAnimation - 0.2f, 0.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            if (this.hoverAnimation > 0.0f) {
                int glowAlpha = (int)(64.0f * this.hoverAnimation);
                int glowColor = glowAlpha << 24 | 0xFF00;
                guiGraphics.m_280509_(this.m_252754_() - 4, this.m_252907_() - 4, this.m_252754_() + this.f_93618_ + 4, this.m_252907_() + this.f_93619_ + 4, glowColor);
            }
            float scale = 1.0f + this.hoverAnimation * 0.1f;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)this.m_252754_() + (float)this.f_93618_ / 2.0f, (float)this.m_252907_() + (float)this.f_93619_ / 2.0f, 0.0f);
            guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
            guiGraphics.m_280168_().m_252880_(-((float)this.m_252754_() + (float)this.f_93618_ / 2.0f), -((float)this.m_252907_() + (float)this.f_93619_ / 2.0f), 0.0f);
            guiGraphics.m_280411_(this.iconTexture, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, 0.0f, 0.0f, 16, 16, 16, 16);
            guiGraphics.m_280168_().m_85849_();
            guiGraphics.m_280653_(Minecraft.m_91087_().f_91062_, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + this.f_93619_ + 6, 0xFFFFFF);
            RenderSystem.disableBlend();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class KineceleranAbilitiesScreen
    extends ScrollableScreen {
        private boolean speedFirstPersonEnabled;
        private int speedStandingXOffset;
        private int speedSneakingXOffset;
        private int speedFovScaler;
        private boolean speedFovAffectsHands;
        private boolean speedDynamicMode;
        private String speedVanillaHandsMode;
        private boolean skateFirstPersonEnabled;
        private int skateStandingXOffset;
        private int skateSneakingXOffset;
        private int skateFovScaler;
        private boolean skateFovAffectsHands;
        private boolean skateDynamicMode;
        private String skateVanillaHandsMode;
        private boolean speedDropdownOpen = false;
        private boolean skateDropdownOpen = false;

        @Override
        protected void reloadCurrentValues() {
            this.speedFirstPersonEnabled = (Boolean)AlienFirstPersonConfig.KINECELERAN_SPEED_FIRST_PERSON_ENABLED.get();
            this.speedStandingXOffset = (Integer)AlienFirstPersonConfig.KINECELERAN_SPEED_STANDING_X_OFFSET.get();
            this.speedSneakingXOffset = (Integer)AlienFirstPersonConfig.KINECELERAN_SPEED_SNEAKING_X_OFFSET.get();
            this.speedFovScaler = (Integer)AlienFirstPersonConfig.KINECELERAN_SPEED_FOV_SCALER.get();
            this.speedFovAffectsHands = (Boolean)AlienFirstPersonConfig.KINECELERAN_SPEED_FOV_AFFECTS_HANDS.get();
            this.speedDynamicMode = (Boolean)AlienFirstPersonConfig.KINECELERAN_SPEED_DYNAMIC_MODE.get();
            this.speedVanillaHandsMode = (String)AlienFirstPersonConfig.KINECELERAN_SPEED_VANILLA_HANDS_MODE.get();
            this.skateFirstPersonEnabled = (Boolean)AlienFirstPersonConfig.KINECELERAN_SKATE_FIRST_PERSON_ENABLED.get();
            this.skateStandingXOffset = (Integer)AlienFirstPersonConfig.KINECELERAN_SKATE_STANDING_X_OFFSET.get();
            this.skateSneakingXOffset = (Integer)AlienFirstPersonConfig.KINECELERAN_SKATE_SNEAKING_X_OFFSET.get();
            this.skateFovScaler = (Integer)AlienFirstPersonConfig.KINECELERAN_SKATE_FOV_SCALER.get();
            this.skateFovAffectsHands = (Boolean)AlienFirstPersonConfig.KINECELERAN_SKATE_FOV_AFFECTS_HANDS.get();
            this.skateDynamicMode = (Boolean)AlienFirstPersonConfig.KINECELERAN_SKATE_DYNAMIC_MODE.get();
            this.skateVanillaHandsMode = (String)AlienFirstPersonConfig.KINECELERAN_SKATE_VANILLA_HANDS_MODE.get();
        }

        public KineceleranAbilitiesScreen(Screen previousScreen) {
            super((Component)Component.m_237113_((String)"Kineceleran Speed & Skate Configuration"), previousScreen);
            ConfigChangeManager manager = ConfigChangeManager.getInstance();
            this.speedFirstPersonEnabled = (Boolean)manager.getPendingOrCurrentValue("kineceleran.speed.firstPersonEnabled", AlienFirstPersonConfig.KINECELERAN_SPEED_FIRST_PERSON_ENABLED);
            this.speedStandingXOffset = (Integer)manager.getPendingOrCurrentValue("kineceleran.speed.standingXOffset", AlienFirstPersonConfig.KINECELERAN_SPEED_STANDING_X_OFFSET);
            this.speedSneakingXOffset = (Integer)manager.getPendingOrCurrentValue("kineceleran.speed.sneakingXOffset", AlienFirstPersonConfig.KINECELERAN_SPEED_SNEAKING_X_OFFSET);
            this.speedFovScaler = (Integer)manager.getPendingOrCurrentValue("kineceleran.speed.fovScaler", AlienFirstPersonConfig.KINECELERAN_SPEED_FOV_SCALER);
            this.speedFovAffectsHands = (Boolean)manager.getPendingOrCurrentValue("kineceleran.speed.fovAffectsHands", AlienFirstPersonConfig.KINECELERAN_SPEED_FOV_AFFECTS_HANDS);
            this.speedDynamicMode = (Boolean)manager.getPendingOrCurrentValue("kineceleran.speed.dynamicMode", AlienFirstPersonConfig.KINECELERAN_SPEED_DYNAMIC_MODE);
            this.speedVanillaHandsMode = manager.getPendingOrCurrentValue("kineceleran.speed.vanillaHandsMode", AlienFirstPersonConfig.KINECELERAN_SPEED_VANILLA_HANDS_MODE);
            this.skateFirstPersonEnabled = (Boolean)manager.getPendingOrCurrentValue("kineceleran.skate.firstPersonEnabled", AlienFirstPersonConfig.KINECELERAN_SKATE_FIRST_PERSON_ENABLED);
            this.skateStandingXOffset = (Integer)manager.getPendingOrCurrentValue("kineceleran.skate.standingXOffset", AlienFirstPersonConfig.KINECELERAN_SKATE_STANDING_X_OFFSET);
            this.skateSneakingXOffset = (Integer)manager.getPendingOrCurrentValue("kineceleran.skate.sneakingXOffset", AlienFirstPersonConfig.KINECELERAN_SKATE_SNEAKING_X_OFFSET);
            this.skateFovScaler = (Integer)manager.getPendingOrCurrentValue("kineceleran.skate.fovScaler", AlienFirstPersonConfig.KINECELERAN_SKATE_FOV_SCALER);
            this.skateFovAffectsHands = (Boolean)manager.getPendingOrCurrentValue("kineceleran.skate.fovAffectsHands", AlienFirstPersonConfig.KINECELERAN_SKATE_FOV_AFFECTS_HANDS);
            this.skateDynamicMode = (Boolean)manager.getPendingOrCurrentValue("kineceleran.skate.dynamicMode", AlienFirstPersonConfig.KINECELERAN_SKATE_DYNAMIC_MODE);
            this.skateVanillaHandsMode = manager.getPendingOrCurrentValue("kineceleran.skate.vanillaHandsMode", AlienFirstPersonConfig.KINECELERAN_SKATE_VANILLA_HANDS_MODE);
            this.speedDropdownOpen = this.speedFirstPersonEnabled;
            this.skateDropdownOpen = this.skateFirstPersonEnabled;
        }

        @Override
        protected void initScrollableContent() {
            int centerX = this.f_96543_ / 2;
            int currentY = 20;
            int ySpacing = 30;
            int sliderWidth = 200;
            ConfigChangeManager manager = ConfigChangeManager.getInstance();
            Button speedToggle = Button.m_253074_((Component)Component.m_237113_((String)("Speed Boost First Person: " + (this.speedFirstPersonEnabled ? "ENABLED" : "DISABLED"))), button -> {
                this.speedFirstPersonEnabled = !this.speedFirstPersonEnabled;
                manager.setPendingValue("kineceleran.speed.firstPersonEnabled", this.speedFirstPersonEnabled, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_SPEED_FIRST_PERSON_ENABLED);
                button.m_93666_((Component)Component.m_237113_((String)("Speed Boost First Person: " + (this.speedFirstPersonEnabled ? "ENABLED" : "DISABLED"))));
                this.speedDropdownOpen = this.speedFirstPersonEnabled;
                if (this.speedFirstPersonEnabled && this.isCurrentlyInSpeedMode() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                    FirstPersonModelCore.instance.setEnabled(true);
                    FirstPersonModelCore.instance.getConfig().dynamicMode = this.speedDynamicMode;
                    try {
                        VanillaHands vanillaHands;
                        FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHands = VanillaHands.valueOf((String)this.speedVanillaHandsMode);
                        AlienFirstPersonMod.LOGGER.info("Synced visual preview with pending speed settings");
                    }
                    catch (IllegalArgumentException e) {
                        AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: {}", (Object)this.speedVanillaHandsMode);
                    }
                }
                this.onConfigChanged();
                this.rebuildScrollableContent();
            }).m_252987_(centerX - 100, currentY, 200, 20).m_253136_();
            this.addScrollableWidget(speedToggle);
            currentY += ySpacing;
            if (this.speedDropdownOpen && this.speedFirstPersonEnabled) {
                this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("  Dynamic Mode: " + (this.speedDynamicMode ? "ON" : "OFF"))), button -> {
                    this.speedDynamicMode = !this.speedDynamicMode;
                    manager.setPendingValue("kineceleran.speed.dynamicMode", this.speedDynamicMode, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_SPEED_DYNAMIC_MODE);
                    button.m_93666_((Component)Component.m_237113_((String)("  Dynamic Mode: " + (this.speedDynamicMode ? "ON" : "OFF"))));
                    if (this.isCurrentlyInSpeedMode() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                        FirstPersonModelCore.instance.getConfig().dynamicMode = this.speedDynamicMode;
                        AlienFirstPersonMod.LOGGER.info("Applied speed dynamic mode to visual preview");
                    }
                    this.onConfigChanged();
                }).m_252987_(centerX - 90, currentY, 180, 20).m_253136_());
                this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("  Vanilla Hands: " + this.getVanillaHandsDisplayName(this.speedVanillaHandsMode))), button -> {
                    this.speedVanillaHandsMode = this.getNextVanillaHandsMode(this.speedVanillaHandsMode);
                    manager.setPendingValue("kineceleran.speed.vanillaHandsMode", this.speedVanillaHandsMode, AlienFirstPersonConfig.KINECELERAN_SPEED_VANILLA_HANDS_MODE);
                    button.m_93666_((Component)Component.m_237113_((String)("  Vanilla Hands: " + this.getVanillaHandsDisplayName(this.speedVanillaHandsMode))));
                    if (this.isCurrentlyInSpeedMode() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                        try {
                            VanillaHands vanillaHandsEnum;
                            FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHandsEnum = VanillaHands.valueOf((String)this.speedVanillaHandsMode);
                            AlienFirstPersonMod.LOGGER.info("Applied speed vanilla hands to visual preview");
                        }
                        catch (IllegalArgumentException e) {
                            AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: {}", (Object)this.speedVanillaHandsMode);
                        }
                    }
                    this.onConfigChanged();
                }).m_252987_(centerX - 90, currentY += 25, 180, 20).m_253136_());
                this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2 + 20, currentY += 30, sliderWidth - 40, 20, (Component)Component.m_237113_((String)"Standing X: "), (Component)Component.m_237113_((String)""), -60, 60, this.speedStandingXOffset, value -> {
                    this.speedStandingXOffset = value;
                    manager.setPendingValue("kineceleran.speed.standingXOffset", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_SPEED_STANDING_X_OFFSET);
                    this.onConfigChanged();
                }, true));
                this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2 + 20, currentY += 25, sliderWidth - 40, 20, (Component)Component.m_237113_((String)"Sneaking X: "), (Component)Component.m_237113_((String)""), -60, 60, this.speedSneakingXOffset, value -> {
                    this.speedSneakingXOffset = value;
                    manager.setPendingValue("kineceleran.speed.sneakingXOffset", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_SPEED_SNEAKING_X_OFFSET);
                    this.onConfigChanged();
                }, true));
                currentY += 25;
            }
            this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2, currentY, sliderWidth, 20, (Component)Component.m_237113_((String)"Speed Boost FOV: "), (Component)Component.m_237113_((String)""), -60, 60, this.speedFovScaler, value -> {
                this.speedFovScaler = value;
                manager.setPendingValue("kineceleran.speed.fovScaler", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_SPEED_FOV_SCALER);
                this.onConfigChanged();
            }, true));
            this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("Speed FOV on Hands: " + (this.speedFovAffectsHands ? "ENABLED" : "DISABLED"))), button -> {
                this.speedFovAffectsHands = !this.speedFovAffectsHands;
                manager.setPendingValue("kineceleran.speed.fovAffectsHands", this.speedFovAffectsHands, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_SPEED_FOV_AFFECTS_HANDS);
                button.m_93666_((Component)Component.m_237113_((String)("Speed FOV on Hands: " + (this.speedFovAffectsHands ? "ENABLED" : "DISABLED"))));
                this.onConfigChanged();
            }).m_252987_(centerX - 100, currentY += 30, 200, 20).m_253136_());
            Button skateToggle = Button.m_253074_((Component)Component.m_237113_((String)("Skate First Person: " + (this.skateFirstPersonEnabled ? "ENABLED" : "DISABLED"))), button -> {
                this.skateFirstPersonEnabled = !this.skateFirstPersonEnabled;
                manager.setPendingValue("kineceleran.skate.firstPersonEnabled", this.skateFirstPersonEnabled, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_SKATE_FIRST_PERSON_ENABLED);
                button.m_93666_((Component)Component.m_237113_((String)("Skate First Person: " + (this.skateFirstPersonEnabled ? "ENABLED" : "DISABLED"))));
                this.skateDropdownOpen = this.skateFirstPersonEnabled;
                if (this.skateFirstPersonEnabled && this.isCurrentlyInSkateMode() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                    FirstPersonModelCore.instance.setEnabled(true);
                    FirstPersonModelCore.instance.getConfig().dynamicMode = this.skateDynamicMode;
                    try {
                        VanillaHands vanillaHands;
                        FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHands = VanillaHands.valueOf((String)this.skateVanillaHandsMode);
                        AlienFirstPersonMod.LOGGER.info("Synced visual preview with pending skate settings");
                    }
                    catch (IllegalArgumentException e) {
                        AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: {}", (Object)this.skateVanillaHandsMode);
                    }
                }
                this.onConfigChanged();
                this.rebuildScrollableContent();
            }).m_252987_(centerX - 100, currentY += ySpacing + 10, 200, 20).m_253136_();
            this.addScrollableWidget(skateToggle);
            currentY += ySpacing;
            if (this.skateDropdownOpen && this.skateFirstPersonEnabled) {
                this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("  Dynamic Mode: " + (this.skateDynamicMode ? "ON" : "OFF"))), button -> {
                    this.skateDynamicMode = !this.skateDynamicMode;
                    manager.setPendingValue("kineceleran.skate.dynamicMode", this.skateDynamicMode, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_SKATE_DYNAMIC_MODE);
                    button.m_93666_((Component)Component.m_237113_((String)("  Dynamic Mode: " + (this.skateDynamicMode ? "ON" : "OFF"))));
                    if (this.isCurrentlyInSkateMode() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                        FirstPersonModelCore.instance.getConfig().dynamicMode = this.skateDynamicMode;
                        AlienFirstPersonMod.LOGGER.info("Applied skate dynamic mode to visual preview");
                    }
                    this.onConfigChanged();
                }).m_252987_(centerX - 90, currentY, 180, 20).m_253136_());
                this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("  Vanilla Hands: " + this.getVanillaHandsDisplayName(this.skateVanillaHandsMode))), button -> {
                    this.skateVanillaHandsMode = this.getNextVanillaHandsMode(this.skateVanillaHandsMode);
                    manager.setPendingValue("kineceleran.skate.vanillaHandsMode", this.skateVanillaHandsMode, AlienFirstPersonConfig.KINECELERAN_SKATE_VANILLA_HANDS_MODE);
                    button.m_93666_((Component)Component.m_237113_((String)("  Vanilla Hands: " + this.getVanillaHandsDisplayName(this.skateVanillaHandsMode))));
                    if (this.isCurrentlyInSkateMode() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                        try {
                            VanillaHands vanillaHandsEnum;
                            FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHandsEnum = VanillaHands.valueOf((String)this.skateVanillaHandsMode);
                            AlienFirstPersonMod.LOGGER.info("Applied skate vanilla hands to visual preview");
                        }
                        catch (IllegalArgumentException e) {
                            AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: {}", (Object)this.skateVanillaHandsMode);
                        }
                    }
                    this.onConfigChanged();
                }).m_252987_(centerX - 90, currentY += 25, 180, 20).m_253136_());
                this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2 + 20, currentY += 30, sliderWidth - 40, 20, (Component)Component.m_237113_((String)"Standing X: "), (Component)Component.m_237113_((String)""), -60, 60, this.skateStandingXOffset, value -> {
                    this.skateStandingXOffset = value;
                    manager.setPendingValue("kineceleran.skate.standingXOffset", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_SKATE_STANDING_X_OFFSET);
                    this.onConfigChanged();
                }, true));
                this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2 + 20, currentY += 25, sliderWidth - 40, 20, (Component)Component.m_237113_((String)"Sneaking X: "), (Component)Component.m_237113_((String)""), -60, 60, this.skateSneakingXOffset, value -> {
                    this.skateSneakingXOffset = value;
                    manager.setPendingValue("kineceleran.skate.sneakingXOffset", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_SKATE_SNEAKING_X_OFFSET);
                    this.onConfigChanged();
                }, true));
                currentY += 25;
            }
            this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2, currentY, sliderWidth, 20, (Component)Component.m_237113_((String)"Skate FOV: "), (Component)Component.m_237113_((String)""), -60, 60, this.skateFovScaler, value -> {
                this.skateFovScaler = value;
                manager.setPendingValue("kineceleran.skate.fovScaler", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_SKATE_FOV_SCALER);
                this.onConfigChanged();
            }, true));
            this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("Skate FOV on Hands: " + (this.skateFovAffectsHands ? "ENABLED" : "DISABLED"))), button -> {
                this.skateFovAffectsHands = !this.skateFovAffectsHands;
                manager.setPendingValue("kineceleran.skate.fovAffectsHands", this.skateFovAffectsHands, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_SKATE_FOV_AFFECTS_HANDS);
                button.m_93666_((Component)Component.m_237113_((String)("Skate FOV on Hands: " + (this.skateFovAffectsHands ? "ENABLED" : "DISABLED"))));
                this.onConfigChanged();
            }).m_252987_(centerX - 100, currentY += 30, 200, 20).m_253136_());
            this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)"Reset All"), button -> {
                VanillaHands vanillaHands;
                this.speedFirstPersonEnabled = true;
                this.speedStandingXOffset = 0;
                this.speedSneakingXOffset = 0;
                this.speedFovScaler = 0;
                this.speedFovAffectsHands = true;
                this.speedDynamicMode = true;
                this.speedVanillaHandsMode = "OFF";
                this.skateFirstPersonEnabled = true;
                this.skateStandingXOffset = 0;
                this.skateSneakingXOffset = 0;
                this.skateFovScaler = 0;
                this.skateFovAffectsHands = true;
                this.skateDynamicMode = true;
                this.skateVanillaHandsMode = "OFF";
                manager.setPendingValue("kineceleran.speed.firstPersonEnabled", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_SPEED_FIRST_PERSON_ENABLED);
                manager.setPendingValue("kineceleran.speed.standingXOffset", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_SPEED_STANDING_X_OFFSET);
                manager.setPendingValue("kineceleran.speed.sneakingXOffset", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_SPEED_SNEAKING_X_OFFSET);
                manager.setPendingValue("kineceleran.speed.fovScaler", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_SPEED_FOV_SCALER);
                manager.setPendingValue("kineceleran.speed.fovAffectsHands", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_SPEED_FOV_AFFECTS_HANDS);
                manager.setPendingValue("kineceleran.speed.dynamicMode", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_SPEED_DYNAMIC_MODE);
                manager.setPendingValue("kineceleran.speed.vanillaHandsMode", "OFF", AlienFirstPersonConfig.KINECELERAN_SPEED_VANILLA_HANDS_MODE);
                manager.setPendingValue("kineceleran.skate.firstPersonEnabled", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_SKATE_FIRST_PERSON_ENABLED);
                manager.setPendingValue("kineceleran.skate.standingXOffset", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_SKATE_STANDING_X_OFFSET);
                manager.setPendingValue("kineceleran.skate.sneakingXOffset", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_SKATE_SNEAKING_X_OFFSET);
                manager.setPendingValue("kineceleran.skate.fovScaler", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_SKATE_FOV_SCALER);
                manager.setPendingValue("kineceleran.skate.fovAffectsHands", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_SKATE_FOV_AFFECTS_HANDS);
                manager.setPendingValue("kineceleran.skate.dynamicMode", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.KINECELERAN_SKATE_DYNAMIC_MODE);
                manager.setPendingValue("kineceleran.skate.vanillaHandsMode", "OFF", AlienFirstPersonConfig.KINECELERAN_SKATE_VANILLA_HANDS_MODE);
                if (this.isCurrentlyInSpeedMode() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                    FirstPersonModelCore.instance.getConfig().dynamicMode = true;
                    try {
                        FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHands = VanillaHands.valueOf((String)"OFF");
                        AlienFirstPersonMod.LOGGER.info("Applied speed reset defaults to visual preview");
                    }
                    catch (IllegalArgumentException e) {
                        AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: OFF");
                    }
                }
                if (this.isCurrentlyInSkateMode() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                    FirstPersonModelCore.instance.getConfig().dynamicMode = true;
                    try {
                        FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHands = VanillaHands.valueOf((String)"OFF");
                        AlienFirstPersonMod.LOGGER.info("Applied skate reset defaults to visual preview");
                    }
                    catch (IllegalArgumentException e) {
                        AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: OFF");
                    }
                }
                this.speedDropdownOpen = true;
                this.skateDropdownOpen = true;
                this.onConfigChanged();
                this.rebuildScrollableContent();
                AlienFirstPersonMod.LOGGER.info("Reset Kineceleran abilities config to defaults (pending)");
            }).m_252987_(centerX - 50, currentY += ySpacing, 100, 20).m_253136_());
            this.setContentHeight(currentY + 50);
        }

        private boolean isCurrentlyInSpeedMode() {
            if (Minecraft.m_91087_().f_91074_ == null) {
                return false;
            }
            String currentAlien = AlienOffsetManager.getCurrentAlienForm();
            if (!"kineceleran".equals(currentAlien)) {
                return false;
            }
            try {
                Collection allAbilities = AbilityUtil.getInstances((LivingEntity)Minecraft.m_91087_().f_91074_);
                if (allAbilities != null) {
                    for (AbilityInstance ability : allAbilities) {
                        String abilityId;
                        if (ability == null || !ability.isEnabled() || !"speed_1".equals(abilityId = ability.getConfiguration().getId()) && !"speed_2".equals(abilityId) && !"speed_3".equals(abilityId) && !"speed_4".equals(abilityId) && !"speed_5".equals(abilityId)) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                AlienFirstPersonMod.LOGGER.debug("Error checking if in speed mode: {}", (Object)e.getMessage());
            }
            return false;
        }

        private boolean isCurrentlyInSkateMode() {
            if (Minecraft.m_91087_().f_91074_ == null) {
                return false;
            }
            String currentAlien = AlienOffsetManager.getCurrentAlienForm();
            if (!"kineceleran".equals(currentAlien)) {
                return false;
            }
            try {
                Collection allAbilities = AbilityUtil.getInstances((LivingEntity)Minecraft.m_91087_().f_91074_);
                if (allAbilities != null) {
                    for (AbilityInstance ability : allAbilities) {
                        String abilityId;
                        if (ability == null || !ability.isEnabled() || !"skate".equals(abilityId = ability.getConfiguration().getId())) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                AlienFirstPersonMod.LOGGER.debug("Error checking if in skate mode: {}", (Object)e.getMessage());
            }
            return false;
        }

        private String getVanillaHandsDisplayName(String mode) {
            switch (mode) {
                case "OFF": {
                    return "OFF";
                }
                case "ITEMS": {
                    return "Only Items";
                }
                case "ALL": {
                    return "One Hand";
                }
                case "ALL_DOUBLE": {
                    return "Both Hands";
                }
            }
            return "OFF";
        }

        private String getNextVanillaHandsMode(String current) {
            switch (current) {
                case "OFF": {
                    return "ITEMS";
                }
                case "ITEMS": {
                    return "ALL";
                }
                case "ALL": {
                    return "ALL_DOUBLE";
                }
                case "ALL_DOUBLE": {
                    return "OFF";
                }
            }
            return "OFF";
        }
    }
}

