/*
 * Decompiled with CFR 0.152.
 */
package com.parad.alienfirstperson.config.aliens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.parad.alienfirstperson.AlienFirstPersonMod;
import com.parad.alienfirstperson.AlienOffsetManager;
import com.parad.alienfirstperson.config.AlienFirstPersonConfig;
import com.parad.alienfirstperson.config.ConfigChangeManager;
import com.parad.alienfirstperson.config.SafeIntSlider;
import com.parad.alienfirstperson.config.ScrollableScreen;
import dev.tr7zw.firstperson.FirstPersonModelCore;
import dev.tr7zw.firstperson.versionless.config.VanillaHands;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;

@OnlyIn(value=Dist.CLIENT)
public class PetrosapienConfigScreen
extends ScrollableScreen {
    private static final ResourceLocation BATTLEMODE_ICON = new ResourceLocation("alien_first_person", "textures/gui/battlemode.png");
    private boolean firstPersonEnabled;
    private int standingXOffset;
    private int sneakingXOffset;
    private int fovScaler;
    private boolean fovAffectsHands;
    private boolean dynamicMode;
    private String vanillaHandsMode;

    @Override
    protected void reloadCurrentValues() {
        this.firstPersonEnabled = (Boolean)AlienFirstPersonConfig.PETROSAPIEN_FIRST_PERSON_ENABLED.get();
        this.standingXOffset = (Integer)AlienFirstPersonConfig.PETROSAPIEN_STANDING_X_OFFSET.get();
        this.sneakingXOffset = (Integer)AlienFirstPersonConfig.PETROSAPIEN_SNEAKING_X_OFFSET.get();
        this.fovScaler = (Integer)AlienFirstPersonConfig.PETROSAPIEN_FOV_SCALER.get();
        this.fovAffectsHands = (Boolean)AlienFirstPersonConfig.PETROSAPIEN_FOV_AFFECTS_HANDS.get();
        this.dynamicMode = (Boolean)AlienFirstPersonConfig.PETROSAPIEN_DYNAMIC_MODE.get();
        this.vanillaHandsMode = (String)AlienFirstPersonConfig.PETROSAPIEN_VANILLA_HANDS_MODE.get();
    }

    public PetrosapienConfigScreen(Screen previousScreen) {
        super((Component)Component.m_237113_((String)"Petrosapien Configuration"), previousScreen);
        ConfigChangeManager manager = ConfigChangeManager.getInstance();
        this.firstPersonEnabled = (Boolean)manager.getPendingOrCurrentValue("petrosapien.firstPersonEnabled", AlienFirstPersonConfig.PETROSAPIEN_FIRST_PERSON_ENABLED);
        this.standingXOffset = (Integer)manager.getPendingOrCurrentValue("petrosapien.standingXOffset", AlienFirstPersonConfig.PETROSAPIEN_STANDING_X_OFFSET);
        this.sneakingXOffset = (Integer)manager.getPendingOrCurrentValue("petrosapien.sneakingXOffset", AlienFirstPersonConfig.PETROSAPIEN_SNEAKING_X_OFFSET);
        this.fovScaler = (Integer)manager.getPendingOrCurrentValue("petrosapien.fovScaler", AlienFirstPersonConfig.PETROSAPIEN_FOV_SCALER);
        this.fovAffectsHands = (Boolean)manager.getPendingOrCurrentValue("petrosapien.fovAffectsHands", AlienFirstPersonConfig.PETROSAPIEN_FOV_AFFECTS_HANDS);
        this.dynamicMode = (Boolean)manager.getPendingOrCurrentValue("petrosapien.dynamicMode", AlienFirstPersonConfig.PETROSAPIEN_DYNAMIC_MODE);
        this.vanillaHandsMode = manager.getPendingOrCurrentValue("petrosapien.vanillaHandsMode", AlienFirstPersonConfig.PETROSAPIEN_VANILLA_HANDS_MODE);
    }

    @Override
    protected void initScrollableContent() {
        ConfigChangeManager manager = ConfigChangeManager.getInstance();
        this.firstPersonEnabled = (Boolean)manager.getPendingOrCurrentValue("petrosapien.firstPersonEnabled", AlienFirstPersonConfig.PETROSAPIEN_FIRST_PERSON_ENABLED);
        this.standingXOffset = (Integer)manager.getPendingOrCurrentValue("petrosapien.standingXOffset", AlienFirstPersonConfig.PETROSAPIEN_STANDING_X_OFFSET);
        this.sneakingXOffset = (Integer)manager.getPendingOrCurrentValue("petrosapien.sneakingXOffset", AlienFirstPersonConfig.PETROSAPIEN_SNEAKING_X_OFFSET);
        this.fovScaler = (Integer)manager.getPendingOrCurrentValue("petrosapien.fovScaler", AlienFirstPersonConfig.PETROSAPIEN_FOV_SCALER);
        this.fovAffectsHands = (Boolean)manager.getPendingOrCurrentValue("petrosapien.fovAffectsHands", AlienFirstPersonConfig.PETROSAPIEN_FOV_AFFECTS_HANDS);
        this.dynamicMode = (Boolean)manager.getPendingOrCurrentValue("petrosapien.dynamicMode", AlienFirstPersonConfig.PETROSAPIEN_DYNAMIC_MODE);
        this.vanillaHandsMode = manager.getPendingOrCurrentValue("petrosapien.vanillaHandsMode", AlienFirstPersonConfig.PETROSAPIEN_VANILLA_HANDS_MODE);
        int centerX = this.f_96543_ / 2;
        int currentY = 20;
        int ySpacing = 40;
        int sliderWidth = 200;
        Button toggleButton = Button.m_253074_((Component)Component.m_237113_((String)("First Person Model: " + (this.firstPersonEnabled ? "ENABLED" : "DISABLED"))), button -> {
            this.firstPersonEnabled = !this.firstPersonEnabled;
            manager.setPendingValue("petrosapien.firstPersonEnabled", this.firstPersonEnabled, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_FIRST_PERSON_ENABLED);
            button.m_93666_((Component)Component.m_237113_((String)("First Person Model: " + (this.firstPersonEnabled ? "ENABLED" : "DISABLED"))));
            if (this.firstPersonEnabled && this.isCurrentlyInBasePetrosapien() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                FirstPersonModelCore.instance.setEnabled(true);
                FirstPersonModelCore.instance.getConfig().dynamicMode = this.dynamicMode;
                try {
                    VanillaHands vanillaHands;
                    FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHands = VanillaHands.valueOf((String)this.vanillaHandsMode);
                    AlienFirstPersonMod.LOGGER.info("Synced visual preview with pending settings when enabling");
                }
                catch (IllegalArgumentException e) {
                    AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: {}", (Object)this.vanillaHandsMode);
                }
            }
            this.onConfigChanged();
            this.rebuildScrollableContent();
        }).m_252987_(centerX - 100, currentY, 200, 20).m_253136_();
        this.addScrollableWidget(toggleButton);
        currentY += ySpacing;
        if (this.firstPersonEnabled) {
            this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("  Dynamic Mode: " + (this.dynamicMode ? "ON" : "OFF"))), button -> {
                this.dynamicMode = !this.dynamicMode;
                manager.setPendingValue("petrosapien.dynamicMode", this.dynamicMode, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_DYNAMIC_MODE);
                button.m_93666_((Component)Component.m_237113_((String)("  Dynamic Mode: " + (this.dynamicMode ? "ON" : "OFF"))));
                if (this.isCurrentlyInBasePetrosapien() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                    FirstPersonModelCore.instance.getConfig().dynamicMode = this.dynamicMode;
                    AlienFirstPersonMod.LOGGER.info("Applied base Petrosapien dynamic mode to visual preview");
                }
                this.onConfigChanged();
            }).m_252987_(centerX - 90, currentY, 180, 20).m_253136_());
            this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("  Vanilla Hands: " + this.getVanillaHandsDisplayName(this.vanillaHandsMode))), button -> {
                this.vanillaHandsMode = this.getNextVanillaHandsMode(this.vanillaHandsMode);
                manager.setPendingValue("petrosapien.vanillaHandsMode", this.vanillaHandsMode, AlienFirstPersonConfig.PETROSAPIEN_VANILLA_HANDS_MODE);
                button.m_93666_((Component)Component.m_237113_((String)("  Vanilla Hands: " + this.getVanillaHandsDisplayName(this.vanillaHandsMode))));
                if (this.isCurrentlyInBasePetrosapien() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                    try {
                        VanillaHands vanillaHandsEnum;
                        FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHandsEnum = VanillaHands.valueOf((String)this.vanillaHandsMode);
                        AlienFirstPersonMod.LOGGER.info("Applied base Petrosapien vanilla hands to visual preview");
                    }
                    catch (IllegalArgumentException e) {
                        AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: {}", (Object)this.vanillaHandsMode);
                    }
                }
                this.onConfigChanged();
            }).m_252987_(centerX - 90, currentY += 30, 180, 20).m_253136_());
            this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2, currentY += ySpacing, sliderWidth, 20, (Component)Component.m_237113_((String)"Standing X Offset: "), (Component)Component.m_237113_((String)""), -60, 60, this.standingXOffset, value -> {
                this.standingXOffset = value;
                manager.setPendingValue("petrosapien.standingXOffset", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_STANDING_X_OFFSET);
                this.onConfigChanged();
            }, true));
            this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2, currentY += ySpacing, sliderWidth, 20, (Component)Component.m_237113_((String)"Sneaking X Offset: "), (Component)Component.m_237113_((String)""), -60, 60, this.sneakingXOffset, value -> {
                this.sneakingXOffset = value;
                manager.setPendingValue("petrosapien.sneakingXOffset", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_SNEAKING_X_OFFSET);
                this.onConfigChanged();
            }, true));
            currentY += ySpacing;
        }
        this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2, currentY, sliderWidth, 20, (Component)Component.m_237113_((String)"FOV Scaler: "), (Component)Component.m_237113_((String)""), -60, 60, this.fovScaler, value -> {
            this.fovScaler = value;
            manager.setPendingValue("petrosapien.fovScaler", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_FOV_SCALER);
            this.onConfigChanged();
        }, true));
        this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("FOV on Vanilla Hands: " + (this.fovAffectsHands ? "ENABLED" : "DISABLED"))), button -> {
            this.fovAffectsHands = !this.fovAffectsHands;
            manager.setPendingValue("petrosapien.fovAffectsHands", this.fovAffectsHands, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_FOV_AFFECTS_HANDS);
            button.m_93666_((Component)Component.m_237113_((String)("FOV on Vanilla Hands: " + (this.fovAffectsHands ? "ENABLED" : "DISABLED"))));
            this.onConfigChanged();
        }).m_252987_(centerX - 100, currentY += ySpacing, 200, 20).m_253136_());
        this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)"Reset to Defaults"), button -> {
            this.firstPersonEnabled = true;
            this.standingXOffset = 0;
            this.sneakingXOffset = 0;
            this.fovScaler = 0;
            this.fovAffectsHands = true;
            this.dynamicMode = true;
            this.vanillaHandsMode = "OFF";
            manager.setPendingValue("petrosapien.firstPersonEnabled", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_FIRST_PERSON_ENABLED);
            manager.setPendingValue("petrosapien.standingXOffset", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_STANDING_X_OFFSET);
            manager.setPendingValue("petrosapien.sneakingXOffset", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_SNEAKING_X_OFFSET);
            manager.setPendingValue("petrosapien.fovScaler", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_FOV_SCALER);
            manager.setPendingValue("petrosapien.fovAffectsHands", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_FOV_AFFECTS_HANDS);
            manager.setPendingValue("petrosapien.dynamicMode", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_DYNAMIC_MODE);
            manager.setPendingValue("petrosapien.vanillaHandsMode", "OFF", AlienFirstPersonConfig.PETROSAPIEN_VANILLA_HANDS_MODE);
            if (this.isCurrentlyInBasePetrosapien() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                FirstPersonModelCore.instance.getConfig().dynamicMode = true;
                try {
                    VanillaHands vanillaHands;
                    FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHands = VanillaHands.valueOf((String)"OFF");
                    AlienFirstPersonMod.LOGGER.info("Applied reset defaults to visual preview (in base Petrosapien)");
                }
                catch (IllegalArgumentException e) {
                    AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: OFF");
                }
            }
            this.onConfigChanged();
            this.rebuildScrollableContent();
            AlienFirstPersonMod.LOGGER.info("Reset Petrosapien config to defaults (pending)");
        }).m_252987_(centerX - 75, currentY += ySpacing, 150, 20).m_253136_());
        this.addScrollableWidget(new BattleModeButton(centerX - 32, currentY += ySpacing, 64, 64, BATTLEMODE_ICON, (Component)Component.m_237113_((String)"Battle Mode"), button -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new PetrosapienBattleModeScreen(this));
            }
        }));
        this.setContentHeight(currentY + 90);
    }

    private boolean isCurrentlyInBasePetrosapien() {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return false;
        }
        String currentAlien = AlienOffsetManager.getCurrentAlienForm();
        if (!"petrosapien".equals(currentAlien)) {
            return false;
        }
        try {
            Collection allAbilities = AbilityUtil.getInstances((LivingEntity)Minecraft.m_91087_().f_91074_);
            if (allAbilities != null) {
                for (AbilityInstance ability : allAbilities) {
                    String abilityId;
                    if (ability == null || !ability.isEnabled() || !"battle_mode".equals(abilityId = ability.getConfiguration().getId()) && !"shield_activate".equals(abilityId)) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            AlienFirstPersonMod.LOGGER.debug("Error checking if in base Petrosapien: {}", (Object)e.getMessage());
        }
        return true;
    }

    private String getVanillaHandsDisplayName(String mode) {
        switch (mode) {
            case "OFF": {
                return "OFF";
            }
            case "ITEMS": {
                return "Only Items";
            }
            case "ALL": {
                return "One Hand";
            }
            case "ALL_DOUBLE": {
                return "Both Hands";
            }
        }
        return "OFF";
    }

    private String getNextVanillaHandsMode(String current) {
        switch (current) {
            case "OFF": {
                return "ITEMS";
            }
            case "ITEMS": {
                return "ALL";
            }
            case "ALL": {
                return "ALL_DOUBLE";
            }
            case "ALL_DOUBLE": {
                return "OFF";
            }
        }
        return "OFF";
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class BattleModeButton
    extends Button {
        private final ResourceLocation iconTexture;
        private float hoverAnimation = 0.0f;
        private static final float HOVER_SPEED = 0.2f;

        public BattleModeButton(int x, int y, int width, int height, ResourceLocation iconTexture, Component message, Button.OnPress onPress) {
            super(x, y, width, height, message, onPress, f_252438_);
            this.iconTexture = iconTexture;
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.hoverAnimation = this.f_93622_ ? Math.min(this.hoverAnimation + 0.2f, 1.0f) : Math.max(this.hoverAnimation - 0.2f, 0.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            if (this.hoverAnimation > 0.0f) {
                int glowAlpha = (int)(64.0f * this.hoverAnimation);
                int glowColor = glowAlpha << 24 | 0xFF00;
                guiGraphics.m_280509_(this.m_252754_() - 4, this.m_252907_() - 4, this.m_252754_() + this.f_93618_ + 4, this.m_252907_() + this.f_93619_ + 4, glowColor);
            }
            float scale = 1.0f + this.hoverAnimation * 0.1f;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)this.m_252754_() + (float)this.f_93618_ / 2.0f, (float)this.m_252907_() + (float)this.f_93619_ / 2.0f, 0.0f);
            guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
            guiGraphics.m_280168_().m_252880_(-((float)this.m_252754_() + (float)this.f_93618_ / 2.0f), -((float)this.m_252907_() + (float)this.f_93619_ / 2.0f), 0.0f);
            guiGraphics.m_280411_(this.iconTexture, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, 0.0f, 0.0f, 16, 16, 16, 16);
            guiGraphics.m_280168_().m_85849_();
            guiGraphics.m_280653_(Minecraft.m_91087_().f_91062_, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + this.f_93619_ + 6, 0xFFFFFF);
            RenderSystem.disableBlend();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class PetrosapienBattleModeScreen
    extends ScrollableScreen {
        private boolean battleModeFirstPersonEnabled;
        private int battleModeStandingXOffset;
        private int battleModeSneakingXOffset;
        private int battleModeFovScaler;
        private boolean battleModeFovAffectsHands;
        private boolean battleModeDynamicMode;
        private String battleModeVanillaHandsMode;
        private boolean shieldFirstPersonEnabled;
        private int shieldFovScaler;
        private boolean shieldFovAffectsHands;
        private boolean battleModeDropdownOpen = false;

        @Override
        protected void reloadCurrentValues() {
            this.battleModeFirstPersonEnabled = (Boolean)AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_FIRST_PERSON_ENABLED.get();
            this.battleModeStandingXOffset = (Integer)AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_STANDING_X_OFFSET.get();
            this.battleModeSneakingXOffset = (Integer)AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_SNEAKING_X_OFFSET.get();
            this.battleModeFovScaler = (Integer)AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_FOV_SCALER.get();
            this.battleModeFovAffectsHands = (Boolean)AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_FOV_AFFECTS_HANDS.get();
            this.battleModeDynamicMode = (Boolean)AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_DYNAMIC_MODE.get();
            this.battleModeVanillaHandsMode = (String)AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_VANILLA_HANDS_MODE.get();
            this.shieldFirstPersonEnabled = (Boolean)AlienFirstPersonConfig.PETROSAPIEN_SHIELD_FIRST_PERSON_ENABLED.get();
            this.shieldFovScaler = (Integer)AlienFirstPersonConfig.PETROSAPIEN_SHIELD_FOV_SCALER.get();
            this.shieldFovAffectsHands = (Boolean)AlienFirstPersonConfig.PETROSAPIEN_SHIELD_FOV_AFFECTS_HANDS.get();
        }

        public PetrosapienBattleModeScreen(Screen previousScreen) {
            super((Component)Component.m_237113_((String)"Petrosapien Battle Mode Configuration"), previousScreen);
            ConfigChangeManager manager = ConfigChangeManager.getInstance();
            this.battleModeFirstPersonEnabled = (Boolean)manager.getPendingOrCurrentValue("petrosapien.battleMode.firstPersonEnabled", AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_FIRST_PERSON_ENABLED);
            this.battleModeStandingXOffset = (Integer)manager.getPendingOrCurrentValue("petrosapien.battleMode.standingXOffset", AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_STANDING_X_OFFSET);
            this.battleModeSneakingXOffset = (Integer)manager.getPendingOrCurrentValue("petrosapien.battleMode.sneakingXOffset", AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_SNEAKING_X_OFFSET);
            this.battleModeFovScaler = (Integer)manager.getPendingOrCurrentValue("petrosapien.battleMode.fovScaler", AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_FOV_SCALER);
            this.battleModeFovAffectsHands = (Boolean)manager.getPendingOrCurrentValue("petrosapien.battleMode.fovAffectsHands", AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_FOV_AFFECTS_HANDS);
            this.battleModeDynamicMode = (Boolean)manager.getPendingOrCurrentValue("petrosapien.battleMode.dynamicMode", AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_DYNAMIC_MODE);
            this.battleModeVanillaHandsMode = manager.getPendingOrCurrentValue("petrosapien.battleMode.vanillaHandsMode", AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_VANILLA_HANDS_MODE);
            this.shieldFirstPersonEnabled = (Boolean)manager.getPendingOrCurrentValue("petrosapien.shield.firstPersonEnabled", AlienFirstPersonConfig.PETROSAPIEN_SHIELD_FIRST_PERSON_ENABLED);
            this.shieldFovScaler = (Integer)manager.getPendingOrCurrentValue("petrosapien.shield.fovScaler", AlienFirstPersonConfig.PETROSAPIEN_SHIELD_FOV_SCALER);
            this.shieldFovAffectsHands = (Boolean)manager.getPendingOrCurrentValue("petrosapien.shield.fovAffectsHands", AlienFirstPersonConfig.PETROSAPIEN_SHIELD_FOV_AFFECTS_HANDS);
            this.battleModeDropdownOpen = this.battleModeFirstPersonEnabled;
        }

        @Override
        protected void initScrollableContent() {
            int centerX = this.f_96543_ / 2;
            int currentY = 20;
            int ySpacing = 30;
            int sliderWidth = 200;
            ConfigChangeManager manager = ConfigChangeManager.getInstance();
            Button battleModeToggle = Button.m_253074_((Component)Component.m_237113_((String)("Battle Mode First Person: " + (this.battleModeFirstPersonEnabled ? "ENABLED" : "DISABLED"))), button -> {
                this.battleModeFirstPersonEnabled = !this.battleModeFirstPersonEnabled;
                manager.setPendingValue("petrosapien.battleMode.firstPersonEnabled", this.battleModeFirstPersonEnabled, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_FIRST_PERSON_ENABLED);
                button.m_93666_((Component)Component.m_237113_((String)("Battle Mode First Person: " + (this.battleModeFirstPersonEnabled ? "ENABLED" : "DISABLED"))));
                this.battleModeDropdownOpen = this.battleModeFirstPersonEnabled;
                if (this.battleModeFirstPersonEnabled && this.isCurrentlyInBattleMode() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                    FirstPersonModelCore.instance.setEnabled(true);
                    FirstPersonModelCore.instance.getConfig().dynamicMode = this.battleModeDynamicMode;
                    try {
                        VanillaHands vanillaHands;
                        FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHands = VanillaHands.valueOf((String)this.battleModeVanillaHandsMode);
                        AlienFirstPersonMod.LOGGER.info("Synced visual preview with pending battle mode settings when enabling");
                    }
                    catch (IllegalArgumentException e) {
                        AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: {}", (Object)this.battleModeVanillaHandsMode);
                    }
                }
                this.onConfigChanged();
                this.rebuildScrollableContent();
            }).m_252987_(centerX - 100, currentY, 200, 20).m_253136_();
            this.addScrollableWidget(battleModeToggle);
            currentY += ySpacing;
            if (this.battleModeDropdownOpen && this.battleModeFirstPersonEnabled) {
                this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("  Dynamic Mode: " + (this.battleModeDynamicMode ? "ON" : "OFF"))), button -> {
                    this.battleModeDynamicMode = !this.battleModeDynamicMode;
                    manager.setPendingValue("petrosapien.battleMode.dynamicMode", this.battleModeDynamicMode, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_DYNAMIC_MODE);
                    button.m_93666_((Component)Component.m_237113_((String)("  Dynamic Mode: " + (this.battleModeDynamicMode ? "ON" : "OFF"))));
                    if (this.isCurrentlyInBattleMode() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                        FirstPersonModelCore.instance.getConfig().dynamicMode = this.battleModeDynamicMode;
                        AlienFirstPersonMod.LOGGER.info("Applied battle mode dynamic mode to visual preview (in battle mode)");
                    }
                    this.onConfigChanged();
                }).m_252987_(centerX - 90, currentY, 180, 20).m_253136_());
                this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("  Vanilla Hands: " + this.getVanillaHandsDisplayName(this.battleModeVanillaHandsMode))), button -> {
                    this.battleModeVanillaHandsMode = this.getNextVanillaHandsMode(this.battleModeVanillaHandsMode);
                    manager.setPendingValue("petrosapien.battleMode.vanillaHandsMode", this.battleModeVanillaHandsMode, AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_VANILLA_HANDS_MODE);
                    button.m_93666_((Component)Component.m_237113_((String)("  Vanilla Hands: " + this.getVanillaHandsDisplayName(this.battleModeVanillaHandsMode))));
                    if (this.isCurrentlyInBattleMode() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                        try {
                            VanillaHands vanillaHandsEnum;
                            FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHandsEnum = VanillaHands.valueOf((String)this.battleModeVanillaHandsMode);
                            AlienFirstPersonMod.LOGGER.info("Applied battle mode vanilla hands to visual preview (in battle mode)");
                        }
                        catch (IllegalArgumentException e) {
                            AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: {}", (Object)this.battleModeVanillaHandsMode);
                        }
                    }
                    this.onConfigChanged();
                }).m_252987_(centerX - 90, currentY += 25, 180, 20).m_253136_());
                this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2 + 20, currentY += 30, sliderWidth - 40, 20, (Component)Component.m_237113_((String)"Standing X: "), (Component)Component.m_237113_((String)""), -60, 60, this.battleModeStandingXOffset, value -> {
                    this.battleModeStandingXOffset = value;
                    manager.setPendingValue("petrosapien.battleMode.standingXOffset", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_STANDING_X_OFFSET);
                    this.onConfigChanged();
                }, true));
                this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2 + 20, currentY += 25, sliderWidth - 40, 20, (Component)Component.m_237113_((String)"Sneaking X: "), (Component)Component.m_237113_((String)""), -60, 60, this.battleModeSneakingXOffset, value -> {
                    this.battleModeSneakingXOffset = value;
                    manager.setPendingValue("petrosapien.battleMode.sneakingXOffset", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_SNEAKING_X_OFFSET);
                    this.onConfigChanged();
                }, true));
                currentY += 25;
            }
            this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2, currentY, sliderWidth, 20, (Component)Component.m_237113_((String)"Battle Mode FOV: "), (Component)Component.m_237113_((String)""), -60, 60, this.battleModeFovScaler, value -> {
                this.battleModeFovScaler = value;
                manager.setPendingValue("petrosapien.battleMode.fovScaler", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_FOV_SCALER);
                this.onConfigChanged();
            }, true));
            this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("Battle Mode FOV on Hands: " + (this.battleModeFovAffectsHands ? "ENABLED" : "DISABLED"))), button -> {
                this.battleModeFovAffectsHands = !this.battleModeFovAffectsHands;
                manager.setPendingValue("petrosapien.battleMode.fovAffectsHands", this.battleModeFovAffectsHands, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_FOV_AFFECTS_HANDS);
                button.m_93666_((Component)Component.m_237113_((String)("Battle Mode FOV on Hands: " + (this.battleModeFovAffectsHands ? "ENABLED" : "DISABLED"))));
                this.onConfigChanged();
            }).m_252987_(centerX - 100, currentY += 30, 200, 20).m_253136_());
            Button shieldToggle = Button.m_253074_((Component)Component.m_237113_((String)("Shield First Person: " + (this.shieldFirstPersonEnabled ? "ENABLED" : "DISABLED"))), button -> {
                this.shieldFirstPersonEnabled = !this.shieldFirstPersonEnabled;
                manager.setPendingValue("petrosapien.shield.firstPersonEnabled", this.shieldFirstPersonEnabled, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_SHIELD_FIRST_PERSON_ENABLED);
                button.m_93666_((Component)Component.m_237113_((String)("Shield First Person: " + (this.shieldFirstPersonEnabled ? "ENABLED" : "DISABLED"))));
                this.onConfigChanged();
            }).m_252987_(centerX - 100, currentY += ySpacing, 200, 20).m_253136_();
            this.addScrollableWidget(shieldToggle);
            this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2, currentY += ySpacing, sliderWidth, 20, (Component)Component.m_237113_((String)"Shield FOV: "), (Component)Component.m_237113_((String)""), -80, 80, this.shieldFovScaler, value -> {
                this.shieldFovScaler = value;
                manager.setPendingValue("petrosapien.shield.fovScaler", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_SHIELD_FOV_SCALER);
                this.onConfigChanged();
            }, true));
            this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("Shield FOV on Hands: " + (this.shieldFovAffectsHands ? "ENABLED" : "DISABLED"))), button -> {
                this.shieldFovAffectsHands = !this.shieldFovAffectsHands;
                manager.setPendingValue("petrosapien.shield.fovAffectsHands", this.shieldFovAffectsHands, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_SHIELD_FOV_AFFECTS_HANDS);
                button.m_93666_((Component)Component.m_237113_((String)("Shield FOV on Hands: " + (this.shieldFovAffectsHands ? "ENABLED" : "DISABLED"))));
                this.onConfigChanged();
            }).m_252987_(centerX - 100, currentY += 30, 200, 20).m_253136_());
            this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)"Reset All"), button -> {
                this.battleModeFirstPersonEnabled = true;
                this.battleModeStandingXOffset = 0;
                this.battleModeSneakingXOffset = 0;
                this.battleModeFovScaler = 0;
                this.battleModeFovAffectsHands = true;
                this.battleModeDynamicMode = true;
                this.battleModeVanillaHandsMode = "OFF";
                this.shieldFirstPersonEnabled = true;
                this.shieldFovScaler = 0;
                this.shieldFovAffectsHands = true;
                manager.setPendingValue("petrosapien.battleMode.firstPersonEnabled", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_FIRST_PERSON_ENABLED);
                manager.setPendingValue("petrosapien.battleMode.standingXOffset", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_STANDING_X_OFFSET);
                manager.setPendingValue("petrosapien.battleMode.sneakingXOffset", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_SNEAKING_X_OFFSET);
                manager.setPendingValue("petrosapien.battleMode.fovScaler", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_FOV_SCALER);
                manager.setPendingValue("petrosapien.battleMode.fovAffectsHands", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_FOV_AFFECTS_HANDS);
                manager.setPendingValue("petrosapien.battleMode.dynamicMode", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_DYNAMIC_MODE);
                manager.setPendingValue("petrosapien.battleMode.vanillaHandsMode", "OFF", AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_VANILLA_HANDS_MODE);
                manager.setPendingValue("petrosapien.shield.firstPersonEnabled", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_SHIELD_FIRST_PERSON_ENABLED);
                manager.setPendingValue("petrosapien.shield.fovScaler", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_SHIELD_FOV_SCALER);
                manager.setPendingValue("petrosapien.shield.fovAffectsHands", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PETROSAPIEN_SHIELD_FOV_AFFECTS_HANDS);
                if (this.isCurrentlyInBattleMode() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                    FirstPersonModelCore.instance.getConfig().dynamicMode = true;
                    try {
                        VanillaHands vanillaHands;
                        FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHands = VanillaHands.valueOf((String)"OFF");
                        AlienFirstPersonMod.LOGGER.info("Applied battle mode reset defaults to visual preview");
                    }
                    catch (IllegalArgumentException e) {
                        AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: OFF");
                    }
                }
                this.battleModeDropdownOpen = true;
                this.onConfigChanged();
                this.rebuildScrollableContent();
                AlienFirstPersonMod.LOGGER.info("Reset Petrosapien Battle Mode config to defaults (pending)");
            }).m_252987_(centerX - 50, currentY += ySpacing, 100, 20).m_253136_());
            this.setContentHeight(currentY + 50);
        }

        private boolean isCurrentlyInBattleMode() {
            if (Minecraft.m_91087_().f_91074_ == null) {
                return false;
            }
            String currentAlien = AlienOffsetManager.getCurrentAlienForm();
            if (!"petrosapien".equals(currentAlien)) {
                return false;
            }
            try {
                boolean hasBattleMode = false;
                boolean hasShield = false;
                Collection allAbilities = AbilityUtil.getInstances((LivingEntity)Minecraft.m_91087_().f_91074_);
                if (allAbilities != null) {
                    for (AbilityInstance ability : allAbilities) {
                        if (ability == null || !ability.isEnabled()) continue;
                        String abilityId = ability.getConfiguration().getId();
                        if ("battle_mode".equals(abilityId)) {
                            hasBattleMode = true;
                        }
                        if (!"shield_activate".equals(abilityId)) continue;
                        hasShield = true;
                    }
                }
                return hasBattleMode && !hasShield;
            }
            catch (Exception e) {
                AlienFirstPersonMod.LOGGER.debug("Error checking if in battle mode: {}", (Object)e.getMessage());
                return false;
            }
        }

        private String getVanillaHandsDisplayName(String mode) {
            switch (mode) {
                case "OFF": {
                    return "OFF";
                }
                case "ITEMS": {
                    return "Only Items";
                }
                case "ALL": {
                    return "One Hand";
                }
                case "ALL_DOUBLE": {
                    return "Both Hands";
                }
            }
            return "OFF";
        }

        private String getNextVanillaHandsMode(String current) {
            switch (current) {
                case "OFF": {
                    return "ITEMS";
                }
                case "ITEMS": {
                    return "ALL";
                }
                case "ALL": {
                    return "ALL_DOUBLE";
                }
                case "ALL_DOUBLE": {
                    return "OFF";
                }
            }
            return "OFF";
        }
    }
}

