/*
 * Decompiled with CFR 0.152.
 */
package com.parad.alienfirstperson.config.aliens;

import com.parad.alienfirstperson.AlienFirstPersonMod;
import com.parad.alienfirstperson.AlienOffsetManager;
import com.parad.alienfirstperson.config.AlienFirstPersonConfig;
import com.parad.alienfirstperson.config.ConfigChangeManager;
import com.parad.alienfirstperson.config.SafeIntSlider;
import com.parad.alienfirstperson.config.ScrollableScreen;
import dev.tr7zw.firstperson.FirstPersonModelCore;
import dev.tr7zw.firstperson.versionless.config.VanillaHands;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

@OnlyIn(value=Dist.CLIENT)
public class PisccissVolannConfigScreen
extends ScrollableScreen {
    private boolean firstPersonEnabled;
    private int standingXOffset;
    private int sneakingXOffset;
    private int fovScaler;
    private boolean fovAffectsHands;
    private boolean dynamicMode;
    private String vanillaHandsMode;

    @Override
    protected void reloadCurrentValues() {
        this.firstPersonEnabled = (Boolean)AlienFirstPersonConfig.PISCCISS_VOLANN_FIRST_PERSON_ENABLED.get();
        this.standingXOffset = (Integer)AlienFirstPersonConfig.PISCCISS_VOLANN_STANDING_X_OFFSET.get();
        this.sneakingXOffset = (Integer)AlienFirstPersonConfig.PISCCISS_VOLANN_SNEAKING_X_OFFSET.get();
        this.fovScaler = (Integer)AlienFirstPersonConfig.PISCCISS_VOLANN_FOV_SCALER.get();
        this.fovAffectsHands = (Boolean)AlienFirstPersonConfig.PISCCISS_VOLANN_FOV_AFFECTS_HANDS.get();
        this.dynamicMode = (Boolean)AlienFirstPersonConfig.PISCCISS_VOLANN_DYNAMIC_MODE.get();
        this.vanillaHandsMode = (String)AlienFirstPersonConfig.PISCCISS_VOLANN_VANILLA_HANDS_MODE.get();
    }

    public PisccissVolannConfigScreen(Screen previousScreen) {
        super((Component)Component.m_237113_((String)"Piscciss Volann Configuration"), previousScreen);
        ConfigChangeManager manager = ConfigChangeManager.getInstance();
        this.firstPersonEnabled = (Boolean)manager.getPendingOrCurrentValue("piscciss_volann.firstPersonEnabled", AlienFirstPersonConfig.PISCCISS_VOLANN_FIRST_PERSON_ENABLED);
        this.standingXOffset = (Integer)manager.getPendingOrCurrentValue("piscciss_volann.standingXOffset", AlienFirstPersonConfig.PISCCISS_VOLANN_STANDING_X_OFFSET);
        this.sneakingXOffset = (Integer)manager.getPendingOrCurrentValue("piscciss_volann.sneakingXOffset", AlienFirstPersonConfig.PISCCISS_VOLANN_SNEAKING_X_OFFSET);
        this.fovScaler = (Integer)manager.getPendingOrCurrentValue("piscciss_volann.fovScaler", AlienFirstPersonConfig.PISCCISS_VOLANN_FOV_SCALER);
        this.fovAffectsHands = (Boolean)manager.getPendingOrCurrentValue("piscciss_volann.fovAffectsHands", AlienFirstPersonConfig.PISCCISS_VOLANN_FOV_AFFECTS_HANDS);
        this.dynamicMode = (Boolean)manager.getPendingOrCurrentValue("piscciss_volann.dynamicMode", AlienFirstPersonConfig.PISCCISS_VOLANN_DYNAMIC_MODE);
        this.vanillaHandsMode = manager.getPendingOrCurrentValue("piscciss_volann.vanillaHandsMode", AlienFirstPersonConfig.PISCCISS_VOLANN_VANILLA_HANDS_MODE);
    }

    @Override
    protected void initScrollableContent() {
        int centerX = this.f_96543_ / 2;
        int currentY = 20;
        int ySpacing = 40;
        int sliderWidth = 200;
        ConfigChangeManager manager = ConfigChangeManager.getInstance();
        Button toggleButton = Button.m_253074_((Component)Component.m_237113_((String)("First Person Model: " + (this.firstPersonEnabled ? "ENABLED" : "DISABLED"))), button -> {
            this.firstPersonEnabled = !this.firstPersonEnabled;
            manager.setPendingValue("piscciss_volann.firstPersonEnabled", this.firstPersonEnabled, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PISCCISS_VOLANN_FIRST_PERSON_ENABLED);
            button.m_93666_((Component)Component.m_237113_((String)("First Person Model: " + (this.firstPersonEnabled ? "ENABLED" : "DISABLED"))));
            if (this.firstPersonEnabled && this.isCurrentlyInPisccissVolann() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                FirstPersonModelCore.instance.setEnabled(true);
                FirstPersonModelCore.instance.getConfig().dynamicMode = this.dynamicMode;
                try {
                    VanillaHands vanillaHands;
                    FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHands = VanillaHands.valueOf((String)this.vanillaHandsMode);
                    AlienFirstPersonMod.LOGGER.info("Synced visual preview with pending settings when enabling Piscciss Volann");
                }
                catch (IllegalArgumentException e) {
                    AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: {}", (Object)this.vanillaHandsMode);
                }
            }
            this.onConfigChanged();
            this.rebuildScrollableContent();
        }).m_252987_(centerX - 100, currentY, 200, 20).m_253136_();
        this.addScrollableWidget(toggleButton);
        currentY += ySpacing;
        if (this.firstPersonEnabled) {
            this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("  Dynamic Mode: " + (this.dynamicMode ? "ON" : "OFF"))), button -> {
                this.dynamicMode = !this.dynamicMode;
                manager.setPendingValue("piscciss_volann.dynamicMode", this.dynamicMode, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PISCCISS_VOLANN_DYNAMIC_MODE);
                button.m_93666_((Component)Component.m_237113_((String)("  Dynamic Mode: " + (this.dynamicMode ? "ON" : "OFF"))));
                if (this.isCurrentlyInPisccissVolann() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                    FirstPersonModelCore.instance.getConfig().dynamicMode = this.dynamicMode;
                    AlienFirstPersonMod.LOGGER.info("Applied Piscciss Volann dynamic mode immediately: {}", (Object)this.dynamicMode);
                }
                this.onConfigChanged();
            }).m_252987_(centerX - 90, currentY, 180, 20).m_253136_());
            this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("  Vanilla Hands: " + this.getVanillaHandsDisplayName(this.vanillaHandsMode))), button -> {
                this.vanillaHandsMode = this.getNextVanillaHandsMode(this.vanillaHandsMode);
                manager.setPendingValue("piscciss_volann.vanillaHandsMode", this.vanillaHandsMode, AlienFirstPersonConfig.PISCCISS_VOLANN_VANILLA_HANDS_MODE);
                button.m_93666_((Component)Component.m_237113_((String)("  Vanilla Hands: " + this.getVanillaHandsDisplayName(this.vanillaHandsMode))));
                if (this.isCurrentlyInPisccissVolann() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                    try {
                        VanillaHands vanillaHandsEnum;
                        FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHandsEnum = VanillaHands.valueOf((String)this.vanillaHandsMode);
                        AlienFirstPersonMod.LOGGER.info("Applied Piscciss Volann vanilla hands immediately: {}", (Object)this.vanillaHandsMode);
                    }
                    catch (IllegalArgumentException e) {
                        AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: {}", (Object)this.vanillaHandsMode);
                    }
                }
                this.onConfigChanged();
            }).m_252987_(centerX - 90, currentY += 30, 180, 20).m_253136_());
            this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2, currentY += ySpacing, sliderWidth, 20, (Component)Component.m_237113_((String)"Standing X Offset: "), (Component)Component.m_237113_((String)""), -60, 60, this.standingXOffset, value -> {
                this.standingXOffset = value;
                manager.setPendingValue("piscciss_volann.standingXOffset", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PISCCISS_VOLANN_STANDING_X_OFFSET);
                this.onConfigChanged();
            }, true));
            this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2, currentY += ySpacing, sliderWidth, 20, (Component)Component.m_237113_((String)"Sneaking X Offset: "), (Component)Component.m_237113_((String)""), -60, 60, this.sneakingXOffset, value -> {
                this.sneakingXOffset = value;
                manager.setPendingValue("piscciss_volann.sneakingXOffset", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PISCCISS_VOLANN_SNEAKING_X_OFFSET);
                this.onConfigChanged();
            }, true));
            currentY += ySpacing;
        }
        this.addScrollableWidget(new SafeIntSlider(centerX - sliderWidth / 2, currentY, sliderWidth, 20, (Component)Component.m_237113_((String)"FOV Scaler: "), (Component)Component.m_237113_((String)""), -60, 60, this.fovScaler, value -> {
            this.fovScaler = value;
            manager.setPendingValue("piscciss_volann.fovScaler", value, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PISCCISS_VOLANN_FOV_SCALER);
            this.onConfigChanged();
        }, true));
        this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("FOV on Vanilla Hands: " + (this.fovAffectsHands ? "ENABLED" : "DISABLED"))), button -> {
            this.fovAffectsHands = !this.fovAffectsHands;
            manager.setPendingValue("piscciss_volann.fovAffectsHands", this.fovAffectsHands, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PISCCISS_VOLANN_FOV_AFFECTS_HANDS);
            button.m_93666_((Component)Component.m_237113_((String)("FOV on Vanilla Hands: " + (this.fovAffectsHands ? "ENABLED" : "DISABLED"))));
            this.onConfigChanged();
        }).m_252987_(centerX - 100, currentY += ySpacing, 200, 20).m_253136_());
        this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)"Reset to Defaults"), button -> {
            this.firstPersonEnabled = true;
            this.standingXOffset = 0;
            this.sneakingXOffset = 0;
            this.fovScaler = 0;
            this.fovAffectsHands = true;
            this.dynamicMode = true;
            this.vanillaHandsMode = "OFF";
            manager.setPendingValue("piscciss_volann.firstPersonEnabled", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PISCCISS_VOLANN_FIRST_PERSON_ENABLED);
            manager.setPendingValue("piscciss_volann.standingXOffset", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PISCCISS_VOLANN_STANDING_X_OFFSET);
            manager.setPendingValue("piscciss_volann.sneakingXOffset", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PISCCISS_VOLANN_SNEAKING_X_OFFSET);
            manager.setPendingValue("piscciss_volann.fovScaler", 0, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PISCCISS_VOLANN_FOV_SCALER);
            manager.setPendingValue("piscciss_volann.fovAffectsHands", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PISCCISS_VOLANN_FOV_AFFECTS_HANDS);
            manager.setPendingValue("piscciss_volann.dynamicMode", true, (ForgeConfigSpec.ConfigValue<?>)AlienFirstPersonConfig.PISCCISS_VOLANN_DYNAMIC_MODE);
            manager.setPendingValue("piscciss_volann.vanillaHandsMode", "OFF", AlienFirstPersonConfig.PISCCISS_VOLANN_VANILLA_HANDS_MODE);
            if (this.isCurrentlyInPisccissVolann() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
                FirstPersonModelCore.instance.getConfig().dynamicMode = true;
                try {
                    VanillaHands vanillaHands;
                    FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHands = VanillaHands.valueOf((String)"OFF");
                    AlienFirstPersonMod.LOGGER.info("Applied reset defaults to visual preview (in Piscciss Volann)");
                }
                catch (IllegalArgumentException e) {
                    AlienFirstPersonMod.LOGGER.error("Invalid vanilla hands mode: OFF");
                }
            }
            this.onConfigChanged();
            this.rebuildScrollableContent();
            AlienFirstPersonMod.LOGGER.info("Reset Piscciss Volann config to defaults (pending)");
        }).m_252987_(centerX - 75, currentY += ySpacing, 150, 20).m_253136_());
        this.setContentHeight(currentY + 50);
    }

    private boolean isCurrentlyInPisccissVolann() {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return false;
        }
        String currentAlien = AlienOffsetManager.getCurrentAlienForm();
        return "piscciss_volann".equals(currentAlien);
    }

    private String getVanillaHandsDisplayName(String mode) {
        switch (mode) {
            case "OFF": {
                return "OFF";
            }
            case "ITEMS": {
                return "Only Items";
            }
            case "ALL": {
                return "One Hand";
            }
            case "ALL_DOUBLE": {
                return "Both Hands";
            }
        }
        return "OFF";
    }

    private String getNextVanillaHandsMode(String current) {
        switch (current) {
            case "OFF": {
                return "ITEMS";
            }
            case "ITEMS": {
                return "ALL";
            }
            case "ALL": {
                return "ALL_DOUBLE";
            }
            case "ALL_DOUBLE": {
                return "OFF";
            }
        }
        return "OFF";
    }
}

