/*
 * Decompiled with CFR 0.152.
 */
package com.parad.alienfirstperson.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.parad.alienfirstperson.AlienOffsetManager;
import com.parad.alienfirstperson.config.AlienFirstPersonConfig;
import com.parad.alienfirstperson.config.ConfigChangeManager;
import dev.tr7zw.firstperson.FirstPersonModelCore;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleTypes;

@Mixin(value={EntityRenderDispatcher.class}, priority=1100)
public class ShadowOffsetMixin {
    private static final double EPSILON = 7.0E-4;
    private static final double BOUNDARY_THRESHOLD = 0.04;

    @Inject(method={"renderShadow"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;last()Lcom/mojang/blaze3d/vertex/PoseStack$Pose;", shift=At.Shift.BEFORE)})
    private static void correctAlienShadow(PoseStack poseStack, MultiBufferSource bufferSource, Entity entity, float opacity, float partialTicks, LevelReader level, float radius, CallbackInfo ci) {
        float bodyYaw;
        boolean isInAlienForm;
        if (!(entity instanceof Player) || entity != Minecraft.m_91087_().f_91074_) {
            return;
        }
        if (FirstPersonModelCore.instance == null || !FirstPersonModelCore.instance.isEnabled()) {
            return;
        }
        if (!FirstPersonModelCore.instance.isRenderingPlayerPost()) {
            return;
        }
        String currentAlien = AlienOffsetManager.getCurrentAlienForm();
        boolean bl = isInAlienForm = currentAlien != null;
        if (!isInAlienForm && AlienOffsetManager.isInAlienForm() && (isInAlienForm = ((Boolean)AlienFirstPersonConfig.CUSTOM_ALIENS_FIRST_PERSON_ENABLED.get()).booleanValue())) {
            currentAlien = "custom_alien";
        }
        if (!isInAlienForm) {
            return;
        }
        double alienOffset = ShadowOffsetMixin.calculateShadowOffset(entity, currentAlien);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            float prevBodyYaw = livingEntity.f_20884_;
            float currentBodyYaw = livingEntity.f_20883_;
            bodyYaw = prevBodyYaw + (currentBodyYaw - prevBodyYaw) * partialTicks;
        } else {
            bodyYaw = entity.m_5675_(partialTicks);
        }
        double alienX = alienOffset * Math.sin(Math.toRadians(bodyYaw));
        double alienZ = -alienOffset * Math.cos(Math.toRadians(bodyYaw));
        alienX = ShadowOffsetMixin.applySimpleBoundaryEpsilon(entity.m_20185_() + alienX) - entity.m_20185_();
        alienZ = ShadowOffsetMixin.applySimpleBoundaryEpsilon(entity.m_20189_() + alienZ) - entity.m_20189_();
        Vec3 fpmOffset = FirstPersonModelCore.instance.getLogicHandler().getOffset();
        poseStack.m_85837_(alienX - fpmOffset.f_82479_, 0.0, alienZ - fpmOffset.f_82481_);
    }

    private static double applySimpleBoundaryEpsilon(double coordinate) {
        double distToUpperBoundary;
        double blockCoord = Math.floor(coordinate);
        double fractional = coordinate - blockCoord;
        double distToLowerBoundary = fractional;
        double distToNearestBoundary = Math.min(distToLowerBoundary, distToUpperBoundary = 1.0 - fractional);
        if (distToNearestBoundary < 0.04) {
            if (fractional < 0.5) {
                return blockCoord + 0.04 + 7.0E-4;
            }
            return blockCoord + 1.0 - 0.04 - 7.0E-4;
        }
        return coordinate;
    }

    private static double calculateShadowOffset(Entity entity, String currentAlien) {
        if (currentAlien == null) {
            return 0.0;
        }
        ConfigChangeManager manager = ConfigChangeManager.getInstance();
        boolean isSneaking = entity.m_6047_();
        float pehkuiScale = 1.0f;
        try {
            ScaleData scaleData = ScaleTypes.BASE.getScaleData(entity);
            pehkuiScale = scaleData.getScale();
        }
        catch (Exception scaleData) {
            // empty catch block
        }
        float baseOffset = 0.25f * pehkuiScale;
        float baseMultiplier = 1.0f;
        int xOffset = 0;
        switch (currentAlien) {
            case "pyronite": {
                baseMultiplier = 1.0f;
                xOffset = isSneaking ? ((Integer)manager.getPendingOrCurrentValue("pyronite.sneakingXOffset", AlienFirstPersonConfig.PYRONITE_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("pyronite.standingXOffset", AlienFirstPersonConfig.PYRONITE_STANDING_X_OFFSET)).intValue();
                break;
            }
            case "vulpimancer": {
                baseMultiplier = 3.2f;
                xOffset = isSneaking ? ((Integer)manager.getPendingOrCurrentValue("vulpimancer.sneakingXOffset", AlienFirstPersonConfig.VULPIMANCER_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("vulpimancer.standingXOffset", AlienFirstPersonConfig.VULPIMANCER_STANDING_X_OFFSET)).intValue();
                break;
            }
            case "petrosapien": {
                boolean hasBattleMode = false;
                boolean hasShield = false;
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    try {
                        Collection allAbilities = AbilityUtil.getInstances((LivingEntity)player);
                        if (allAbilities != null) {
                            for (AbilityInstance ability : allAbilities) {
                                if (ability == null || !ability.isEnabled()) continue;
                                String abilityId = ability.getConfiguration().getId();
                                if ("battle_mode".equals(abilityId)) {
                                    hasBattleMode = true;
                                }
                                if (!"shield_activate".equals(abilityId)) continue;
                                hasShield = true;
                            }
                        }
                    }
                    catch (Exception allAbilities) {
                        // empty catch block
                    }
                }
                if (hasShield) {
                    baseMultiplier = 1.4f;
                    xOffset = isSneaking ? ((Integer)manager.getPendingOrCurrentValue("petrosapien.sneakingXOffset", AlienFirstPersonConfig.PETROSAPIEN_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("petrosapien.standingXOffset", AlienFirstPersonConfig.PETROSAPIEN_STANDING_X_OFFSET)).intValue();
                    break;
                }
                if (hasBattleMode) {
                    baseMultiplier = 1.4f;
                    xOffset = isSneaking ? ((Integer)manager.getPendingOrCurrentValue("petrosapien.battleMode.sneakingXOffset", AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("petrosapien.battleMode.standingXOffset", AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_STANDING_X_OFFSET)).intValue();
                    break;
                }
                baseMultiplier = 1.4f;
                xOffset = isSneaking ? ((Integer)manager.getPendingOrCurrentValue("petrosapien.sneakingXOffset", AlienFirstPersonConfig.PETROSAPIEN_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("petrosapien.standingXOffset", AlienFirstPersonConfig.PETROSAPIEN_STANDING_X_OFFSET)).intValue();
                break;
            }
            case "kineceleran": {
                boolean hasSpeed = false;
                boolean hasSkate = false;
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    try {
                        Collection allAbilities = AbilityUtil.getInstances((LivingEntity)player);
                        if (allAbilities != null) {
                            for (AbilityInstance ability : allAbilities) {
                                if (ability == null || !ability.isEnabled()) continue;
                                String abilityId = ability.getConfiguration().getId();
                                if ("speed_1".equals(abilityId) || "speed_2".equals(abilityId) || "speed_3".equals(abilityId) || "speed_4".equals(abilityId) || "speed_5".equals(abilityId)) {
                                    hasSpeed = true;
                                }
                                if (!"skate".equals(abilityId)) continue;
                                hasSkate = true;
                            }
                        }
                    }
                    catch (Exception allAbilities) {
                        // empty catch block
                    }
                }
                if (hasSkate) {
                    float baseSkateOffset = 0.8f * pehkuiScale;
                    xOffset = isSneaking ? ((Integer)manager.getPendingOrCurrentValue("kineceleran.skate.sneakingXOffset", AlienFirstPersonConfig.KINECELERAN_SKATE_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("kineceleran.skate.standingXOffset", AlienFirstPersonConfig.KINECELERAN_SKATE_STANDING_X_OFFSET)).intValue();
                    return baseSkateOffset + (float)xOffset * 0.03f;
                }
                if (hasSpeed) {
                    float baseSpeedOffset = 0.8f * pehkuiScale;
                    xOffset = isSneaking ? ((Integer)manager.getPendingOrCurrentValue("kineceleran.speed.sneakingXOffset", AlienFirstPersonConfig.KINECELERAN_SPEED_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("kineceleran.speed.standingXOffset", AlienFirstPersonConfig.KINECELERAN_SPEED_STANDING_X_OFFSET)).intValue();
                    return baseSpeedOffset + (float)xOffset * 0.03f;
                }
                baseMultiplier = 2.5f;
                xOffset = isSneaking ? ((Integer)manager.getPendingOrCurrentValue("kineceleran.sneakingXOffset", AlienFirstPersonConfig.KINECELERAN_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("kineceleran.standingXOffset", AlienFirstPersonConfig.KINECELERAN_STANDING_X_OFFSET)).intValue();
                break;
            }
            case "galvan": {
                boolean hasGalvanSuit = false;
                boolean hasGalvanLimbs = false;
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    try {
                        Collection allAbilities = AbilityUtil.getInstances((LivingEntity)player);
                        if (allAbilities != null) {
                            for (AbilityInstance ability : allAbilities) {
                                if (ability == null || !ability.isEnabled()) continue;
                                String abilityId = ability.getConfiguration().getId();
                                if ("galvan_suit".equals(abilityId)) {
                                    hasGalvanSuit = true;
                                }
                                if (!"galvan_limbs".equals(abilityId)) continue;
                                hasGalvanLimbs = true;
                            }
                        }
                    }
                    catch (Exception allAbilities) {
                        // empty catch block
                    }
                }
                if (hasGalvanSuit) {
                    baseMultiplier = 1.45f;
                    xOffset = isSneaking ? ((Integer)manager.getPendingOrCurrentValue("galvan.suit.sneakingXOffset", AlienFirstPersonConfig.GALVAN_SUIT_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("galvan.suit.standingXOffset", AlienFirstPersonConfig.GALVAN_SUIT_STANDING_X_OFFSET)).intValue();
                    break;
                }
                if (hasGalvanLimbs) {
                    baseMultiplier = 0.45f;
                    xOffset = isSneaking ? ((Integer)manager.getPendingOrCurrentValue("galvan.limbs.sneakingXOffset", AlienFirstPersonConfig.GALVAN_LIMBS_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("galvan.limbs.standingXOffset", AlienFirstPersonConfig.GALVAN_LIMBS_STANDING_X_OFFSET)).intValue();
                    break;
                }
                baseMultiplier = 1.6f;
                xOffset = isSneaking ? ((Integer)manager.getPendingOrCurrentValue("galvan.sneakingXOffset", AlienFirstPersonConfig.GALVAN_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("galvan.standingXOffset", AlienFirstPersonConfig.GALVAN_STANDING_X_OFFSET)).intValue();
                break;
            }
            case "tetramand": {
                baseMultiplier = 1.2f;
                xOffset = isSneaking ? ((Integer)manager.getPendingOrCurrentValue("tetramand.sneakingXOffset", AlienFirstPersonConfig.TETRAMAND_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("tetramand.standingXOffset", AlienFirstPersonConfig.TETRAMAND_STANDING_X_OFFSET)).intValue();
                break;
            }
            case "lepidopterran": {
                baseMultiplier = 3.0f;
                xOffset = isSneaking ? ((Integer)manager.getPendingOrCurrentValue("lepidopterran.sneakingXOffset", AlienFirstPersonConfig.LEPIDOPTERRAN_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("lepidopterran.standingXOffset", AlienFirstPersonConfig.LEPIDOPTERRAN_STANDING_X_OFFSET)).intValue();
                break;
            }
            case "piscciss_volann": {
                baseMultiplier = 1.3f;
                xOffset = isSneaking ? ((Integer)manager.getPendingOrCurrentValue("piscciss_volann.sneakingXOffset", AlienFirstPersonConfig.PISCCISS_VOLANN_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("piscciss_volann.standingXOffset", AlienFirstPersonConfig.PISCCISS_VOLANN_STANDING_X_OFFSET)).intValue();
                break;
            }
            case "galvanic_mechamorph": {
                boolean hasLightningPro = false;
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    try {
                        Collection allAbilities = AbilityUtil.getInstances((LivingEntity)player);
                        if (allAbilities != null) {
                            for (AbilityInstance ability : allAbilities) {
                                String abilityId;
                                if (ability == null || !ability.isEnabled() || !"lightningpro".equals(abilityId = ability.getConfiguration().getId())) continue;
                                hasLightningPro = true;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (hasLightningPro) {
                    baseMultiplier = 1.2f;
                    xOffset = isSneaking ? ((Integer)manager.getPendingOrCurrentValue("galvanic_mechamorph.rod.sneakingXOffset", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("galvanic_mechamorph.rod.standingXOffset", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_STANDING_X_OFFSET)).intValue();
                    break;
                }
                baseMultiplier = 1.2f;
                xOffset = isSneaking ? ((Integer)manager.getPendingOrCurrentValue("galvanic_mechamorph.sneakingXOffset", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("galvanic_mechamorph.standingXOffset", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_STANDING_X_OFFSET)).intValue();
                break;
            }
            case "ectonurite": {
                baseMultiplier = 1.3f;
                xOffset = isSneaking ? ((Integer)manager.getPendingOrCurrentValue("ectonurite.sneakingXOffset", AlienFirstPersonConfig.ECTONURITE_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("ectonurite.standingXOffset", AlienFirstPersonConfig.ECTONURITE_STANDING_X_OFFSET)).intValue();
                break;
            }
            case "arburian_pelarota": {
                baseMultiplier = 2.3f;
                xOffset = isSneaking ? ((Integer)manager.getPendingOrCurrentValue("arburian_pelarota.sneakingXOffset", AlienFirstPersonConfig.ARBURIAN_PELAROTA_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("arburian_pelarota.standingXOffset", AlienFirstPersonConfig.ARBURIAN_PELAROTA_STANDING_X_OFFSET)).intValue();
                break;
            }
            default: {
                baseMultiplier = pehkuiScale > 1.5f ? 1.5f : (pehkuiScale > 1.2f ? 1.3f : (pehkuiScale < 0.5f ? 0.5f : (pehkuiScale < 0.8f ? 0.7f : 1.0f)));
                xOffset = isSneaking ? (Integer)AlienFirstPersonConfig.CUSTOM_ALIENS_SNEAKING_X_OFFSET.get() : (Integer)AlienFirstPersonConfig.CUSTOM_ALIENS_STANDING_X_OFFSET.get();
            }
        }
        float totalMultiplier = baseMultiplier + (float)xOffset * 0.03f;
        return baseOffset * totalMultiplier;
    }
}

