/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.battlegear.container;

import java.util.Arrays;
import java.util.List;
import net.bandit.battlegear.container.SimpleInfusionRecipe;
import net.bandit.battlegear.registry.BattleGearItems;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class InfusionAltarScreenHandler
extends AnvilMenu {
    public InfusionAltarScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, ContainerLevelAccess.NULL);
    }

    public InfusionAltarScreenHandler(int syncId, Inventory playerInventory, ContainerLevelAccess context) {
        super(syncId, playerInventory, context);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public boolean mayPickup(Player player, boolean present) {
        ItemStack resultStack = this.resultSlots.getItem(0);
        return !resultStack.isEmpty();
    }

    public void slotsChanged(Container inventory) {
        this.resultSlots.setItem(0, ItemStack.EMPTY);
        ItemStack input1 = this.inputSlots.getItem(0);
        ItemStack input2 = this.inputSlots.getItem(1);
        for (SimpleInfusionRecipe recipe : InfusionAltarScreenHandler.getInfusionRecipes()) {
            if (!recipe.matches(input1, input2)) continue;
            int crafts = Math.min(input1.getCount() / recipe.getRequiredCount1(), input2.getCount() / recipe.getRequiredCount2());
            if (crafts > 0) {
                ItemStack result = recipe.getResult().copy();
                result.setCount(result.getCount() * crafts);
                this.resultSlots.setItem(0, result);
            }
            return;
        }
    }

    public static List<SimpleInfusionRecipe> getInfusionRecipes() {
        return Arrays.asList(new SimpleInfusionRecipe(new ItemStack((ItemLike)Items.ECHO_SHARD), new ItemStack((ItemLike)Items.PHANTOM_MEMBRANE), new ItemStack((ItemLike)BattleGearItems.SACRED_GEM.get()), 1, 1), new SimpleInfusionRecipe(new ItemStack((ItemLike)Items.DIAMOND), new ItemStack((ItemLike)Items.NETHERITE_INGOT), new ItemStack((ItemLike)BattleGearItems.ANCIENT_CORE.get()), 1, 1), new SimpleInfusionRecipe(new ItemStack((ItemLike)Items.BLAZE_ROD), new ItemStack((ItemLike)Items.GHAST_TEAR), new ItemStack((ItemLike)BattleGearItems.MYSTIC_ESSENCE.get()), 1, 1), new SimpleInfusionRecipe(new ItemStack((ItemLike)Items.DIAMOND), new ItemStack((ItemLike)Items.GOLD_INGOT), new ItemStack((ItemLike)BattleGearItems.TEMPLAR_EMBLEM.get()), 1, 1), new SimpleInfusionRecipe(new ItemStack((ItemLike)Items.GOLDEN_APPLE), new ItemStack((ItemLike)Items.GHAST_TEAR), new ItemStack((ItemLike)BattleGearItems.GUARDIAN_HEART.get()), 1, 1));
    }
}

