/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.battlegear.item;

import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public final class BattleGearArmorMaterials {
    public static final Holder<ArmorMaterial> CRUSADER = BattleGearArmorMaterials.register("crusader", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 5);
        map.put(ArmorItem.Type.LEGGINGS, 9);
        map.put(ArmorItem.Type.CHESTPLATE, 12);
        map.put(ArmorItem.Type.HELMET, 5);
    }), 20, 2.0f, 0.0f, Items.IRON_INGOT);
    public static final Holder<ArmorMaterial> MYSTIC = BattleGearArmorMaterials.register("mystic", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 4);
        map.put(ArmorItem.Type.LEGGINGS, 8);
        map.put(ArmorItem.Type.CHESTPLATE, 11);
        map.put(ArmorItem.Type.HELMET, 5);
    }), 15, 2.5f, 0.1f, Items.DIAMOND);
    public static final Holder<ArmorMaterial> TEMPLAR = BattleGearArmorMaterials.register("templar", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 3);
        map.put(ArmorItem.Type.LEGGINGS, 8);
        map.put(ArmorItem.Type.CHESTPLATE, 9);
        map.put(ArmorItem.Type.HELMET, 4);
    }), 20, 3.0f, 0.1f, Items.NETHERITE_INGOT);
    public static final Holder<ArmorMaterial> GUARDIAN;
    public static final Holder<ArmorMaterial> SERAPHIM;

    private BattleGearArmorMaterials() {
    }

    private static Holder<ArmorMaterial> register(String name, EnumMap<ArmorItem.Type, Integer> typeProtections, int enchantability, float toughness, float knockbackResistance, Item ingredientItem) {
        ResourceLocation loc = ResourceLocation.fromNamespaceAndPath((String)"rpg_battle_gear", (String)name);
        Holder equipSound = SoundEvents.ARMOR_EQUIP_NETHERITE;
        Supplier<Ingredient> ingredient = () -> Ingredient.of((ItemLike[])new ItemLike[]{ingredientItem});
        List<ArmorMaterial.Layer> layers = List.of(new ArmorMaterial.Layer(loc));
        EnumMap<ArmorItem.Type, Integer> typeMap = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        for (ArmorItem.Type type : ArmorItem.Type.values()) {
            typeMap.put(type, typeProtections.get(type));
        }
        return Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)loc, (Object)new ArmorMaterial(typeProtections, enchantability, equipSound, ingredient, layers, toughness, knockbackResistance));
    }

    static {
        SERAPHIM = BattleGearArmorMaterials.register("seraphim", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.BOOTS, 5);
            map.put(ArmorItem.Type.LEGGINGS, 9);
            map.put(ArmorItem.Type.CHESTPLATE, 12);
            map.put(ArmorItem.Type.HELMET, 6);
        }), 20, 3.0f, 0.1f, Items.NETHERITE_INGOT);
        GUARDIAN = BattleGearArmorMaterials.register("guardian", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.BOOTS, 3);
            map.put(ArmorItem.Type.LEGGINGS, 6);
            map.put(ArmorItem.Type.CHESTPLATE, 8);
            map.put(ArmorItem.Type.HELMET, 3);
        }), 25, 3.5f, 0.2f, Items.GOLD_INGOT);
    }
}

