/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.battlegear.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class FlowerSword
extends SwordItem {
    public FlowerSword(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Level level = attacker.level();
        target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 1));
        if (target.hasEffect(MobEffects.MOVEMENT_SLOWDOWN)) {
            target.hurt(attacker.damageSources().magic(), 2.0f);
        }
        if (level.isClientSide) {
            for (int i = 0; i < 12; ++i) {
                double x = target.getX() + (level.random.nextDouble() - 0.5) * 1.5;
                double y = target.getY() + level.random.nextDouble() * 1.5;
                double z = target.getZ() + (level.random.nextDouble() - 0.5) * 1.5;
                level.addParticle((ParticleOptions)ParticleTypes.CHERRY_LEAVES, x, y, z, 0.0, 0.0, 0.0);
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"item.rpg_battle_gear.flower_sword.tooltip").withStyle(ChatFormatting.GREEN));
    }
}

