/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.battlegear.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;

public class JewelSword
extends SwordItem {
    public JewelSword(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Level level = attacker.level();
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = data.copyTag();
        int charge = tag.getInt("JewelCharge");
        tag.putInt("JewelCharge", ++charge);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        if (charge >= 3) {
            tag.putInt("JewelCharge", 0);
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            for (LivingEntity nearby : level.getEntitiesOfClass(LivingEntity.class, target.getBoundingBox().inflate(3.0))) {
                if (nearby == attacker) continue;
                nearby.hurt(attacker.damageSources().magic(), 4.0f);
                nearby.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 40, 0));
            }
            if (level.isClientSide) {
                for (int i = 0; i < 20; ++i) {
                    double x = target.getX() + (level.random.nextDouble() - 0.5) * 2.5;
                    double y = target.getY() + level.random.nextDouble() * 2.0;
                    double z = target.getZ() + (level.random.nextDouble() - 0.5) * 2.5;
                    level.addParticle((ParticleOptions)ParticleTypes.END_ROD, x, y, z, 0.0, 0.02, 0.0);
                }
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"item.rpg_battle_gear.jewel_sword.tooltip").withStyle(ChatFormatting.LIGHT_PURPLE));
    }
}

