/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.battlegear.jei;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.bandit.battlegear.container.SimpleInfusionRecipe;
import net.bandit.battlegear.registry.BlockRegistry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class InfusionAltarRecipeCategory
implements IRecipeCategory<SimpleInfusionRecipe> {
    public static final RecipeType<SimpleInfusionRecipe> RECIPE_TYPE = new RecipeType(ResourceLocation.fromNamespaceAndPath((String)"rpg_battle_gear", (String)"infusion_altar"), SimpleInfusionRecipe.class);
    private final IDrawable background;
    private final Component title;
    private final IDrawable icon;

    public InfusionAltarRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/container/anvil.png"), 25, 39, 140, 35);
        this.title = Component.translatable((String)"jei.category.infusion_altar");
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockRegistry.INFUSION_ALTAR.get()));
    }

    public RecipeType<SimpleInfusionRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SimpleInfusionRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 2, 8).addItemStack(recipe.getInput1());
        builder.addSlot(RecipeIngredientRole.INPUT, 51, 8).addItemStack(recipe.getInput2());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 8).addItemStack(recipe.getResult());
    }

    public List<ItemStack> getRecipeCatalysts() {
        return List.of(new ItemStack((ItemLike)BlockRegistry.INFUSION_ALTAR.get()));
    }
}

