/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common;

import com.mojang.logging.LogUtils;
import com.witchica.compactstorage.CompactStoragePlatform;
import com.witchica.compactstorage.common.CompactStorageCommonClient;
import com.witchica.compactstorage.common.block.CompactBarrelBlock;
import com.witchica.compactstorage.common.block.CompactChestBlock;
import com.witchica.compactstorage.common.block.DrumBlock;
import com.witchica.compactstorage.common.block.entity.CompactBarrelBlockEntity;
import com.witchica.compactstorage.common.block.entity.CompactChestBlockEntity;
import com.witchica.compactstorage.common.block.entity.DrumBlockEntity;
import com.witchica.compactstorage.common.item.BackpackItem;
import com.witchica.compactstorage.common.item.StorageUpgradeItem;
import com.witchica.compactstorage.common.screen.CompactChestScreenHandler;
import com.witchica.compactstorage.common.screen.CompactStorageMenuProvider;
import com.witchica.compactstorage.common.util.CompactStorageUtil;
import com.witchica.compactstorage.common.util.InventoryOpenSource;
import com.witchica.compactstorage.common.util.StorageUpgradeType;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.slf4j.Logger;

public class CompactStorage {
    public static final String MOD_ID = "compact_storage";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final DeferredRegister<class_2248> BLOCKS = DeferredRegister.create((String)"compact_storage", (class_5321)class_7924.field_41254);
    private static final DeferredRegister<class_1792> ITEMS = DeferredRegister.create((String)"compact_storage", (class_5321)class_7924.field_41197);
    private static final DeferredRegister<class_2591<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"compact_storage", (class_5321)class_7924.field_41255);
    private static final DeferredRegister<class_3917<?>> MENU_TYPES = DeferredRegister.create((String)"compact_storage", (class_5321)class_7924.field_41207);
    private static final DeferredRegister<class_1761> CREATIVE_MODE_TABS = DeferredRegister.create((String)"compact_storage", (class_5321)class_7924.field_44688);
    public static class_2960 COMPACT_CHEST_GENERIC_IDENTIFIER = new class_2960("compact_storage", "compact_chest");
    public static class_2960 COMPACT_BARREL_GENERIC_IDENTIFIER = new class_2960("compact_storage", "compact_barrel");
    public static class_2960 COMPACT_STORAGE_BACKPACK_KEY = new class_2960("compact_storage", "backpack_key");
    public static final RegistrySupplier<CompactChestBlock>[] COMPACT_CHEST_BLOCKS = new RegistrySupplier[CompactStorageUtil.StorageVisualTypes.values().length];
    public static final RegistrySupplier<CompactBarrelBlock>[] COMPACT_BARREL_BLOCKS = new RegistrySupplier[CompactStorageUtil.StorageVisualTypes.values().length];
    public static final RegistrySupplier<DrumBlock>[] DRUM_BLOCKS = new RegistrySupplier[CompactStorageUtil.StorageVisualTypes.values().length];
    public static final RegistrySupplier<BackpackItem>[] BACKPACK_ITEMS = new RegistrySupplier[CompactStorageUtil.StorageVisualTypes.values().length];
    public static RegistrySupplier<class_2591<CompactBarrelBlockEntity>> COMPACT_BARREL_ENTITY_TYPE = BLOCK_ENTITY_TYPES.register("compact_barrel", () -> class_2591.class_2592.method_20528(CompactStoragePlatform.compactBarrelBlockEntityProvider(), (class_2248[])((class_2248[])Arrays.stream(COMPACT_BARREL_BLOCKS).map(Supplier::get).toArray(class_2248[]::new))).method_11034(null));
    public static RegistrySupplier<class_2591<CompactChestBlockEntity>> COMPACT_CHEST_ENTITY_TYPE = BLOCK_ENTITY_TYPES.register("compact_chest", () -> class_2591.class_2592.method_20528(CompactStoragePlatform.compactChestBlockEntityProvider(), (class_2248[])((class_2248[])Arrays.stream(COMPACT_CHEST_BLOCKS).map(Supplier::get).toArray(class_2248[]::new))).method_11034(null));
    public static RegistrySupplier<class_2591<DrumBlockEntity>> DRUM_ENTITY_TYPE = BLOCK_ENTITY_TYPES.register("drum", () -> class_2591.class_2592.method_20528(CompactStoragePlatform.drumBlockEntityProvider(), (class_2248[])((class_2248[])Arrays.stream(DRUM_BLOCKS).map(Supplier::get).toArray(class_2248[]::new))).method_11034(null));
    public static final HashMap<class_1767, RegistrySupplier<CompactChestBlock>> DYE_COLOR_TO_COMPACT_CHEST_MAP = new HashMap();
    public static final HashMap<class_1767, RegistrySupplier<CompactBarrelBlock>> DYE_COLOR_TO_COMPACT_BARREL_MAP = new HashMap();
    public static final HashMap<class_1767, RegistrySupplier<BackpackItem>> DYE_COLOR_TO_BACKPACK_MAP = new HashMap();
    public static final HashMap<class_1767, RegistrySupplier<DrumBlock>> DYE_COLOR_TO_DRUM_MAP = new HashMap();
    public static final RegistrySupplier<StorageUpgradeItem> UPGRADE_ROW_ITEM = ITEMS.register("upgrade_row", () -> new StorageUpgradeItem(StorageUpgradeType.ROW, new class_1792.class_1793()));
    public static final RegistrySupplier<StorageUpgradeItem> UPGRADE_COLUMN_ITEM = ITEMS.register("upgrade_column", () -> new StorageUpgradeItem(StorageUpgradeType.COLUMM, new class_1792.class_1793()));
    public static final RegistrySupplier<StorageUpgradeItem> UPGRADE_RETAINER_ITEM = ITEMS.register("upgrade_retainer", () -> new StorageUpgradeItem(StorageUpgradeType.RETAINING, new class_1792.class_1793()));
    public static RegistrySupplier<class_3917<CompactChestScreenHandler>> COMPACT_CHEST_SCREEN_HANDLER = MENU_TYPES.register("compact_chest", () -> MenuRegistry.ofExtended(CompactChestScreenHandler::new));
    public static final RegistrySupplier<class_1761> COMPACT_STORAGE_TAB = CREATIVE_MODE_TABS.register("compact_storage_tab", () -> CreativeTabRegistry.create(builder -> builder.method_47321((class_2561)class_2561.method_43471((String)"itemGroup.compact_storage.general")).method_47320(() -> new class_1799((class_1935)COMPACT_CHEST_BLOCKS[25].get(), 1)).method_47317((params, populator) -> {
        populator.method_45421((class_1935)UPGRADE_COLUMN_ITEM.get());
        populator.method_45421((class_1935)UPGRADE_ROW_ITEM.get());
        populator.method_45421((class_1935)UPGRADE_RETAINER_ITEM.get());
        Arrays.stream(COMPACT_CHEST_BLOCKS).map(Supplier::get).filter(block -> !block.getVisualType().isWooden()).forEach(arg_0 -> ((class_1761.class_7704)populator).method_45421(arg_0));
        Arrays.stream(COMPACT_BARREL_BLOCKS).map(Supplier::get).filter(block -> !block.getVisualType().isWooden()).forEach(arg_0 -> ((class_1761.class_7704)populator).method_45421(arg_0));
        Arrays.stream(DRUM_BLOCKS).map(Supplier::get).filter(block -> !block.getType().isWooden()).forEach(arg_0 -> ((class_1761.class_7704)populator).method_45421(arg_0));
        Arrays.stream(BACKPACK_ITEMS).map(Supplier::get).filter(item -> !item.getVisualType().isWooden()).forEach(arg_0 -> ((class_1761.class_7704)populator).method_45421(arg_0));
    })));
    public static final RegistrySupplier<class_1761> COMPACT_STORAGE_WOOD_TAB = CREATIVE_MODE_TABS.register("compact_storage_tab_wood", () -> CreativeTabRegistry.create(builder -> builder.method_47321((class_2561)class_2561.method_43471((String)"itemGroup.compact_storage.wood")).method_47320(() -> new class_1799((class_1935)COMPACT_CHEST_BLOCKS[1].get(), 1)).method_47317((params, populator) -> {
        Arrays.stream(COMPACT_CHEST_BLOCKS).map(Supplier::get).filter(block -> block.getVisualType().isWooden()).forEach(arg_0 -> ((class_1761.class_7704)populator).method_45421(arg_0));
        Arrays.stream(COMPACT_BARREL_BLOCKS).map(Supplier::get).filter(block -> block.getVisualType().isWooden()).forEach(arg_0 -> ((class_1761.class_7704)populator).method_45421(arg_0));
        Arrays.stream(DRUM_BLOCKS).map(Supplier::get).filter(block -> block.getType().isWooden()).forEach(arg_0 -> ((class_1761.class_7704)populator).method_45421(arg_0));
        Arrays.stream(BACKPACK_ITEMS).map(Supplier::get).filter(item -> item.getVisualType().isWooden()).forEach(arg_0 -> ((class_1761.class_7704)populator).method_45421(arg_0));
    })));

    private static class_2248[] getAllCompactChests() {
        ArrayList blocks = new ArrayList();
        Arrays.stream(COMPACT_CHEST_BLOCKS).forEach(block -> blocks.add((class_2248)block.get()));
        return (class_2248[])blocks.toArray(class_2248[]::new);
    }

    private static class_2248[] getAllCompactBarrels() {
        ArrayList blocks = new ArrayList();
        Arrays.stream(COMPACT_BARREL_BLOCKS).forEach(block -> blocks.add((class_2248)block.get()));
        return (class_2248[])blocks.toArray(class_2248[]::new);
    }

    public static void onInitialize() {
        if (Platform.getEnv() == EnvType.CLIENT) {
            ClientLifecycleEvent.CLIENT_SETUP.register(CompactStorageCommonClient::clientSetupEvent);
            ClientTickEvent.CLIENT_POST.register(CompactStorageCommonClient::clientTickEvent);
        }
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)COMPACT_STORAGE_BACKPACK_KEY, (buf, context) -> {
            class_1657 player = context.getPlayer();
            Optional<class_1799> stack = CompactStoragePlatform.getAdditionalSlotBackpack(player);
            if (stack.isPresent()) {
                MenuRegistry.openExtendedMenu((class_3222)((class_3222)player), (ExtendedMenuProvider)CompactStorageMenuProvider.fromType(InventoryOpenSource.BACKPACK_OPEN_INVENTORY, Optional.empty(), Optional.empty(), stack.get().method_7964()));
            }
        });
        BLOCKS.register();
        ITEMS.register();
        BLOCK_ENTITY_TYPES.register();
        MENU_TYPES.register();
        CREATIVE_MODE_TABS.register();
    }

    public static class_2248 getCompactBarrelFromDyeColor(class_1767 dye) {
        return (class_2248)DYE_COLOR_TO_COMPACT_BARREL_MAP.get(dye).get();
    }

    public static class_2248 getCompactChestFromDyeColor(class_1767 dye) {
        return (class_2248)DYE_COLOR_TO_COMPACT_CHEST_MAP.get(dye).get();
    }

    public static class_1792 getBackpackFromDyeColor(class_1767 dye) {
        return (class_1792)DYE_COLOR_TO_BACKPACK_MAP.get(dye).get();
    }

    public static class_2248 getDrumFromDyeColor(class_1767 dye) {
        return (class_2248)DYE_COLOR_TO_DRUM_MAP.get(dye).get();
    }

    static {
        for (int i = 0; i < CompactStorageUtil.StorageVisualTypes.values().length; ++i) {
            CompactStorageUtil.StorageVisualTypes type = CompactStorageUtil.StorageVisualTypes.values()[i];
            String name = type.getType();
            int index = i;
            String chestName = "compact_chest_" + name;
            String barrelName = "compact_barrel_" + name;
            String backpackName = "backpack_" + name;
            String drumName = name + "_drum";
            if (type.isWooden()) {
                chestName = name + "_compact_chest";
                barrelName = name + "_compact_barrel";
                backpackName = name + "_pack_frame";
            }
            CompactStorage.COMPACT_CHEST_BLOCKS[i] = BLOCKS.register(chestName, () -> new CompactChestBlock(type));
            ITEMS.register(chestName, () -> new class_1747((class_2248)COMPACT_CHEST_BLOCKS[index].get(), new class_1792.class_1793()));
            if (!type.isWooden()) {
                DYE_COLOR_TO_COMPACT_CHEST_MAP.put(type.getAssociatedDyeColor(), COMPACT_CHEST_BLOCKS[i]);
            }
            CompactStorage.BACKPACK_ITEMS[index] = ITEMS.register(backpackName, () -> new BackpackItem(type, new class_1792.class_1793().method_7889(1)));
            if (!type.isWooden()) {
                DYE_COLOR_TO_BACKPACK_MAP.put(type.getAssociatedDyeColor(), BACKPACK_ITEMS[index]);
            }
            CompactStorage.COMPACT_BARREL_BLOCKS[i] = BLOCKS.register(barrelName, () -> new CompactBarrelBlock(type));
            ITEMS.register(barrelName, () -> new class_1747((class_2248)COMPACT_BARREL_BLOCKS[index].get(), new class_1792.class_1793()));
            if (!type.isWooden()) {
                DYE_COLOR_TO_COMPACT_BARREL_MAP.put(type.getAssociatedDyeColor(), COMPACT_BARREL_BLOCKS[i]);
            }
            CompactStorage.DRUM_BLOCKS[index] = BLOCKS.register(drumName, () -> new DrumBlock(type));
            ITEMS.register(drumName, () -> new class_1747((class_2248)DRUM_BLOCKS[index].get(), new class_1792.class_1793()));
            if (type.isWooden()) continue;
            DYE_COLOR_TO_DRUM_MAP.put(type.getAssociatedDyeColor(), DRUM_BLOCKS[index]);
        }
    }
}

