/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common.block;

import com.witchica.compactstorage.CompactStoragePlatform;
import com.witchica.compactstorage.common.CompactStorage;
import com.witchica.compactstorage.common.block.entity.CompactBarrelBlockEntity;
import com.witchica.compactstorage.common.item.StorageUpgradeItem;
import com.witchica.compactstorage.common.screen.CompactStorageMenuProvider;
import com.witchica.compactstorage.common.util.CompactStorageUtil;
import com.witchica.compactstorage.common.util.InventoryOpenSource;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class CompactBarrelBlock
extends class_2237 {
    public static final class_2753 FACING = class_2753.method_35305((String)"facing");
    public static final class_2746 OPEN = class_2746.method_11825((String)"open");
    public static final class_2746 RETAINING = class_2746.method_11825((String)"retaining");
    private final CompactStorageUtil.StorageVisualTypes visualType;

    public CompactBarrelBlock(CompactStorageUtil.StorageVisualTypes visualType) {
        super(visualType.isWooden() ? class_4970.class_2251.method_9630((class_4970)class_2246.field_16328) : class_4970.class_2251.method_9630((class_4970)class_2246.field_16328).method_9629(2.0f, 5.0f));
        this.visualType = visualType;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)RETAINING, (Comparable)Boolean.valueOf(false)));
    }

    public class_2680 method_9605(class_1750 ctx) {
        boolean retaining = ctx.method_8041().method_7985() ? ctx.method_8041().method_7969().method_10577("retaining") : false;
        return (class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)ctx.method_7715().method_10153())).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)RETAINING, (Comparable)Boolean.valueOf(retaining));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, OPEN, RETAINING});
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        if (!world.field_9236 && itemStack.method_7985()) {
            class_2487 nbt = itemStack.method_7969();
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof CompactBarrelBlockEntity) {
                CompactBarrelBlockEntity compactBarrelBlockEntity = (CompactBarrelBlockEntity)blockEntity;
                if (nbt.method_10545("inventory_width") && nbt.method_10545("inventory_height")) {
                    compactBarrelBlockEntity.inventoryWidth = nbt.method_10550("inventory_width");
                    compactBarrelBlockEntity.inventoryHeight = nbt.method_10550("inventory_height");
                    compactBarrelBlockEntity.resizeInventory(false);
                }
                if (nbt.method_10545("retaining") && nbt.method_10577("retaining")) {
                    compactBarrelBlockEntity.readItemsFromTag(compactBarrelBlockEntity.method_11282(), nbt);
                    compactBarrelBlockEntity.setRetaining();
                }
                if (nbt.method_10545("CustomName")) {
                    compactBarrelBlockEntity.method_17488((class_2561)class_2561.class_2562.method_10877((String)nbt.method_10558("CustomName")));
                }
                compactBarrelBlockEntity.method_5431();
            }
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!world.field_9236) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof CompactBarrelBlockEntity) {
                CompactBarrelBlockEntity compactBarrelBlockEntity = (CompactBarrelBlockEntity)blockEntity;
                class_1792 heldItem = player.method_5998(hand).method_7909();
                if (heldItem instanceof StorageUpgradeItem) {
                    StorageUpgradeItem storageUpgradeItem = (StorageUpgradeItem)heldItem;
                    if (compactBarrelBlockEntity.applyUpgrade(storageUpgradeItem.getType())) {
                        player.method_5998(hand).method_7934(1);
                        player.method_7353(storageUpgradeItem.getType().getSuccessMessage(), true);
                        player.method_17356(class_3417.field_14709, class_3419.field_15245, 1.0f, 1.0f);
                        return class_1269.field_33562;
                    }
                    player.method_17356(class_3417.field_15102, class_3419.field_15245, 1.0f, 1.0f);
                    player.method_7353(storageUpgradeItem.getType().getFailureMessage(), true);
                    return class_1269.field_5814;
                }
                if (!this.visualType.isWooden() && heldItem instanceof class_1769) {
                    class_1769 dyeItem = (class_1769)heldItem;
                    class_2248 newBlock = CompactStorage.getCompactBarrelFromDyeColor(dyeItem.method_7802());
                    world.method_8501(pos, (class_2680)newBlock.method_9564().method_11657((class_2769)FACING, (Comparable)((class_2350)state.method_11654((class_2769)FACING))));
                    player.method_17356(class_3417.field_14788, class_3419.field_15245, 1.0f, 1.0f);
                    player.method_5998(hand).method_7934(1);
                    return class_1269.field_33562;
                }
            }
            this.openMenu(world, player, pos, state, hand);
        }
        return class_1269.field_5812;
    }

    public void openMenu(class_1937 level, class_1657 player, class_2338 pos, class_2680 state, class_1268 hand) {
        MenuRegistry.openExtendedMenu((class_3222)((class_3222)player), (ExtendedMenuProvider)CompactStorageMenuProvider.fromType(InventoryOpenSource.CHEST_BARREL, Optional.of(pos), Optional.empty(), (class_2561)this.method_9518()));
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, world, tooltip, options);
        CompactStorageUtil.appendTooltip(stack, world, tooltip, options, false);
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return class_1703.method_7608((class_2586)world.method_8321(pos));
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return CompactStoragePlatform.compactBarrelBlockEntityProvider().create(pos, state);
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        if (type == CompactStorage.COMPACT_BARREL_ENTITY_TYPE.get()) {
            return (world1, pos, state1, be) -> CompactBarrelBlockEntity.tick(world1, pos, state1, (CompactBarrelBlockEntity)be);
        }
        return null;
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean movedByPiston) {
        if (state.method_31709() && !(newState.method_26204() instanceof CompactBarrelBlock)) {
            CompactStorageUtil.dropContents(level, pos, state.method_26204(), null);
            level.method_8544(pos);
        }
    }

    public CompactStorageUtil.StorageVisualTypes getVisualType() {
        return this.visualType;
    }
}

