/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.witchica.compactstorage.common.CompactStorage;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;

public class CompactStorageConfig {
    private final File configFile;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public boolean useChests = true;
    public boolean useWoodenChests = true;
    public boolean useBarrels = true;
    public boolean useWoodenBarrels = true;
    public boolean useDrums = true;
    public boolean useWoodenDrums = true;
    public boolean useBackpacks = true;
    public boolean useWoodenBackpacks = true;
    public int maximumInventoryWidth = 21;
    public int maximumInventoryHeight = 12;

    public CompactStorageConfig() {
        this.configFile = new File(Platform.getConfigFolder().toFile(), "compact_storage.json");
        if (!this.configFile.getParentFile().exists()) {
            this.configFile.getParentFile().mkdirs();
        }
    }

    public <T> T getOrDefault(JsonObject object, String key, T defaultValue) {
        Object value;
        if (object.has(key) && (value = this.gson.fromJson(object.get(key), defaultValue.getClass())) != null) {
            return (T)value;
        }
        return defaultValue;
    }

    public void readConfig() {
        try {
            if (this.configFile.exists()) {
                FileReader fileReader = new FileReader(this.configFile);
                JsonObject object = (JsonObject)this.gson.fromJson((Reader)fileReader, JsonObject.class);
                this.useChests = this.getOrDefault(object, "bUseChests", this.useChests);
                this.useWoodenChests = this.getOrDefault(object, "bUseWoodenChests", this.useWoodenChests);
                this.useBarrels = this.getOrDefault(object, "bUseBarrels", this.useBarrels);
                this.useWoodenBarrels = this.getOrDefault(object, "bUseWoodenBarrels", this.useWoodenBarrels);
                this.useDrums = this.getOrDefault(object, "bUseDrums", this.useDrums);
                this.useWoodenDrums = this.getOrDefault(object, "bUseWoodenDrums", this.useWoodenDrums);
                this.useBackpacks = this.getOrDefault(object, "bUseBackpacks", this.useBackpacks);
                this.useWoodenBackpacks = this.getOrDefault(object, "bUseWoodenBackpacks", this.useWoodenBackpacks);
                this.maximumInventoryWidth = this.getOrDefault(object, "maximumInventoryWidth", this.maximumInventoryWidth);
                this.maximumInventoryWidth = Math.min(this.maximumInventoryWidth, 21);
                this.maximumInventoryWidth = Math.max(this.maximumInventoryWidth, 9);
                this.maximumInventoryHeight = this.getOrDefault(object, "maximumInventoryHeight", this.maximumInventoryHeight);
                this.maximumInventoryHeight = Math.min(this.maximumInventoryHeight, 12);
                this.maximumInventoryHeight = Math.max(this.maximumInventoryHeight, 6);
                fileReader.close();
            }
        }
        catch (Exception ex) {
            CompactStorage.LOGGER.error("Error reading configuration file");
            ex.printStackTrace();
        }
        this.saveConfig();
    }

    public void saveConfig() {
        try {
            if (!this.configFile.exists()) {
                this.configFile.createNewFile();
            }
            FileWriter fileWriter = new FileWriter(this.configFile);
            JsonObject configObject = new JsonObject();
            configObject.addProperty("bUseChests", Boolean.valueOf(this.useChests));
            configObject.addProperty("useWoodenChests", Boolean.valueOf(this.useWoodenChests));
            configObject.addProperty("bUseBarrels", Boolean.valueOf(this.useBarrels));
            configObject.addProperty("bUseWoodenBarrels", Boolean.valueOf(this.useWoodenBarrels));
            configObject.addProperty("bUseDrums", Boolean.valueOf(this.useDrums));
            configObject.addProperty("bUseWoodenDrums", Boolean.valueOf(this.useWoodenDrums));
            configObject.addProperty("bUseBackpacks", Boolean.valueOf(this.useBackpacks));
            configObject.addProperty("bUseWoodenBackpacks", Boolean.valueOf(this.useWoodenBackpacks));
            configObject.addProperty("maximumInventoryWidth", (Number)this.maximumInventoryWidth);
            configObject.addProperty("maximumInventoryHeight", (Number)this.maximumInventoryHeight);
            this.gson.toJson((JsonElement)configObject, (Appendable)fileWriter);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception ex) {
            CompactStorage.LOGGER.error("Error writing configuration file");
            ex.printStackTrace();
        }
    }
}

