/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common.item;

import com.witchica.compactstorage.common.CompactStorage;
import com.witchica.compactstorage.common.inventory.BackpackInventory;
import com.witchica.compactstorage.common.inventory.BackpackInventoryHandlerFactory;
import com.witchica.compactstorage.common.item.StorageUpgradeItem;
import com.witchica.compactstorage.common.screen.CompactChestScreenHandler;
import com.witchica.compactstorage.common.screen.CompactStorageMenuProvider;
import com.witchica.compactstorage.common.util.CompactStorageUtil;
import com.witchica.compactstorage.common.util.InventoryOpenSource;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class BackpackItem
extends class_1792 {
    private final CompactStorageUtil.StorageVisualTypes visualType;

    public BackpackItem(CompactStorageUtil.StorageVisualTypes visualType, class_1792.class_1793 settings) {
        super(settings);
        this.visualType = visualType;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        if (!world.field_9236) {
            boolean isInOffhand = hand == class_1268.field_5810;
            class_1799 heldItemStack = player.method_5998(hand);
            class_1268 oppositeHand = hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808;
            class_1799 oppositeItemStack = player.method_5998(oppositeHand);
            if (!heldItemStack.method_7985()) {
                heldItemStack.method_7980(new class_2487());
            }
            if (!oppositeItemStack.method_7960()) {
                class_1769 dyeItem;
                class_1792 newBackpackItem;
                class_1792 oppositeItem = oppositeItemStack.method_7909();
                BackpackInventory inventory = BackpackInventoryHandlerFactory.getBackpackInventory(player, InventoryOpenSource.BACKPACK_OPEN_HAND, Optional.of(hand));
                if (hand == class_1268.field_5808 && oppositeItem instanceof BackpackItem) {
                    return super.method_7836(world, player, hand);
                }
                if (oppositeItem instanceof StorageUpgradeItem) {
                    StorageUpgradeItem storageUpgradeItem = (StorageUpgradeItem)oppositeItem;
                    if (inventory.applyUpgrade(storageUpgradeItem.getType())) {
                        heldItemStack.method_7969().method_10566("Backpack", (class_2520)inventory.toTag());
                        player.method_5998(oppositeHand).method_7934(1);
                        player.method_7353(storageUpgradeItem.getType().getSuccessMessage(), true);
                        player.method_17356(class_3417.field_14709, class_3419.field_15245, 1.0f, 1.0f);
                        return class_1271.method_22430((Object)heldItemStack);
                    }
                    player.method_17356(class_3417.field_15102, class_3419.field_15245, 1.0f, 1.0f);
                    player.method_7353(storageUpgradeItem.getType().getFailureMessage(), true);
                    return class_1271.method_22431((Object)heldItemStack);
                }
                if (!this.visualType.isWooden() && oppositeItem instanceof class_1769 && (newBackpackItem = CompactStorage.getBackpackFromDyeColor((dyeItem = (class_1769)oppositeItem).method_7802())) != heldItemStack.method_7909()) {
                    class_1799 newStack = new class_1799((class_1935)newBackpackItem, 1);
                    newStack.method_7980(heldItemStack.method_7969());
                    player.method_17356(class_3417.field_14788, class_3419.field_15245, 1.0f, 1.0f);
                    player.method_5998(oppositeHand).method_7934(1);
                    return class_1271.method_22430((Object)newStack);
                }
            }
            if (player.field_7512 instanceof CompactChestScreenHandler) {
                ((class_3222)player).method_7346();
                return super.method_7836(world, player, hand);
            }
            this.openMenu(player, hand);
        }
        return super.method_7836(world, player, hand);
    }

    public void openMenu(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        MenuRegistry.openExtendedMenu((class_3222)((class_3222)player), (ExtendedMenuProvider)CompactStorageMenuProvider.fromType(InventoryOpenSource.BACKPACK_OPEN_HAND, Optional.empty(), Optional.of(hand), this.method_7864(stack)));
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        CompactStorageUtil.appendTooltip(stack, (class_1922)world, tooltip, context, true);
    }

    public CompactStorageUtil.StorageVisualTypes getVisualType() {
        return this.visualType;
    }
}

