/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common;

import com.mojang.logging.LogUtils;
import com.witchica.compactstorage.CompactStoragePlatform;
import com.witchica.compactstorage.common.CompactStorageCommonClient;
import com.witchica.compactstorage.common.block.CompactBarrelBlock;
import com.witchica.compactstorage.common.block.CompactChestBlock;
import com.witchica.compactstorage.common.block.DrumBlock;
import com.witchica.compactstorage.common.block.entity.CompactBarrelBlockEntity;
import com.witchica.compactstorage.common.block.entity.CompactChestBlockEntity;
import com.witchica.compactstorage.common.block.entity.DrumBlockEntity;
import com.witchica.compactstorage.common.item.BackpackItem;
import com.witchica.compactstorage.common.item.StorageUpgradeItem;
import com.witchica.compactstorage.common.screen.CompactChestScreenHandler;
import com.witchica.compactstorage.common.screen.CompactStorageMenuProvider;
import com.witchica.compactstorage.common.util.CompactStorageUtil;
import com.witchica.compactstorage.common.util.InventoryOpenSource;
import com.witchica.compactstorage.common.util.StorageUpgradeType;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import org.slf4j.Logger;

public class CompactStorage {
    public static final String MOD_ID = "compact_storage";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"compact_storage", (ResourceKey)Registries.f_256747_);
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"compact_storage", (ResourceKey)Registries.f_256913_);
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"compact_storage", (ResourceKey)Registries.f_256922_);
    private static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((String)"compact_storage", (ResourceKey)Registries.f_256798_);
    private static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((String)"compact_storage", (ResourceKey)Registries.f_279569_);
    public static ResourceLocation COMPACT_CHEST_GENERIC_IDENTIFIER = new ResourceLocation("compact_storage", "compact_chest");
    public static ResourceLocation COMPACT_BARREL_GENERIC_IDENTIFIER = new ResourceLocation("compact_storage", "compact_barrel");
    public static ResourceLocation COMPACT_STORAGE_BACKPACK_KEY = new ResourceLocation("compact_storage", "backpack_key");
    public static final RegistrySupplier<CompactChestBlock>[] COMPACT_CHEST_BLOCKS = new RegistrySupplier[CompactStorageUtil.StorageVisualTypes.values().length];
    public static final RegistrySupplier<CompactBarrelBlock>[] COMPACT_BARREL_BLOCKS = new RegistrySupplier[CompactStorageUtil.StorageVisualTypes.values().length];
    public static final RegistrySupplier<DrumBlock>[] DRUM_BLOCKS = new RegistrySupplier[CompactStorageUtil.StorageVisualTypes.values().length];
    public static final RegistrySupplier<BackpackItem>[] BACKPACK_ITEMS = new RegistrySupplier[CompactStorageUtil.StorageVisualTypes.values().length];
    public static RegistrySupplier<BlockEntityType<CompactBarrelBlockEntity>> COMPACT_BARREL_ENTITY_TYPE = BLOCK_ENTITY_TYPES.register("compact_barrel", () -> BlockEntityType.Builder.m_155273_(CompactStoragePlatform.compactBarrelBlockEntityProvider(), (Block[])((Block[])Arrays.stream(COMPACT_BARREL_BLOCKS).map(Supplier::get).toArray(Block[]::new))).m_58966_(null));
    public static RegistrySupplier<BlockEntityType<CompactChestBlockEntity>> COMPACT_CHEST_ENTITY_TYPE = BLOCK_ENTITY_TYPES.register("compact_chest", () -> BlockEntityType.Builder.m_155273_(CompactStoragePlatform.compactChestBlockEntityProvider(), (Block[])((Block[])Arrays.stream(COMPACT_CHEST_BLOCKS).map(Supplier::get).toArray(Block[]::new))).m_58966_(null));
    public static RegistrySupplier<BlockEntityType<DrumBlockEntity>> DRUM_ENTITY_TYPE = BLOCK_ENTITY_TYPES.register("drum", () -> BlockEntityType.Builder.m_155273_(CompactStoragePlatform.drumBlockEntityProvider(), (Block[])((Block[])Arrays.stream(DRUM_BLOCKS).map(Supplier::get).toArray(Block[]::new))).m_58966_(null));
    public static final HashMap<DyeColor, RegistrySupplier<CompactChestBlock>> DYE_COLOR_TO_COMPACT_CHEST_MAP = new HashMap();
    public static final HashMap<DyeColor, RegistrySupplier<CompactBarrelBlock>> DYE_COLOR_TO_COMPACT_BARREL_MAP = new HashMap();
    public static final HashMap<DyeColor, RegistrySupplier<BackpackItem>> DYE_COLOR_TO_BACKPACK_MAP = new HashMap();
    public static final HashMap<DyeColor, RegistrySupplier<DrumBlock>> DYE_COLOR_TO_DRUM_MAP = new HashMap();
    public static final RegistrySupplier<StorageUpgradeItem> UPGRADE_ROW_ITEM = ITEMS.register("upgrade_row", () -> new StorageUpgradeItem(StorageUpgradeType.ROW, new Item.Properties()));
    public static final RegistrySupplier<StorageUpgradeItem> UPGRADE_COLUMN_ITEM = ITEMS.register("upgrade_column", () -> new StorageUpgradeItem(StorageUpgradeType.COLUMM, new Item.Properties()));
    public static final RegistrySupplier<StorageUpgradeItem> UPGRADE_RETAINER_ITEM = ITEMS.register("upgrade_retainer", () -> new StorageUpgradeItem(StorageUpgradeType.RETAINING, new Item.Properties()));
    public static RegistrySupplier<MenuType<CompactChestScreenHandler>> COMPACT_CHEST_SCREEN_HANDLER = MENU_TYPES.register("compact_chest", () -> MenuRegistry.ofExtended(CompactChestScreenHandler::new));
    public static final RegistrySupplier<CreativeModeTab> COMPACT_STORAGE_TAB = CREATIVE_MODE_TABS.register("compact_storage_tab", () -> CreativeTabRegistry.create(builder -> builder.m_257941_((Component)Component.m_237115_((String)"itemGroup.compact_storage.general")).m_257737_(() -> new ItemStack((ItemLike)COMPACT_CHEST_BLOCKS[25].get(), 1)).m_257501_((params, populator) -> {
        populator.m_246326_((ItemLike)UPGRADE_COLUMN_ITEM.get());
        populator.m_246326_((ItemLike)UPGRADE_ROW_ITEM.get());
        populator.m_246326_((ItemLike)UPGRADE_RETAINER_ITEM.get());
        Arrays.stream(COMPACT_CHEST_BLOCKS).map(Supplier::get).filter(block -> !block.getVisualType().isWooden()).forEach(arg_0 -> ((CreativeModeTab.Output)populator).m_246326_(arg_0));
        Arrays.stream(COMPACT_BARREL_BLOCKS).map(Supplier::get).filter(block -> !block.getVisualType().isWooden()).forEach(arg_0 -> ((CreativeModeTab.Output)populator).m_246326_(arg_0));
        Arrays.stream(DRUM_BLOCKS).map(Supplier::get).filter(block -> !block.getType().isWooden()).forEach(arg_0 -> ((CreativeModeTab.Output)populator).m_246326_(arg_0));
        Arrays.stream(BACKPACK_ITEMS).map(Supplier::get).filter(item -> !item.getVisualType().isWooden()).forEach(arg_0 -> ((CreativeModeTab.Output)populator).m_246326_(arg_0));
    })));
    public static final RegistrySupplier<CreativeModeTab> COMPACT_STORAGE_WOOD_TAB = CREATIVE_MODE_TABS.register("compact_storage_tab_wood", () -> CreativeTabRegistry.create(builder -> builder.m_257941_((Component)Component.m_237115_((String)"itemGroup.compact_storage.wood")).m_257737_(() -> new ItemStack((ItemLike)COMPACT_CHEST_BLOCKS[1].get(), 1)).m_257501_((params, populator) -> {
        Arrays.stream(COMPACT_CHEST_BLOCKS).map(Supplier::get).filter(block -> block.getVisualType().isWooden()).forEach(arg_0 -> ((CreativeModeTab.Output)populator).m_246326_(arg_0));
        Arrays.stream(COMPACT_BARREL_BLOCKS).map(Supplier::get).filter(block -> block.getVisualType().isWooden()).forEach(arg_0 -> ((CreativeModeTab.Output)populator).m_246326_(arg_0));
        Arrays.stream(DRUM_BLOCKS).map(Supplier::get).filter(block -> block.getType().isWooden()).forEach(arg_0 -> ((CreativeModeTab.Output)populator).m_246326_(arg_0));
        Arrays.stream(BACKPACK_ITEMS).map(Supplier::get).filter(item -> item.getVisualType().isWooden()).forEach(arg_0 -> ((CreativeModeTab.Output)populator).m_246326_(arg_0));
    })));

    private static Block[] getAllCompactChests() {
        ArrayList blocks = new ArrayList();
        Arrays.stream(COMPACT_CHEST_BLOCKS).forEach(block -> blocks.add((Block)block.get()));
        return (Block[])blocks.toArray(Block[]::new);
    }

    private static Block[] getAllCompactBarrels() {
        ArrayList blocks = new ArrayList();
        Arrays.stream(COMPACT_BARREL_BLOCKS).forEach(block -> blocks.add((Block)block.get()));
        return (Block[])blocks.toArray(Block[]::new);
    }

    public static void onInitialize() {
        if (Platform.getEnv() == Dist.CLIENT) {
            ClientLifecycleEvent.CLIENT_SETUP.register(CompactStorageCommonClient::clientSetupEvent);
            ClientTickEvent.CLIENT_POST.register(CompactStorageCommonClient::clientTickEvent);
        }
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)COMPACT_STORAGE_BACKPACK_KEY, (buf, context) -> {
            Player player = context.getPlayer();
            Optional<ItemStack> stack = CompactStoragePlatform.getAdditionalSlotBackpack(player);
            if (stack.isPresent()) {
                MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (ExtendedMenuProvider)CompactStorageMenuProvider.fromType(InventoryOpenSource.BACKPACK_OPEN_INVENTORY, Optional.empty(), Optional.empty(), stack.get().m_41786_()));
            }
        });
        BLOCKS.register();
        ITEMS.register();
        BLOCK_ENTITY_TYPES.register();
        MENU_TYPES.register();
        CREATIVE_MODE_TABS.register();
    }

    public static Block getCompactBarrelFromDyeColor(DyeColor dye) {
        return (Block)DYE_COLOR_TO_COMPACT_BARREL_MAP.get(dye).get();
    }

    public static Block getCompactChestFromDyeColor(DyeColor dye) {
        return (Block)DYE_COLOR_TO_COMPACT_CHEST_MAP.get(dye).get();
    }

    public static Item getBackpackFromDyeColor(DyeColor dye) {
        return (Item)DYE_COLOR_TO_BACKPACK_MAP.get(dye).get();
    }

    public static Block getDrumFromDyeColor(DyeColor dye) {
        return (Block)DYE_COLOR_TO_DRUM_MAP.get(dye).get();
    }

    static {
        for (int i = 0; i < CompactStorageUtil.StorageVisualTypes.values().length; ++i) {
            CompactStorageUtil.StorageVisualTypes type = CompactStorageUtil.StorageVisualTypes.values()[i];
            String name = type.getType();
            int index = i;
            String chestName = "compact_chest_" + name;
            String barrelName = "compact_barrel_" + name;
            String backpackName = "backpack_" + name;
            String drumName = name + "_drum";
            if (type.isWooden()) {
                chestName = name + "_compact_chest";
                barrelName = name + "_compact_barrel";
                backpackName = name + "_pack_frame";
            }
            CompactStorage.COMPACT_CHEST_BLOCKS[i] = BLOCKS.register(chestName, () -> new CompactChestBlock(type));
            ITEMS.register(chestName, () -> new BlockItem((Block)COMPACT_CHEST_BLOCKS[index].get(), new Item.Properties()));
            if (!type.isWooden()) {
                DYE_COLOR_TO_COMPACT_CHEST_MAP.put(type.getAssociatedDyeColor(), COMPACT_CHEST_BLOCKS[i]);
            }
            CompactStorage.BACKPACK_ITEMS[index] = ITEMS.register(backpackName, () -> new BackpackItem(type, new Item.Properties().m_41487_(1)));
            if (!type.isWooden()) {
                DYE_COLOR_TO_BACKPACK_MAP.put(type.getAssociatedDyeColor(), BACKPACK_ITEMS[index]);
            }
            CompactStorage.COMPACT_BARREL_BLOCKS[i] = BLOCKS.register(barrelName, () -> new CompactBarrelBlock(type));
            ITEMS.register(barrelName, () -> new BlockItem((Block)COMPACT_BARREL_BLOCKS[index].get(), new Item.Properties()));
            if (!type.isWooden()) {
                DYE_COLOR_TO_COMPACT_BARREL_MAP.put(type.getAssociatedDyeColor(), COMPACT_BARREL_BLOCKS[i]);
            }
            CompactStorage.DRUM_BLOCKS[index] = BLOCKS.register(drumName, () -> new DrumBlock(type));
            ITEMS.register(drumName, () -> new BlockItem((Block)DRUM_BLOCKS[index].get(), new Item.Properties()));
            if (type.isWooden()) continue;
            DYE_COLOR_TO_DRUM_MAP.put(type.getAssociatedDyeColor(), DRUM_BLOCKS[index]);
        }
    }
}

