/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common.block;

import com.witchica.compactstorage.CompactStoragePlatform;
import com.witchica.compactstorage.common.CompactStorage;
import com.witchica.compactstorage.common.block.entity.CompactBarrelBlockEntity;
import com.witchica.compactstorage.common.item.StorageUpgradeItem;
import com.witchica.compactstorage.common.screen.CompactStorageMenuProvider;
import com.witchica.compactstorage.common.util.CompactStorageUtil;
import com.witchica.compactstorage.common.util.InventoryOpenSource;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class CompactBarrelBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = DirectionProperty.m_156003_((String)"facing");
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    public static final BooleanProperty RETAINING = BooleanProperty.m_61465_((String)"retaining");
    private final CompactStorageUtil.StorageVisualTypes visualType;

    public CompactBarrelBlock(CompactStorageUtil.StorageVisualTypes visualType) {
        super(visualType.isWooden() ? BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50618_) : BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50618_).m_60913_(2.0f, 5.0f));
        this.visualType = visualType;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RETAINING, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        boolean retaining = ctx.m_43722_().m_41782_() ? ctx.m_43722_().m_41783_().m_128471_("retaining") : false;
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)ctx.m_7820_().m_122424_())).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RETAINING, (Comparable)Boolean.valueOf(retaining));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN, RETAINING});
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        super.m_6402_(world, pos, state, placer, itemStack);
        if (!world.f_46443_ && itemStack.m_41782_()) {
            CompoundTag nbt = itemStack.m_41783_();
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof CompactBarrelBlockEntity) {
                CompactBarrelBlockEntity compactBarrelBlockEntity = (CompactBarrelBlockEntity)blockEntity;
                if (nbt.m_128441_("inventory_width") && nbt.m_128441_("inventory_height")) {
                    compactBarrelBlockEntity.inventoryWidth = nbt.m_128451_("inventory_width");
                    compactBarrelBlockEntity.inventoryHeight = nbt.m_128451_("inventory_height");
                    compactBarrelBlockEntity.resizeInventory(false);
                }
                if (nbt.m_128441_("retaining") && nbt.m_128471_("retaining")) {
                    compactBarrelBlockEntity.readItemsFromTag(compactBarrelBlockEntity.m_7086_(), nbt);
                    compactBarrelBlockEntity.setRetaining();
                }
                if (nbt.m_128441_("CustomName")) {
                    compactBarrelBlockEntity.m_58638_((Component)Component.Serializer.m_130701_((String)nbt.m_128461_("CustomName")));
                }
                compactBarrelBlockEntity.m_6596_();
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof CompactBarrelBlockEntity) {
                CompactBarrelBlockEntity compactBarrelBlockEntity = (CompactBarrelBlockEntity)blockEntity;
                Item heldItem = player.m_21120_(hand).m_41720_();
                if (heldItem instanceof StorageUpgradeItem) {
                    StorageUpgradeItem storageUpgradeItem = (StorageUpgradeItem)heldItem;
                    if (compactBarrelBlockEntity.applyUpgrade(storageUpgradeItem.getType())) {
                        player.m_21120_(hand).m_41774_(1);
                        player.m_5661_(storageUpgradeItem.getType().getSuccessMessage(), true);
                        player.m_6330_(SoundEvents.f_12275_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        return InteractionResult.CONSUME_PARTIAL;
                    }
                    player.m_6330_(SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.m_5661_(storageUpgradeItem.getType().getFailureMessage(), true);
                    return InteractionResult.FAIL;
                }
                if (!this.visualType.isWooden() && heldItem instanceof DyeItem) {
                    DyeItem dyeItem = (DyeItem)heldItem;
                    Block newBlock = CompactStorage.getCompactBarrelFromDyeColor(dyeItem.m_41089_());
                    world.m_46597_(pos, (BlockState)newBlock.m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))));
                    player.m_6330_(SoundEvents.f_12392_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.m_21120_(hand).m_41774_(1);
                    return InteractionResult.CONSUME_PARTIAL;
                }
            }
            this.openMenu(world, player, pos, state, hand);
        }
        return InteractionResult.SUCCESS;
    }

    public void openMenu(Level level, Player player, BlockPos pos, BlockState state, InteractionHand hand) {
        MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (ExtendedMenuProvider)CompactStorageMenuProvider.fromType(InventoryOpenSource.CHEST_BARREL, Optional.of(pos), Optional.empty(), (Component)this.m_49954_()));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag options) {
        super.m_5871_(stack, world, tooltip, options);
        CompactStorageUtil.appendTooltip(stack, world, tooltip, options, false);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)world.m_7702_(pos));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return CompactStoragePlatform.compactBarrelBlockEntityProvider().m_155267_(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        if (type == CompactStorage.COMPACT_BARREL_ENTITY_TYPE.get()) {
            return (world1, pos, state1, be) -> CompactBarrelBlockEntity.tick(world1, pos, state1, (CompactBarrelBlockEntity)be);
        }
        return null;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (state.m_155947_() && !(newState.m_60734_() instanceof CompactBarrelBlock)) {
            CompactStorageUtil.dropContents(level, pos, state.m_60734_(), null);
            level.m_46747_(pos);
        }
    }

    public CompactStorageUtil.StorageVisualTypes getVisualType() {
        return this.visualType;
    }
}

