/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common.block;

import com.witchica.compactstorage.common.CompactStorage;
import com.witchica.compactstorage.common.block.entity.DrumBlockEntity;
import com.witchica.compactstorage.common.util.CompactStorageUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class DrumBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = DirectionProperty.m_156003_((String)"facing");
    public static final BooleanProperty RETAINING = BooleanProperty.m_61465_((String)"retaining");
    private final CompactStorageUtil.StorageVisualTypes type;

    public DrumBlock(CompactStorageUtil.StorageVisualTypes type) {
        super(type.isWooden() ? BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50618_) : BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50618_).m_60913_(2.0f, 5.0f));
        this.type = type;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        boolean retaining = ctx.m_43722_().m_41782_() ? ctx.m_43722_().m_41783_().m_128471_("Retaining") : false;
        return (BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)FACING, (Comparable)ctx.m_7820_().m_122424_())).m_61124_((Property)RETAINING, (Comparable)Boolean.valueOf(retaining));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)super.m_6943_(state, mirror).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)).m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)super.m_6843_(state, rotation).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)).m_122427_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, RETAINING});
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag options) {
        super.m_5871_(stack, world, tooltip, options);
        tooltip.add((Component)Component.m_237115_((String)"text.compact_storage.drum.tooltip_1").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        tooltip.add((Component)Component.m_237115_((String)"text.compact_storage.drum.tooltip_2").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Retaining") && stack.m_41783_().m_128471_("Retaining")) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.compact_storage.retaining").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}));
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DrumBlockEntity(pos, state);
    }

    public void extractItem(Level world, BlockPos pos, Player player) {
        DrumBlockEntity drumBlockEntity = (DrumBlockEntity)world.m_7702_(pos);
        SimpleContainer inventory = drumBlockEntity.inventory;
        ItemStack extracted = inventory.m_8016_(0);
        if (!extracted.m_41619_()) {
            world.m_7967_((Entity)new ItemEntity(world, (double)player.m_146903_(), (double)player.m_146904_(), (double)player.m_146907_(), extracted));
            world.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void insertItem(Level world, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        DrumBlockEntity drum = (DrumBlockEntity)world.m_7702_(pos);
        SimpleContainer itemHandler = drum.inventory;
        boolean completed = false;
        if (itemInHand.m_41619_() && drum.hasAnyItems()) {
            Inventory playerInventory = player.m_150109_();
            for (int i = 0; i < playerInventory.m_6643_(); ++i) {
                ItemStack itemStack = playerInventory.m_8020_(i);
                if (!itemHandler.m_7013_(0, itemStack)) continue;
                ItemStack returned = itemHandler.m_19173_(itemStack);
                if (itemStack.m_41613_() == returned.m_41613_()) continue;
                playerInventory.m_6836_(i, returned);
                completed = true;
                break;
            }
        } else {
            ItemStack itemStack = player.m_21120_(hand);
            if (itemHandler.m_7013_(0, itemStack)) {
                ItemStack returned = itemHandler.m_19173_(itemStack);
                if (itemStack.m_41613_() != returned.m_41613_()) {
                    player.m_21008_(hand, returned);
                    completed = true;
                }
            }
        }
        if (completed) {
            world.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_) {
            if (player.m_21120_(hand).m_41720_() == CompactStorage.UPGRADE_RETAINER_ITEM.get()) {
                BlockEntity blockEntity = world.m_7702_(pos);
                if (blockEntity instanceof DrumBlockEntity) {
                    DrumBlockEntity drumBlockEntity = (DrumBlockEntity)blockEntity;
                    drumBlockEntity.setRetaining();
                    player.m_21120_(hand).m_41774_(1);
                    return InteractionResult.CONSUME_PARTIAL;
                }
            } else {
                DyeItem dyeItem;
                Item item;
                if (!this.type.isWooden() && (item = player.m_21120_(hand).m_41720_()) instanceof DyeItem && (dyeItem = (DyeItem)item).m_41089_() != this.type.getAssociatedDyeColor()) {
                    Block newBlock = CompactStorage.getDrumFromDyeColor(dyeItem.m_41089_());
                    world.m_46597_(pos, (BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)RETAINING, (Comparable)((Boolean)state.m_61143_((Property)RETAINING))));
                    player.m_6330_(SoundEvents.f_12392_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.m_21120_(hand).m_41774_(1);
                    return InteractionResult.CONSUME_PARTIAL;
                }
                if (player.m_6144_()) {
                    this.extractItem(world, pos, player);
                } else {
                    this.insertItem(world, pos, player, hand);
                }
            }
        }
        return InteractionResult.CONSUME;
    }

    public void m_6256_(BlockState state, Level world, BlockPos pos, Player player) {
        if (!world.f_46443_) {
            this.extractItem(world, pos, player);
        }
        super.m_6256_(state, world, pos, player);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof DrumBlockEntity) {
            DrumBlockEntity drumBlock = (DrumBlockEntity)blockEntity;
            int totalItemCount = drumBlock.getTotalItemCount();
            int stackSize = drumBlock.getStoredType().m_41459_();
            int output = Mth.m_14143_((float)((float)totalItemCount / (float)stackSize / 64.0f * 15.0f));
            return output;
        }
        return 0;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && stack.m_41782_() && stack.m_41783_().m_128441_("Retaining") && (blockEntity = level.m_7702_(pos)) instanceof DrumBlockEntity) {
            DrumBlockEntity drumBlock = (DrumBlockEntity)blockEntity;
            drumBlock.m_142466_(stack.m_41783_());
            drumBlock.m_6596_();
        }
        super.m_6402_(level, pos, state, placer, stack);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.m_60713_(newState.m_60734_()) && !(newState.m_60734_() instanceof DrumBlock)) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof DrumBlockEntity) {
                DrumBlockEntity drumBlock = (DrumBlockEntity)blockEntity;
                if (!drumBlock.getRetaining()) {
                    Containers.m_19002_((Level)world, (BlockPos)pos, (Container)drumBlock.inventory);
                }
                ItemStack itemStack = new ItemStack((ItemLike)this, 1);
                drumBlock.m_187476_(itemStack);
                Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemStack);
                world.m_46717_(pos, state.m_60734_());
            }
            world.m_46747_(pos);
        }
    }

    public CompactStorageUtil.StorageVisualTypes getType() {
        return this.type;
    }
}

