/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.witchica.compactstorage.common.screen.CompactChestScreenHandler;
import com.witchica.compactstorage.common.util.CompactStorageUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class CompactChestScreen
extends AbstractContainerScreen<CompactChestScreenHandler> {
    public static final ResourceLocation CHEST_SLOTS_TEXTURE = new ResourceLocation("compact_storage", "textures/gui/inventory_slots.png");
    public static final ResourceLocation CHEST_BACKGROUND_TEXTURE = new ResourceLocation("compact_storage", "textures/gui/inventory_background.png");
    private CompactChestScreenHandler container;
    private Inventory playerInventory;
    private final Vector2i slotUvOffset;
    private final Vector2i backgroundUvOffset;
    private static final Vector2i ZERO = new Vector2i(0, 0);

    public CompactChestScreen(CompactChestScreenHandler container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.container = container;
        this.playerInventory = inventory;
        this.f_97726_ = 14 + container.inventoryWidth * 18;
        this.f_97727_ = container.inventoryHeight * 18 + 55 + 72;
        this.slotUvOffset = new Vector2i((Vector2ic)container.visualType.getSlotOffset()).mul(18);
        this.backgroundUvOffset = new Vector2i((Vector2ic)container.visualType.getBackgroundOffset()).mul(15);
    }

    protected void m_280003_(GuiGraphics context, int mouseX, int mouseY) {
        int playerInventoryOffset = this.f_97726_ / 2 - 81 - 7;
        context.m_280614_(this.f_96547_, this.f_96539_, 8, 6, this.container.visualType == CompactStorageUtil.StorageVisualTypes.WHITE ? 0x404040 : 0xDCDCDC, false);
        context.m_280614_(this.f_96547_, this.playerInventory.m_5446_(), 8 + playerInventoryOffset, 32 + this.container.inventoryHeight * 18, 0x404040, false);
        this.m_280072_(context, mouseX - this.f_97735_, mouseY - this.f_97736_);
    }

    protected void m_7286_(GuiGraphics matrixStack, float delta, int mouseX, int mouseY) {
        this.m_280273_(matrixStack);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CHEST_BACKGROUND_TEXTURE);
        int playerInventoryOffset = this.f_97726_ / 2 - 81 - 7;
        this.drawInventorySection(matrixStack, this.f_97735_, this.f_97736_, this.f_97726_, this.container.inventoryHeight * 18 + 24, this.backgroundUvOffset);
        this.drawInventorySection(matrixStack, this.f_97735_ + playerInventoryOffset, this.f_97736_ + this.container.inventoryHeight * 18 + 24 + 3, 176, 100, ZERO);
        this.drawInventorySlots(matrixStack, this.f_97735_ + 7, this.f_97736_ + 18, this.container.inventoryWidth, this.container.inventoryHeight, this.slotUvOffset);
        this.drawInventorySlots(matrixStack, this.f_97735_ + this.f_97726_ / 2 - 81, this.f_97736_ + this.container.inventoryHeight * 18 + 18 + 17 + 7, 9, 3, ZERO);
        this.drawInventorySlots(matrixStack, this.f_97735_ + this.f_97726_ / 2 - 81, this.f_97736_ + this.container.inventoryHeight * 18 + 18 + 60 + 17 + 7, 9, 1, ZERO);
    }

    public void drawInventorySection(GuiGraphics matrixStack, int x, int y, int width, int height, Vector2i uvOffset) {
        matrixStack.m_280163_(CHEST_BACKGROUND_TEXTURE, x, y, (float)uvOffset.x, (float)uvOffset.y, 7, 7, 128, 128);
        matrixStack.m_280163_(CHEST_BACKGROUND_TEXTURE, x + width - 7, y, (float)(uvOffset.x + 8), (float)uvOffset.y, 7, 7, 128, 128);
        matrixStack.m_280163_(CHEST_BACKGROUND_TEXTURE, x, y + height - 7, (float)uvOffset.x, (float)(uvOffset.y + 8), 8, 7, 128, 128);
        matrixStack.m_280163_(CHEST_BACKGROUND_TEXTURE, x + width - 7, y + height - 7, (float)(uvOffset.x + 8), (float)(uvOffset.y + 8), 7, 7, 128, 128);
        matrixStack.m_280411_(CHEST_BACKGROUND_TEXTURE, x + 7, y + 7, width - 14, height - 14, (float)(uvOffset.x + 7), (float)(uvOffset.y + 7), 1, 1, 128, 128);
        matrixStack.m_280411_(CHEST_BACKGROUND_TEXTURE, x, y + 7, 7, height - 14, (float)uvOffset.x, (float)(uvOffset.y + 7), 7, 1, 128, 128);
        matrixStack.m_280411_(CHEST_BACKGROUND_TEXTURE, x + width - 7, y + 7, 7, height - 14, (float)(uvOffset.x + 8), (float)(uvOffset.y + 7), 7, 1, 128, 128);
        matrixStack.m_280411_(CHEST_BACKGROUND_TEXTURE, x + 7, y, width - 14, 7, (float)(uvOffset.x + 7), (float)(uvOffset.y + 0), 1, 7, 128, 128);
        matrixStack.m_280411_(CHEST_BACKGROUND_TEXTURE, x + 7, y + height - 7, width - 14, 7, (float)(uvOffset.x + 7), (float)(uvOffset.y + 8), 1, 7, 128, 128);
    }

    public void drawInventorySlots(GuiGraphics matrixStack, int x, int y, int numSlotsX, int numSlotsY, Vector2i uvOffset) {
        for (int i = 0; i < numSlotsX; ++i) {
            for (int j = 0; j < numSlotsY; ++j) {
                matrixStack.m_280411_(CHEST_SLOTS_TEXTURE, x + 18 * i, y + 18 * j, 18, 18, (float)uvOffset.x, (float)uvOffset.y, 18, 18, 128, 128);
            }
        }
    }

    protected boolean m_97805_(int keyCode, int scanCode) {
        if (this.f_96541_.f_91074_.f_36096_.m_142621_().m_41619_() && this.f_97734_ != null) {
            for (int i = 0; i < 9; ++i) {
                if (i == this.f_96541_.f_91074_.m_150109_().f_35977_ && this.container.blockEntity == null || !this.f_96541_.f_91066_.f_92056_[i].m_90832_(keyCode, scanCode)) continue;
                this.m_6597_(this.f_97734_, this.f_97734_.f_40219_, i, ClickType.SWAP);
                return true;
            }
        }
        return false;
    }
}

