/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common.inventory;

import com.witchica.compactstorage.CompactStoragePlatform;
import com.witchica.compactstorage.common.inventory.BackpackInventory;
import com.witchica.compactstorage.common.item.BackpackItem;
import com.witchica.compactstorage.common.screen.CompactChestScreenHandler;
import com.witchica.compactstorage.common.util.InventoryOpenSource;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class BackpackInventoryHandlerFactory
implements MenuProvider {
    private final Optional<InteractionHand> hand;
    public InventoryOpenSource openSource;
    public ItemStack backpackStack;

    public BackpackInventoryHandlerFactory(Player player, InventoryOpenSource openSource, Optional<InteractionHand> hand) {
        this.openSource = openSource;
        this.hand = hand;
        this.backpackStack = BackpackInventoryHandlerFactory.findBackpackStack(player, openSource, hand);
    }

    public Component m_5446_() {
        return this.backpackStack.m_41786_();
    }

    public static BackpackInventory getBackpackInventory(Player player, InventoryOpenSource openSource, Optional<InteractionHand> hand) {
        ItemStack backpackStack = BackpackInventoryHandlerFactory.findBackpackStack(player, openSource, hand);
        return new BackpackInventory(player, openSource, backpackStack, hand);
    }

    public static ItemStack findBackpackStack(Player player, InventoryOpenSource openSource, Optional<InteractionHand> hand) {
        if (openSource == InventoryOpenSource.BACKPACK_OPEN_HAND) {
            ItemStack stack = player.m_21120_(hand.orElse(InteractionHand.MAIN_HAND));
            if (stack.m_41720_() instanceof BackpackItem) {
                return stack;
            }
            return ItemStack.f_41583_;
        }
        ItemStack stack = CompactStoragePlatform.getAdditionalSlotBackpack(player).orElse(ItemStack.f_41583_);
        return stack;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        BackpackInventory backpackInventory = BackpackInventoryHandlerFactory.getBackpackInventory(player, this.openSource, this.hand);
        return new CompactChestScreenHandler(syncId, inv, this.writeToByteBuf(new FriendlyByteBuf(Unpooled.buffer())));
    }

    public FriendlyByteBuf writeToByteBuf(FriendlyByteBuf buf) {
        buf.writeInt(this.openSource.ordinal());
        buf.writeInt(this.hand.orElse(InteractionHand.MAIN_HAND).ordinal());
        return buf;
    }
}

