/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common.item;

import com.witchica.compactstorage.common.CompactStorage;
import com.witchica.compactstorage.common.inventory.BackpackInventory;
import com.witchica.compactstorage.common.inventory.BackpackInventoryHandlerFactory;
import com.witchica.compactstorage.common.item.StorageUpgradeItem;
import com.witchica.compactstorage.common.screen.CompactChestScreenHandler;
import com.witchica.compactstorage.common.screen.CompactStorageMenuProvider;
import com.witchica.compactstorage.common.util.CompactStorageUtil;
import com.witchica.compactstorage.common.util.InventoryOpenSource;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BackpackItem
extends Item {
    private final CompactStorageUtil.StorageVisualTypes visualType;

    public BackpackItem(CompactStorageUtil.StorageVisualTypes visualType, Item.Properties settings) {
        super(settings);
        this.visualType = visualType;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (!world.f_46443_) {
            boolean isInOffhand = hand == InteractionHand.OFF_HAND;
            ItemStack heldItemStack = player.m_21120_(hand);
            InteractionHand oppositeHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
            ItemStack oppositeItemStack = player.m_21120_(oppositeHand);
            if (!heldItemStack.m_41782_()) {
                heldItemStack.m_41751_(new CompoundTag());
            }
            if (!oppositeItemStack.m_41619_()) {
                DyeItem dyeItem;
                Item newBackpackItem;
                Item oppositeItem = oppositeItemStack.m_41720_();
                BackpackInventory inventory = BackpackInventoryHandlerFactory.getBackpackInventory(player, InventoryOpenSource.BACKPACK_OPEN_HAND, Optional.of(hand));
                if (hand == InteractionHand.MAIN_HAND && oppositeItem instanceof BackpackItem) {
                    return super.m_7203_(world, player, hand);
                }
                if (oppositeItem instanceof StorageUpgradeItem) {
                    StorageUpgradeItem storageUpgradeItem = (StorageUpgradeItem)oppositeItem;
                    if (inventory.applyUpgrade(storageUpgradeItem.getType())) {
                        heldItemStack.m_41783_().m_128365_("Backpack", (Tag)inventory.toTag());
                        player.m_21120_(oppositeHand).m_41774_(1);
                        player.m_5661_(storageUpgradeItem.getType().getSuccessMessage(), true);
                        player.m_6330_(SoundEvents.f_12275_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        return InteractionResultHolder.m_19098_((Object)heldItemStack);
                    }
                    player.m_6330_(SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.m_5661_(storageUpgradeItem.getType().getFailureMessage(), true);
                    return InteractionResultHolder.m_19100_((Object)heldItemStack);
                }
                if (!this.visualType.isWooden() && oppositeItem instanceof DyeItem && (newBackpackItem = CompactStorage.getBackpackFromDyeColor((dyeItem = (DyeItem)oppositeItem).m_41089_())) != heldItemStack.m_41720_()) {
                    ItemStack newStack = new ItemStack((ItemLike)newBackpackItem, 1);
                    newStack.m_41751_(heldItemStack.m_41783_());
                    player.m_6330_(SoundEvents.f_12392_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.m_21120_(oppositeHand).m_41774_(1);
                    return InteractionResultHolder.m_19098_((Object)newStack);
                }
            }
            if (player.f_36096_ instanceof CompactChestScreenHandler) {
                ((ServerPlayer)player).m_6915_();
                return super.m_7203_(world, player, hand);
            }
            this.openMenu(player, hand);
        }
        return super.m_7203_(world, player, hand);
    }

    public void openMenu(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (ExtendedMenuProvider)CompactStorageMenuProvider.fromType(InventoryOpenSource.BACKPACK_OPEN_HAND, Optional.empty(), Optional.of(hand), this.m_7626_(stack)));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        super.m_7373_(stack, world, tooltip, context);
        CompactStorageUtil.appendTooltip(stack, (BlockGetter)world, tooltip, context, true);
    }

    public CompactStorageUtil.StorageVisualTypes getVisualType() {
        return this.visualType;
    }
}

