/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common.screen;

import com.witchica.compactstorage.common.CompactStorage;
import com.witchica.compactstorage.common.inventory.BackpackInventory;
import com.witchica.compactstorage.common.inventory.BackpackInventoryHandlerFactory;
import com.witchica.compactstorage.common.inventory.slot.BackpackHoldSlot;
import com.witchica.compactstorage.common.util.CompactStorageInventoryImpl;
import com.witchica.compactstorage.common.util.CompactStorageUtil;
import com.witchica.compactstorage.common.util.InventoryOpenSource;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class CompactChestScreenHandler
extends AbstractContainerMenu {
    private Container inventory;
    private Inventory playerInventory;
    public CompactStorageInventoryImpl blockEntity;
    public int inventoryWidth;
    public int inventoryHeight;
    public InventoryOpenSource openSource;
    private int backpackSlot = -1;
    public CompactStorageUtil.StorageVisualTypes visualType;

    public CompactChestScreenHandler(int syncId, Inventory playerInventory, FriendlyByteBuf buf) {
        super((MenuType)CompactStorage.COMPACT_CHEST_SCREEN_HANDLER.get(), syncId);
        this.openSource = InventoryOpenSource.values()[buf.readInt()];
        this.playerInventory = playerInventory;
        switch (this.openSource) {
            case CHEST_BARREL: {
                BlockPos pos = buf.m_130135_();
                CompactStorageInventoryImpl inv = (CompactStorageInventoryImpl)playerInventory.f_35978_.m_9236_().m_7702_(pos);
                this.inventory = (Container)inv;
                this.inventoryWidth = inv.getInventoryWidth();
                this.inventoryHeight = inv.getInventoryHeight();
                this.visualType = inv.getVisualType();
                this.blockEntity = inv;
                break;
            }
            default: {
                Optional<InteractionHand> hand = Optional.of(InteractionHand.values()[buf.readInt()]);
                BackpackInventory backpackInventory = BackpackInventoryHandlerFactory.getBackpackInventory(playerInventory.f_35978_, this.openSource, hand);
                this.visualType = backpackInventory.getVisualType();
                this.inventory = backpackInventory;
                this.inventoryWidth = backpackInventory.inventoryWidth;
                this.inventoryHeight = backpackInventory.inventoryHeight;
                this.blockEntity = null;
                if (this.openSource != InventoryOpenSource.BACKPACK_OPEN_HAND || hand.get() != InteractionHand.MAIN_HAND) break;
                this.backpackSlot = playerInventory.f_35977_;
                break;
            }
        }
        CompactChestScreenHandler.m_38869_((Container)this.inventory, (int)(this.inventoryWidth * this.inventoryHeight));
        this.inventory.m_5856_(playerInventory.f_35978_);
        this.setupSlots(true);
    }

    protected CompactChestScreenHandler(@Nullable MenuType<?> type, int syncId) {
        super(type, syncId);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.inventory.m_5785_(player);
    }

    public void setupSlots(boolean includeChestInventory) {
        int j;
        int i;
        boolean checkBackpack = this.openSource != InventoryOpenSource.CHEST_BARREL;
        this.f_38839_.clear();
        int chestInvHeight = this.inventoryHeight * 18;
        for (i = 0; i < this.inventoryHeight; ++i) {
            for (j = 0; j < this.inventoryWidth; ++j) {
                BackpackHoldSlot slot = new BackpackHoldSlot(this.inventory, i * this.inventoryWidth + j, 8 + j * 18, 19 + i * 18, checkBackpack);
                this.m_38897_(slot);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.m_38897_(new BackpackHoldSlot((Container)this.playerInventory, i * 9 + j + 9, 8 + this.inventoryWidth * 18 / 2 - 81 + j * 18, 25 + i * 18 + chestInvHeight + 18, checkBackpack));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.m_38897_(new BackpackHoldSlot((Container)this.playerInventory, j, 8 + this.inventoryWidth * 18 / 2 - 81 + j * 18, 25 + chestInvHeight + 60 + 18, checkBackpack));
        }
    }

    public boolean m_6875_(Player player) {
        return this.inventory.m_6542_(player);
    }

    public ItemStack m_7648_(Player player, int invSlot) {
        ItemStack newStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(invSlot);
        if (slot != null && slot.m_6657_()) {
            ItemStack originalStack = slot.m_7993_();
            newStack = originalStack.m_41777_();
            if (invSlot < this.inventory.m_6643_() ? !this.m_38903_(originalStack, this.inventory.m_6643_(), this.f_38839_.size(), true) : !this.m_38903_(originalStack, 0, this.inventory.m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (originalStack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return newStack;
    }
}

