/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common.screen;

import com.witchica.compactstorage.common.screen.CompactChestScreenHandler;
import com.witchica.compactstorage.common.util.InventoryOpenSource;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class CompactStorageMenuProvider
implements ExtendedMenuProvider {
    private final Consumer<FriendlyByteBuf> dataWriter;
    private final Component name;

    public static CompactStorageMenuProvider fromType(InventoryOpenSource openSource, Optional<BlockPos> blockPos, Optional<InteractionHand> hand, Component name) {
        switch (openSource) {
            case CHEST_BARREL: {
                return new CompactStorageMenuProvider(friendlyByteBuf -> {
                    friendlyByteBuf.writeInt(0);
                    friendlyByteBuf.m_130064_((BlockPos)blockPos.get());
                }, name);
            }
            case BACKPACK_OPEN_HAND: {
                return new CompactStorageMenuProvider(friendlyByteBuf -> {
                    friendlyByteBuf.writeInt(1);
                    friendlyByteBuf.writeInt(((InteractionHand)hand.get()).ordinal());
                }, name);
            }
            case BACKPACK_OPEN_INVENTORY: {
                return new CompactStorageMenuProvider(friendlyByteBuf -> {
                    friendlyByteBuf.writeInt(2);
                    friendlyByteBuf.writeInt(0);
                }, name);
            }
        }
        return null;
    }

    protected CompactStorageMenuProvider(Consumer<FriendlyByteBuf> dataWriter, Component name) {
        this.dataWriter = dataWriter;
        this.name = name;
    }

    public void saveExtraData(FriendlyByteBuf buf) {
        this.dataWriter.accept(buf);
    }

    public Component m_5446_() {
        return this.name;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        this.saveExtraData(buf);
        return new CompactChestScreenHandler(i, inventory, buf);
    }
}

