/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common.util;

import com.witchica.compactstorage.common.util.CompactStorageInventoryImpl;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class CompactStorageUtil {
    public static final String[] DRUM_TYPES = new String[]{"acacia", "birch", "cherry", "crimson", "dark_oak", "jungle", "mangrove", "oak", "spruce", "warped", "bamboo"};

    public static void appendTooltip(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag options, boolean isBackpack) {
        int inventoryX = 9;
        int inventoryY = 6;
        CompoundTag compound = stack.m_41783_();
        if (isBackpack && compound != null) {
            compound = compound.m_128469_("Backpack");
        }
        if (compound != null && compound.m_128441_("inventory_width")) {
            inventoryX = compound.m_128451_("inventory_width");
            inventoryY = compound.m_128451_("inventory_height");
        }
        int slots = inventoryX * inventoryY;
        tooltip.add((Component)Component.m_237115_((String)"text.compact_storage.tooltip.size_x").m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)("" + inventoryX)).m_130940_(ChatFormatting.DARK_PURPLE)));
        tooltip.add((Component)Component.m_237115_((String)"text.compact_storage.tooltip.size_y").m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)("" + inventoryY)).m_130940_(ChatFormatting.DARK_PURPLE)));
        tooltip.add((Component)Component.m_237110_((String)"text.compact_storage.tooltip.slots", (Object[])new Object[]{slots}).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
        if (compound != null && compound.m_128441_("retaining") && compound.m_128471_("retaining")) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.compact_storage.retaining").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}));
        }
    }

    public static void dropContents(Level world, BlockPos pos, Block block, Player player) {
        if (world.f_46443_) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CompactStorageInventoryImpl) {
            RandomizableContainerBlockEntity lootableContainerBlockEntity;
            CompactStorageInventoryImpl inventory = (CompactStorageInventoryImpl)blockEntity;
            ItemStack chestStack = new ItemStack((ItemLike)block, 1);
            blockEntity.m_187476_(chestStack);
            if (inventory instanceof RandomizableContainerBlockEntity && (lootableContainerBlockEntity = (RandomizableContainerBlockEntity)inventory).m_8077_()) {
                chestStack.m_41714_(lootableContainerBlockEntity.m_7770_());
            }
            if (!inventory.getRetaining()) {
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((Container)inventory));
            }
            if (player == null || !player.m_7500_() || inventory.getRetaining()) {
                Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)chestStack);
            }
            world.m_46717_(pos, block);
        }
    }

    public static enum StorageVisualTypes {
        ACACIA("acacia", true, new Vector2i(1, 0), new Vector2i(1, 0)),
        BIRCH("birch", true, new Vector2i(2, 0), new Vector2i(2, 0)),
        CHERRY("cherry", true, new Vector2i(3, 0), new Vector2i(3, 0)),
        CRIMSON("crimson", true, new Vector2i(4, 0), new Vector2i(4, 0)),
        DARK_OAK("dark_oak", true, new Vector2i(5, 0), new Vector2i(5, 0)),
        JUNGLE("jungle", true, new Vector2i(6, 0), new Vector2i(6, 0)),
        MANGROVE("mangrove", true, new Vector2i(0, 1), new Vector2i(7, 0)),
        OAK("oak", true, new Vector2i(1, 1), new Vector2i(0, 1)),
        SPRUCE("spruce", true, new Vector2i(2, 1), new Vector2i(1, 1)),
        WARPED("warped", true, new Vector2i(3, 1), new Vector2i(2, 1)),
        BAMBOO("bamboo", true, new Vector2i(4, 1), new Vector2i(3, 1)),
        WHITE("white", false, DyeColor.WHITE, new Vector2i(5, 3), new Vector2i(2, 3)),
        ORANGE("orange", false, DyeColor.ORANGE, new Vector2i(1, 3), new Vector2i(6, 2)),
        MAGENTA("magenta", false, DyeColor.MAGENTA, new Vector2i(0, 3), new Vector2i(5, 2)),
        LIGHT_BLUE("light_blue", false, DyeColor.LIGHT_BLUE, new Vector2i(4, 2), new Vector2i(2, 2)),
        YELLOW("yellow", false, DyeColor.YELLOW, new Vector2i(6, 3), new Vector2i(3, 3)),
        LIME("lime", false, DyeColor.LIME, new Vector2i(6, 2), new Vector2i(4, 2)),
        PINK("pink", false, DyeColor.PINK, new Vector2i(2, 3), new Vector2i(7, 2)),
        GRAY("gray", false, DyeColor.GRAY, new Vector2i(2, 2), new Vector2i(0, 2)),
        LIGHT_GRAY("light_gray", false, DyeColor.LIGHT_GRAY, new Vector2i(5, 2), new Vector2i(3, 2)),
        CYAN("cyan", false, DyeColor.CYAN, new Vector2i(1, 2), new Vector2i(7, 1)),
        PURPLE("purple", false, DyeColor.PURPLE, new Vector2i(3, 3), new Vector2i(0, 3)),
        BLUE("blue", false, DyeColor.BLUE, new Vector2i(6, 1), new Vector2i(5, 1)),
        BROWN("brown", false, DyeColor.BROWN, new Vector2i(0, 2), new Vector2i(6, 1)),
        GREEN("green", false, DyeColor.GREEN, new Vector2i(3, 2), new Vector2i(1, 2)),
        RED("red", false, DyeColor.RED, new Vector2i(4, 3), new Vector2i(1, 3)),
        BLACK("black", false, DyeColor.BLACK, new Vector2i(5, 1), new Vector2i(4, 1));

        final Vector2i slotOffset;
        final Vector2i backgroundOffset;
        final String type;
        final DyeColor associatedDye;
        final boolean wooden;

        private StorageVisualTypes(String type, boolean wooden, DyeColor associatedDye, Vector2i slotOffset, Vector2i backgroundOffset) {
            this.type = type;
            this.wooden = wooden;
            this.associatedDye = associatedDye;
            this.slotOffset = slotOffset;
            this.backgroundOffset = backgroundOffset;
        }

        private StorageVisualTypes(String name, boolean wooden, Vector2i slotOffset, Vector2i backgroundOffset) {
            this(name, wooden, null, slotOffset, backgroundOffset);
        }

        public String getType() {
            return this.type;
        }

        public boolean isWooden() {
            return this.wooden;
        }

        public DyeColor getAssociatedDyeColor() {
            return this.associatedDye;
        }

        public Vector2i getSlotOffset() {
            return this.slotOffset;
        }

        public Vector2i getBackgroundOffset() {
            return this.backgroundOffset;
        }
    }
}

