/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.forge;

import com.witchica.compactstorage.common.block.entity.CompactBarrelBlockEntity;
import com.witchica.compactstorage.common.block.entity.CompactChestBlockEntity;
import com.witchica.compactstorage.common.block.entity.DrumBlockEntity;
import com.witchica.compactstorage.common.item.BackpackItem;
import com.witchica.compactstorage.forge.block.entity.ForgeCompactBarrelBlockEntity;
import com.witchica.compactstorage.forge.block.entity.ForgeCompactChestBlockEntity;
import com.witchica.compactstorage.forge.block.entity.ForgeDrumBlockEntity;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class CompactStoragePlatformImpl {
    public static BlockEntityType.BlockEntitySupplier<CompactChestBlockEntity> compactChestBlockEntityProvider() {
        return ForgeCompactChestBlockEntity::new;
    }

    public static BlockEntityType.BlockEntitySupplier<CompactBarrelBlockEntity> compactBarrelBlockEntityProvider() {
        return ForgeCompactBarrelBlockEntity::new;
    }

    public static BlockEntityType.BlockEntitySupplier<DrumBlockEntity> drumBlockEntityProvider() {
        return ForgeDrumBlockEntity::new;
    }

    private static Optional<SlotResult> getCuriosSlot(Player player) {
        ICuriosItemHandler itemHandler;
        Optional slotResult;
        LazyOptional curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)player);
        if (curiosInventory.isPresent() && (slotResult = (itemHandler = (ICuriosItemHandler)curiosInventory.resolve().get()).findFirstCurio(itemStack -> itemStack.m_41720_() instanceof BackpackItem)).isPresent()) {
            return slotResult;
        }
        return Optional.empty();
    }

    public static Optional<ItemStack> getAdditionalSlotBackpack(Player player) {
        if (ModList.get().isLoaded("curios")) {
            Optional<SlotResult> slotResult = CompactStoragePlatformImpl.getCuriosSlot(player);
            return slotResult.map(SlotResult::stack);
        }
        return Optional.empty();
    }

    public static Optional<ItemStack> getBackpackToRender(Player player) {
        Optional<SlotResult> slotResult;
        if (ModList.get().isLoaded("curios") && (slotResult = CompactStoragePlatformImpl.getCuriosSlot(player)).isPresent() && slotResult.get().slotContext().visible()) {
            return slotResult.map(SlotResult::stack);
        }
        return Optional.empty();
    }
}

