/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common.block;

import com.mojang.serialization.MapCodec;
import com.witchica.compactstorage.common.CompactStorage;
import com.witchica.compactstorage.common.block.entity.DrumBlockEntity;
import com.witchica.compactstorage.common.util.CompactStorageUtil;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1750;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class DrumBlock
extends class_2237 {
    public static final class_2753 FACING = class_2753.method_35305((String)"facing");
    public static final class_2746 RETAINING = class_2746.method_11825((String)"retaining");
    private CompactStorageUtil.StorageVisualTypes type;
    public static final MapCodec<? extends class_2237> CODEC = DrumBlock.method_54094(DrumBlock::new);

    public DrumBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    public DrumBlock setVisualType(CompactStorageUtil.StorageVisualTypes type) {
        this.type = type;
        return this;
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        boolean retaining = ctx.method_8041().method_7985() ? ctx.method_8041().method_7969().method_10577("Retaining") : false;
        return (class_2680)((class_2680)super.method_9605(ctx).method_11657((class_2769)FACING, (Comparable)ctx.method_7715().method_10153())).method_11657((class_2769)RETAINING, (Comparable)Boolean.valueOf(retaining));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return (class_2680)super.method_9569(state, mirror).method_11657((class_2769)FACING, (Comparable)((class_2350)state.method_11654((class_2769)FACING)).method_10153());
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)super.method_9598(state, rotation).method_11657((class_2769)FACING, (Comparable)((class_2350)state.method_11654((class_2769)FACING)).method_10170());
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, RETAINING});
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, world, tooltip, options);
        tooltip.add((class_2561)class_2561.method_43471((String)"text.compact_storage.drum.tooltip_1").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
        tooltip.add((class_2561)class_2561.method_43471((String)"text.compact_storage.drum.tooltip_2").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
        if (stack.method_7985() && stack.method_7969().method_10545("Retaining") && stack.method_7969().method_10577("Retaining")) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.compact_storage.retaining").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}));
        }
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new DrumBlockEntity(pos, state);
    }

    public void extractItem(class_1937 world, class_2338 pos, class_1657 player) {
        DrumBlockEntity drumBlockEntity = (DrumBlockEntity)world.method_8321(pos);
        class_1277 inventory = drumBlockEntity.inventory;
        class_1799 extracted = inventory.method_5441(0);
        if (!extracted.method_7960()) {
            world.method_8649((class_1297)new class_1542(world, (double)player.method_31477(), (double)player.method_31478(), (double)player.method_31479(), extracted));
            world.method_8396(null, pos, class_3417.field_15197, class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    public void insertItem(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand) {
        class_1799 itemInHand = player.method_5998(hand);
        DrumBlockEntity drum = (DrumBlockEntity)world.method_8321(pos);
        class_1277 itemHandler = drum.inventory;
        boolean completed = false;
        if (itemInHand.method_7960() && drum.hasAnyItems()) {
            class_1661 playerInventory = player.method_31548();
            for (int i = 0; i < playerInventory.method_5439(); ++i) {
                class_1799 itemStack = playerInventory.method_5438(i);
                if (!itemHandler.method_5437(0, itemStack)) continue;
                class_1799 returned = itemHandler.method_5491(itemStack);
                if (itemStack.method_7947() == returned.method_7947()) continue;
                playerInventory.method_5447(i, returned);
                completed = true;
                break;
            }
        } else {
            class_1799 itemStack = player.method_5998(hand);
            if (itemHandler.method_5437(0, itemStack)) {
                class_1799 returned = itemHandler.method_5491(itemStack);
                if (itemStack.method_7947() != returned.method_7947()) {
                    player.method_6122(hand, returned);
                    completed = true;
                }
            }
        }
        if (completed) {
            world.method_8396(null, pos, class_3417.field_15197, class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!world.field_9236) {
            if (player.method_5998(hand).method_7909() == CompactStorage.UPGRADE_RETAINER_ITEM.get()) {
                class_2586 class_25862 = world.method_8321(pos);
                if (class_25862 instanceof DrumBlockEntity) {
                    DrumBlockEntity drumBlockEntity = (DrumBlockEntity)class_25862;
                    drumBlockEntity.setRetaining();
                    player.method_5998(hand).method_7934(1);
                    return class_1269.field_33562;
                }
            } else {
                class_1769 dyeItem;
                class_1792 class_17922;
                if (!this.type.isWooden() && (class_17922 = player.method_5998(hand).method_7909()) instanceof class_1769 && (dyeItem = (class_1769)class_17922).method_7802() != this.type.getAssociatedDyeColor()) {
                    class_2248 newBlock = CompactStorage.getDrumFromDyeColor(dyeItem.method_7802());
                    world.method_8501(pos, (class_2680)((class_2680)newBlock.method_9564().method_11657((class_2769)FACING, (Comparable)((class_2350)state.method_11654((class_2769)FACING)))).method_11657((class_2769)RETAINING, (Comparable)((Boolean)state.method_11654((class_2769)RETAINING))));
                    player.method_17356(class_3417.field_14788, class_3419.field_15245, 1.0f, 1.0f);
                    player.method_5998(hand).method_7934(1);
                    return class_1269.field_33562;
                }
                if (player.method_5715()) {
                    this.extractItem(world, pos, player);
                } else {
                    this.insertItem(world, pos, player, hand);
                }
            }
        }
        return class_1269.field_21466;
    }

    public void method_9606(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        if (!world.field_9236) {
            this.extractItem(world, pos, player);
        }
        super.method_9606(state, world, pos, player);
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof DrumBlockEntity) {
            DrumBlockEntity drumBlock = (DrumBlockEntity)blockEntity;
            int totalItemCount = drumBlock.getTotalItemCount();
            int stackSize = drumBlock.getStoredType().method_7882();
            int output = class_3532.method_15375((float)((float)totalItemCount / (float)stackSize / 64.0f * 15.0f));
            return output;
        }
        return 0;
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        class_2586 class_25862;
        if (!level.field_9236 && stack.method_7985() && stack.method_7969().method_10545("Retaining") && (class_25862 = level.method_8321(pos)) instanceof DrumBlockEntity) {
            DrumBlockEntity drumBlock = (DrumBlockEntity)class_25862;
            drumBlock.method_11014(stack.method_7969());
            drumBlock.method_5431();
        }
        super.method_9567(level, pos, state, placer, stack);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204()) && !(newState.method_26204() instanceof DrumBlock)) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof DrumBlockEntity) {
                DrumBlockEntity drumBlock = (DrumBlockEntity)blockEntity;
                if (!drumBlock.getRetaining()) {
                    class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)drumBlock.inventory);
                }
                class_1799 itemStack = new class_1799((class_1935)this, 1);
                drumBlock.method_38240(itemStack);
                class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)itemStack);
                world.method_8455(pos, state.method_26204());
            }
            world.method_8544(pos);
        }
    }

    public CompactStorageUtil.StorageVisualTypes getType() {
        return this.type;
    }
}

