/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common.block.entity;

import com.witchica.compactstorage.common.CompactStorage;
import com.witchica.compactstorage.common.block.CompactBarrelBlock;
import com.witchica.compactstorage.common.screen.CompactChestScreenHandler;
import com.witchica.compactstorage.common.util.CompactStorageInventoryImpl;
import com.witchica.compactstorage.common.util.CompactStorageUtil;
import com.witchica.compactstorage.common.util.InventoryOpenSource;
import com.witchica.compactstorage.common.util.StorageUpgradeType;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2621;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class CompactBarrelBlockEntity
extends class_2621
implements CompactStorageInventoryImpl {
    private class_2371<class_1799> inventory = class_2371.method_10213((int)(this.inventoryWidth * this.inventoryHeight), (Object)class_1799.field_8037);
    public int inventoryWidth = 9;
    public int inventoryHeight = 6;
    public int playersUsing = 0;
    public int playersUsingOld = 0;
    public boolean isOpen = false;
    private boolean retaining = false;

    public CompactBarrelBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)CompactStorage.COMPACT_BARREL_ENTITY_TYPE.get(), blockPos, blockState);
    }

    public int method_5439() {
        return this.inventoryWidth * this.inventoryHeight;
    }

    protected class_2371<class_1799> getInvStackList() {
        return this.inventory;
    }

    public class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    protected void method_11281(class_2371<class_1799> stackList) {
        this.inventory = stackList;
    }

    protected class_2561 method_17823() {
        return this.method_11010().method_26204().method_9518();
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new CompactChestScreenHandler(syncId, playerInventory, this.writeToByteBuf());
    }

    @Override
    public int getInventoryWidth() {
        return this.inventoryWidth;
    }

    @Override
    public int getInventoryHeight() {
        return this.inventoryHeight;
    }

    public void method_5435(class_1657 player) {
        super.method_5435(player);
        if (!player.method_7325()) {
            ++this.playersUsing;
        }
    }

    public void method_5432(class_1657 player) {
        super.method_5432(player);
        if (!player.method_7325()) {
            --this.playersUsing;
        }
    }

    public void resizeInventory(boolean copy_contents) {
        class_2371 newInventory = class_2371.method_10213((int)(this.inventoryWidth * this.inventoryHeight), (Object)class_1799.field_8037);
        if (copy_contents) {
            class_2371<class_1799> list = this.inventory;
            for (int i = 0; i < list.size(); ++i) {
                newInventory.set(i, (Object)((class_1799)list.get(i)));
            }
        }
        this.inventory = newInventory;
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventoryWidth = nbt.method_10545("inventory_width") ? nbt.method_10550("inventory_width") : 9;
        this.inventoryHeight = nbt.method_10545("inventory_height") ? nbt.method_10550("inventory_height") : 3;
        this.retaining = nbt.method_10545("retaining") && nbt.method_10577("retaining");
        this.inventory = class_2371.method_10213((int)(this.inventoryWidth * this.inventoryHeight), (Object)class_1799.field_8037);
        this.readItemsFromTag(this.inventory, nbt);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.writeItemsToTag(this.inventory, nbt);
        nbt.method_10569("inventory_width", this.inventoryWidth);
        nbt.method_10569("inventory_height", this.inventoryHeight);
        nbt.method_10556("retaining", this.retaining);
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, CompactBarrelBlockEntity compactChestBlockEntity) {
        if (!world.method_8608() && ((Boolean)world.method_8320(pos).method_11654((class_2769)CompactBarrelBlock.RETAINING)).booleanValue() != compactChestBlockEntity.getRetaining()) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)CompactBarrelBlock.RETAINING, (Comparable)Boolean.valueOf(compactChestBlockEntity.getRetaining())));
        }
        if (compactChestBlockEntity.playersUsing > 0 && compactChestBlockEntity.playersUsingOld == 0) {
            compactChestBlockEntity.isOpen = true;
            world.method_8486((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_17604, class_3419.field_15245, 1.0f, 0.9f, true);
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)CompactBarrelBlock.OPEN, (Comparable)Boolean.valueOf(true)));
        } else if (compactChestBlockEntity.playersUsing == 0 && compactChestBlockEntity.playersUsingOld != 0) {
            compactChestBlockEntity.isOpen = false;
            world.method_8486((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_17603, class_3419.field_15245, 1.0f, 0.9f, true);
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)CompactBarrelBlock.OPEN, (Comparable)Boolean.valueOf(false)));
        }
        compactChestBlockEntity.playersUsingOld = compactChestBlockEntity.playersUsing;
    }

    public class_2540 writeToByteBuf() {
        class_2540 packetByteBuf = new class_2540(Unpooled.buffer());
        packetByteBuf.method_53002(InventoryOpenSource.CHEST_BARREL.ordinal());
        packetByteBuf.method_10807(this.method_11016());
        return packetByteBuf;
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 playerEntity) {
        return new CompactChestScreenHandler(syncId, playerInventory, this.writeToByteBuf());
    }

    public class_2561 method_5476() {
        return this.method_5477();
    }

    public boolean increaseSize(int x, int y) {
        if (this.inventoryWidth > 20 && x > 0 || this.inventoryHeight > 11 && y > 0) {
            return false;
        }
        this.inventoryWidth += x;
        this.inventoryHeight += y;
        this.resizeInventory(true);
        this.method_5431();
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 1);
        return true;
    }

    @Override
    public void setRetaining() {
        this.retaining = true;
        this.method_5431();
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 1);
    }

    @Override
    public CompactStorageUtil.StorageVisualTypes getVisualType() {
        return ((CompactBarrelBlock)this.method_11010().method_26204()).getVisualType();
    }

    @Override
    public boolean getRetaining() {
        return this.retaining;
    }

    public void method_38240(class_1799 stack) {
        class_2487 compoundTag = this.method_38244();
        if (!this.retaining) {
            compoundTag.method_10551("Items");
        }
        if (compoundTag.method_10545("CustomName")) {
            if (!compoundTag.method_10545("display")) {
                compoundTag.method_10566("display", (class_2520)new class_2487());
            }
            compoundTag.method_10562("display").method_10566("Name", compoundTag.method_10580("CustomName"));
            compoundTag.method_10551("CustomName");
        }
        stack.method_7980(compoundTag);
    }

    @Override
    public boolean applyUpgrade(StorageUpgradeType upgradeType) {
        if (!this.canAcceptUpgrade(upgradeType)) {
            return false;
        }
        switch (upgradeType) {
            case ROW: {
                this.increaseSize(1, 0);
                return true;
            }
            case COLUMM: {
                this.increaseSize(0, 1);
                return true;
            }
            case RETAINING: {
                this.setRetaining();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasUpgrade(StorageUpgradeType upgradeType) {
        switch (upgradeType) {
            case ROW: {
                return this.inventoryWidth > 9;
            }
            case COLUMM: {
                return this.inventoryHeight > 6;
            }
            case RETAINING: {
                return this.retaining;
            }
        }
        return false;
    }

    @Override
    public boolean canAcceptUpgrade(StorageUpgradeType upgradeType) {
        switch (upgradeType) {
            case RETAINING: {
                return !this.retaining;
            }
            case ROW: {
                return this.inventoryWidth < 21;
            }
            case COLUMM: {
                return this.inventoryHeight < 12;
            }
        }
        return false;
    }
}

