/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common.inventory;

import com.witchica.compactstorage.CompactStoragePlatform;
import com.witchica.compactstorage.common.item.BackpackItem;
import com.witchica.compactstorage.common.util.CompactStorageInventoryImpl;
import com.witchica.compactstorage.common.util.CompactStorageUtil;
import com.witchica.compactstorage.common.util.InventoryOpenSource;
import com.witchica.compactstorage.common.util.StorageUpgradeType;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class BackpackInventory
implements class_1263,
CompactStorageInventoryImpl {
    private final class_1799 backpackItem;
    private final Optional<class_1268> hand;
    private final InventoryOpenSource openSource;
    public class_2371<class_1799> items;
    public int inventoryWidth;
    public int inventoryHeight;
    private final class_1657 player;

    public BackpackInventory(class_1657 player, InventoryOpenSource openSource, class_1799 backpackStack, Optional<class_1268> hand) {
        this.player = player;
        this.hand = hand;
        this.openSource = openSource;
        this.backpackItem = backpackStack;
        if (backpackStack.method_7985()) {
            this.fromTag(backpackStack.method_7969().method_10545("Backpack") ? backpackStack.method_7969().method_10562("Backpack") : new class_2487());
        } else {
            this.fromTag(new class_2487());
        }
    }

    public void resizeInventory(boolean copy_contents) {
        class_2371 newInventory = class_2371.method_10213((int)(this.inventoryWidth * this.inventoryHeight), (Object)class_1799.field_8037);
        if (copy_contents) {
            class_2371<class_1799> list = this.items;
            for (int i = 0; i < list.size(); ++i) {
                newInventory.set(i, (Object)((class_1799)list.get(i)));
            }
        }
        this.items = newInventory;
    }

    public void method_5448() {
        this.items.clear();
    }

    @Override
    public int getInventoryWidth() {
        return this.inventoryWidth;
    }

    @Override
    public int getInventoryHeight() {
        return this.inventoryHeight;
    }

    @Override
    public boolean getRetaining() {
        return false;
    }

    @Override
    public void setRetaining() {
    }

    @Override
    public CompactStorageUtil.StorageVisualTypes getVisualType() {
        class_1792 class_17922;
        if (this.backpackItem != null && !this.backpackItem.method_7960() && (class_17922 = this.backpackItem.method_7909()) instanceof BackpackItem) {
            BackpackItem backpack = (BackpackItem)class_17922;
            return backpack.getVisualType();
        }
        return CompactStorageUtil.StorageVisualTypes.RED;
    }

    public int method_5439() {
        return this.getInventoryWidth() * this.getInventoryHeight();
    }

    public boolean method_5442() {
        return this.items.stream().allMatch(class_1799::method_7960);
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.items.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return class_1262.method_5430(this.items, (int)slot, (int)amount);
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.items, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.items.set(slot, (Object)stack);
    }

    public void method_5431() {
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void fromTag(class_2487 tag) {
        this.inventoryWidth = tag.method_10545("inventory_width") ? tag.method_10550("inventory_width") : 9;
        this.inventoryHeight = tag.method_10545("inventory_height") ? tag.method_10550("inventory_height") : 6;
        this.items = class_2371.method_10213((int)(this.inventoryWidth * this.inventoryHeight), (Object)class_1799.field_8037);
        this.readItemsFromTag(this.items, tag);
    }

    public boolean increaseSize(int x, int y) {
        if (this.inventoryWidth > 20 && x > 0 || this.inventoryHeight > 11 && y > 0) {
            return false;
        }
        this.inventoryWidth += x;
        this.inventoryHeight += y;
        this.resizeInventory(true);
        this.method_5431();
        return true;
    }

    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10569("inventory_width", this.inventoryWidth);
        tag.method_10569("inventory_height", this.inventoryHeight);
        this.writeItemsToTag(this.items, tag);
        return tag;
    }

    public void method_5435(class_1657 player) {
        super.method_5435(player);
        player.method_17356(this.getVisualType().isWooden() ? class_3417.field_14932 : class_3417.field_14983, class_3419.field_15248, 1.0f, 1.0f);
    }

    public void method_5432(class_1657 player) {
        class_1799 stack;
        super.method_5432(player);
        class_1661 inventory = player.method_31548();
        if (this.openSource == InventoryOpenSource.BACKPACK_OPEN_HAND) {
            class_1268 playerHand = this.hand.orElse(class_1268.field_5808);
            if (player.method_5998(playerHand).method_7909() instanceof BackpackItem) {
                if (!player.method_5998(playerHand).method_7985()) {
                    player.method_5998(playerHand).method_7980(new class_2487());
                }
                player.method_5998(playerHand).method_7969().method_10566("Backpack", (class_2520)this.toTag());
            }
        } else if (this.openSource == InventoryOpenSource.BACKPACK_OPEN_INVENTORY && (stack = CompactStoragePlatform.getAdditionalSlotBackpack(player).orElse(class_1799.field_8037)).method_7909() instanceof BackpackItem) {
            if (!stack.method_7985()) {
                stack.method_7980(new class_2487());
            }
            stack.method_7969().method_10566("Backpack", (class_2520)this.toTag());
        }
        player.method_17356(this.getVisualType().isWooden() ? class_3417.field_15080 : class_3417.field_14983, class_3419.field_15248, 1.0f, 1.0f);
    }

    @Override
    public boolean applyUpgrade(StorageUpgradeType upgradeType) {
        if (!this.canAcceptUpgrade(upgradeType)) {
            return false;
        }
        switch (upgradeType) {
            case ROW: {
                return this.increaseSize(1, 0);
            }
            case COLUMM: {
                return this.increaseSize(0, 1);
            }
        }
        return false;
    }

    @Override
    public boolean hasUpgrade(StorageUpgradeType upgradeType) {
        switch (upgradeType) {
            case ROW: {
                return this.inventoryWidth > 9;
            }
            case COLUMM: {
                return this.inventoryHeight > 6;
            }
        }
        return false;
    }

    @Override
    public boolean canAcceptUpgrade(StorageUpgradeType upgradeType) {
        switch (upgradeType) {
            case ROW: {
                return this.inventoryWidth < 21;
            }
            case COLUMM: {
                return this.inventoryHeight < 12;
            }
        }
        return false;
    }
}

