/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common.screen;

import com.witchica.compactstorage.common.CompactStorage;
import com.witchica.compactstorage.common.inventory.BackpackInventory;
import com.witchica.compactstorage.common.inventory.BackpackInventoryHandlerFactory;
import com.witchica.compactstorage.common.inventory.slot.BackpackHoldSlot;
import com.witchica.compactstorage.common.util.CompactStorageInventoryImpl;
import com.witchica.compactstorage.common.util.CompactStorageUtil;
import com.witchica.compactstorage.common.util.InventoryOpenSource;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Nullable;

public class CompactChestScreenHandler
extends class_1703 {
    private class_1263 inventory;
    private class_1661 playerInventory;
    public CompactStorageInventoryImpl blockEntity;
    public int inventoryWidth;
    public int inventoryHeight;
    public InventoryOpenSource openSource;
    private int backpackSlot = -1;
    public CompactStorageUtil.StorageVisualTypes visualType;

    public CompactChestScreenHandler(int syncId, class_1661 playerInventory, class_2540 buf) {
        super((class_3917)CompactStorage.COMPACT_CHEST_SCREEN_HANDLER.get(), syncId);
        this.openSource = InventoryOpenSource.values()[buf.readInt()];
        this.playerInventory = playerInventory;
        switch (this.openSource) {
            case CHEST_BARREL: {
                class_2338 pos = buf.method_10811();
                CompactStorageInventoryImpl inv = (CompactStorageInventoryImpl)playerInventory.field_7546.method_37908().method_8321(pos);
                this.inventory = (class_1263)inv;
                this.inventoryWidth = inv.getInventoryWidth();
                this.inventoryHeight = inv.getInventoryHeight();
                this.visualType = inv.getVisualType();
                this.blockEntity = inv;
                break;
            }
            default: {
                Optional<class_1268> hand = Optional.of(class_1268.values()[buf.readInt()]);
                BackpackInventory backpackInventory = BackpackInventoryHandlerFactory.getBackpackInventory(playerInventory.field_7546, this.openSource, hand);
                this.visualType = backpackInventory.getVisualType();
                this.inventory = backpackInventory;
                this.inventoryWidth = backpackInventory.inventoryWidth;
                this.inventoryHeight = backpackInventory.inventoryHeight;
                this.blockEntity = null;
                if (this.openSource != InventoryOpenSource.BACKPACK_OPEN_HAND || hand.get() != class_1268.field_5808) break;
                this.backpackSlot = playerInventory.field_7545;
                break;
            }
        }
        CompactChestScreenHandler.method_17359((class_1263)this.inventory, (int)(this.inventoryWidth * this.inventoryHeight));
        this.inventory.method_5435(playerInventory.field_7546);
        this.setupSlots(true);
    }

    protected CompactChestScreenHandler(@Nullable class_3917<?> type, int syncId) {
        super(type, syncId);
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.inventory.method_5432(player);
    }

    public void setupSlots(boolean includeChestInventory) {
        int j;
        int i;
        boolean checkBackpack = this.openSource != InventoryOpenSource.CHEST_BARREL;
        this.field_7761.clear();
        int chestInvHeight = this.inventoryHeight * 18;
        for (i = 0; i < this.inventoryHeight; ++i) {
            for (j = 0; j < this.inventoryWidth; ++j) {
                BackpackHoldSlot slot = new BackpackHoldSlot(this.inventory, i * this.inventoryWidth + j, 8 + j * 18, 19 + i * 18, checkBackpack);
                this.method_7621(slot);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.method_7621(new BackpackHoldSlot((class_1263)this.playerInventory, i * 9 + j + 9, 8 + this.inventoryWidth * 18 / 2 - 81 + j * 18, 25 + i * 18 + chestInvHeight + 18, checkBackpack));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.method_7621(new BackpackHoldSlot((class_1263)this.playerInventory, j, 8 + this.inventoryWidth * 18 / 2 - 81 + j * 18, 25 + chestInvHeight + 60 + 18, checkBackpack));
        }
    }

    public boolean method_7597(class_1657 player) {
        return this.inventory.method_5443(player);
    }

    public class_1799 method_7601(class_1657 player, int invSlot) {
        class_1799 newStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(invSlot);
        if (slot != null && slot.method_7681()) {
            class_1799 originalStack = slot.method_7677();
            newStack = originalStack.method_7972();
            if (invSlot < this.inventory.method_5439() ? !this.method_7616(originalStack, this.inventory.method_5439(), this.field_7761.size(), true) : !this.method_7616(originalStack, 0, this.inventory.method_5439(), false)) {
                return class_1799.field_8037;
            }
            if (originalStack.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return newStack;
    }
}

