/*
 * Decompiled with CFR 0.152.
 */
package com.wynnventory.api;

import com.wynnventory.core.ModInfo;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;

public final class ApiConfig {
    private static final String PROD_BASE = "https://www.wynnventory.com/api/";
    private static final String DEV_BASE = "https://wynn-ventory-dev-2a243523ab77.herokuapp.com/api/";
    private static final URI PROD_URI = URI.create("https://www.wynnventory.com/api/");
    private static final URI DEV_URI = URI.create("https://wynn-ventory-dev-2a243523ab77.herokuapp.com/api/");
    private static final byte MASK = 90;
    private static String apiKey;

    private ApiConfig() {
    }

    public static URI baseUri() {
        return ModInfo.isDev() ? DEV_URI : PROD_URI;
    }

    public static String getApiKey() {
        String string;
        block12: {
            if (apiKey != null) {
                return apiKey;
            }
            InputStream in = ApiConfig.class.getResourceAsStream("/key.dat");
            try {
                if (in == null) {
                    throw new IllegalStateException("Missing key.dat!");
                }
                byte[] b64 = in.readAllBytes();
                byte[] defaultC = "${api_key}".getBytes(StandardCharsets.UTF_8);
                if (Arrays.equals(defaultC, b64)) {
                    b64 = System.getenv("API_KEY").getBytes(StandardCharsets.UTF_8);
                }
                byte[] ob = Base64.getDecoder().decode(b64);
                int i = 0;
                while (i < ob.length) {
                    int n = i++;
                    ob[n] = (byte)(ob[n] ^ 0x5A);
                }
                string = apiKey = new String(ob, StandardCharsets.UTF_8);
                if (in == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to load API key", e);
                }
            }
            in.close();
        }
        return string;
    }
}

