/*
 * Decompiled with CFR 0.152.
 */
package com.wynnventory.api;

import com.wynnventory.accessor.ItemQueueAccessor;
import com.wynnventory.api.WynnventoryAPI;
import com.wynnventory.core.ModInfo;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_310;

public class WynnventoryScheduler {
    private static final WynnventoryAPI API = new WynnventoryAPI();
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final int SEND_DELAY_MINS = 5;

    private WynnventoryScheduler() {
    }

    public static void startScheduledTask() {
        scheduler.scheduleAtFixedRate(WynnventoryScheduler::processBufferQueues, 1L, 5L, TimeUnit.MINUTES);
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> WynnventoryScheduler.stopScheduledTask());
    }

    public static void stopScheduledTask() {
        ModInfo.logInfo("Shutdown detected...");
        WynnventoryScheduler.processBufferQueues();
        scheduler.shutdown();
        try {
            if (!scheduler.awaitTermination(5L, TimeUnit.MINUTES)) {
                scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            scheduler.shutdownNow();
        }
    }

    private static void processBufferQueues() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.method_1562() != null) {
            ItemQueueAccessor accessor = (ItemQueueAccessor)minecraft.method_1562();
            if (!accessor.getQueuedMarketItems().isEmpty()) {
                API.sendTradeMarketResults(accessor.getQueuedMarketItems());
                accessor.getQueuedMarketItems().clear();
            }
            if (!accessor.getQueuedLootpools().isEmpty()) {
                API.sendLootpoolData(accessor.getQueuedLootpools().values().stream().toList());
                accessor.getQueuedLootpools().clear();
            }
            if (!accessor.getQueuedRaidpools().isEmpty()) {
                API.sendRaidpoolData(accessor.getQueuedRaidpools().values().stream().toList());
                accessor.getQueuedRaidpools().clear();
            }
            if (!accessor.getQueuedGambitItems().isEmpty()) {
                API.sendGambitItems(accessor.getQueuedGambitItems());
                accessor.getQueuedGambitItems().clear();
            }
        }
    }
}

