/*
 * Decompiled with CFR 0.152.
 */
package com.wynnventory.enums;

import com.wynnventory.enums.RegionType;

public enum Region {
    CANYON_OF_THE_LOST("COTL", "Canyon of the Lost", "\udaff\udff2\ue00a\udaff\udf6f\uf006", RegionType.LOOTRUN),
    CORKUS("Corkus", "Corkus", "\udaff\udff2\ue00a\udaff\udf6f\uf007", RegionType.LOOTRUN),
    MOLTEN_HEIGHTS("Molten Heights", "Molten Heights", "\udaff\udff2\ue00a\udaff\udf6f\uf008", RegionType.LOOTRUN),
    SKY_ISLANDS("Sky Islands", "Sky Islands", "\udaff\udff2\ue00a\udaff\udf6f\uf009", RegionType.LOOTRUN),
    SILENT_EXPANSE("Silent Expanse", "Silent Expanse", "\udaff\udff2\ue00a\udaff\udf6f\uf00a", RegionType.LOOTRUN),
    NEST_OF_GROOTSLANGS("NOTG", "Nest of the Grootslangs", "\udaff\udfea\ue00d\udaff\udf6f\uf00b", RegionType.RAID),
    NEXUS_OF_LIGHT("NOL", "Orphion's Nexus of Light", "\udaff\udfea\ue00d\udaff\udf6f\uf00c", RegionType.RAID),
    CANYON_COLOSSUS("TCC", "The Canyon Colossus", "\udaff\udfea\ue00d\udaff\udf6f\uf00d", RegionType.RAID),
    NAMELESS_ANOMALY("TNA", "The Nameless Anomaly", "\udaff\udfea\ue00d\udaff\udf6f\uf00e", RegionType.RAID);

    private final String shortName;
    private final String name;
    private final String inventoryTitle;
    private final RegionType type;

    private Region(String shortName, String name, String inventoryTitle, RegionType type) {
        this.shortName = shortName;
        this.name = name;
        this.inventoryTitle = inventoryTitle;
        this.type = type;
    }

    public static Region getRegionByShortName(String shortName) {
        for (Region region : Region.values()) {
            if (!region.getShortName().equals(shortName)) continue;
            return region;
        }
        return null;
    }

    public static Region getRegionByName(String name) {
        for (Region region : Region.values()) {
            if (!region.getName().equals(name)) continue;
            return region;
        }
        return null;
    }

    public static Region getRegionByInventoryTitle(String inventoryTitle) {
        for (Region region : Region.values()) {
            if (!region.getInventoryTitle().equals(inventoryTitle)) continue;
            return region;
        }
        return null;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getName() {
        return this.name;
    }

    public String getInventoryTitle() {
        return this.inventoryTitle;
    }

    public RegionType getRegionType() {
        return this.type;
    }
}

