/*
 * Decompiled with CFR 0.152.
 */
package com.wynnventory.mixin;

import com.wynntils.core.components.Models;
import com.wynntils.models.items.ItemModel;
import com.wynntils.models.items.items.gui.GambitItem;
import com.wynntils.utils.mc.McUtils;
import com.wynnventory.accessor.ItemQueueAccessor;
import com.wynnventory.core.ModInfo;
import com.wynnventory.enums.Region;
import com.wynnventory.enums.RegionType;
import com.wynnventory.model.item.Lootpool;
import com.wynnventory.model.item.LootpoolItem;
import com.wynnventory.model.item.simplified.SimplifiedGambitItem;
import com.wynnventory.model.item.trademarket.TradeMarketItem;
import com.wynnventory.util.FavouriteNotifier;
import com.wynnventory.util.ModUpdater;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2649;
import net.minecraft.class_2678;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_634;
import net.minecraft.class_8673;
import net.minecraft.class_8675;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_634.class})
public abstract class ClientPacketListenerMixin
extends class_8673
implements ItemQueueAccessor {
    private static final int CONTAINER_SLOTS = 54;
    private static int JOIN_COUNTER = 0;
    private static final String RAID_WINDOW_TITLE = "\udaff\udfe1\ue00c";
    @Unique
    private final List<TradeMarketItem> marketItemBuffer = new ArrayList<TradeMarketItem>();
    @Unique
    private final List<SimplifiedGambitItem> gambitItemBuffer = new ArrayList<SimplifiedGambitItem>();
    @Unique
    private final Map<String, Lootpool> lootpoolBuffer = new ConcurrentHashMap<String, Lootpool>();
    @Unique
    private final Map<String, Lootpool> raidpoolBuffer = new ConcurrentHashMap<String, Lootpool>();

    protected ClientPacketListenerMixin(class_310 minecraft, class_2535 connection, class_8675 commonListenerCookie) {
        super(minecraft, connection, commonListenerCookie);
    }

    @Inject(method={"handleLogin"}, at={@At(value="RETURN")})
    private void onPlayerJoin(class_2678 packet, CallbackInfo ci) {
        if (++JOIN_COUNTER == 2) {
            ModUpdater.checkForUpdates();
            FavouriteNotifier.checkFavourites();
        }
    }

    @Inject(method={"handleContainerContent"}, at={@At(value="RETURN")})
    private void handleContainerContent(class_2649 packet, CallbackInfo ci) {
        class_465 containerScreen;
        block7: {
            block6: {
                class_437 currentScreen = class_310.method_1551().field_1755;
                if (!(currentScreen instanceof class_465)) break block6;
                containerScreen = (class_465)currentScreen;
                if (packet.method_11440() > 0) break block7;
            }
            return;
        }
        String title = containerScreen.method_25440().getString();
        List packetItems = packet.method_11441();
        Region region = Region.getRegionByInventoryTitle(title);
        if (region != null && region.getRegionType() != null) {
            this.handleRewardContainer(region, packetItems);
        } else if (RAID_WINDOW_TITLE.equalsIgnoreCase(title)) {
            this.handleRaidWindowContainer(packetItems);
        }
    }

    @Unique
    private void handleRewardContainer(Region region, List<class_1799> items) {
        if (ModInfo.isDev()) {
            McUtils.sendMessageToClient((class_2561)class_2561.method_43470((String)(String.valueOf((Object)region.getRegionType()) + " DETECTED. Region is " + region.getShortName())));
        }
        List<class_1799> filtered = items.stream().limit(54L).filter(item -> !item.method_7960() && item.method_7909() != class_1802.field_8251).toList();
        this.addItemsToLootpoolQueue(region, filtered);
    }

    @Unique
    private void handleRaidWindowContainer(List<class_1799> items) {
        items.stream().limit(54L).filter(item -> !item.method_7960() && item.method_7909() != class_1802.field_8251).map(arg_0 -> ((ItemModel)Models.Item).getWynnItem(arg_0)).filter(Optional::isPresent).map(Optional::get).filter(GambitItem.class::isInstance).map(GambitItem.class::cast).forEach(this::addItemToGambitQueue);
    }

    @Override
    public void addItemToTrademarketQueue(class_1799 item) {
        if (item.method_7909() == class_1802.field_8162 || item.method_7909() == class_1802.field_8251 || item.method_7909() == class_1802.field_8574) {
            return;
        }
        if (McUtils.inventory().field_7547.contains((Object)item)) {
            return;
        }
        TradeMarketItem tradeMarketItem = TradeMarketItem.from(item);
        if (tradeMarketItem != null && !this.marketItemBuffer.contains(tradeMarketItem)) {
            this.marketItemBuffer.add(tradeMarketItem);
        }
    }

    @Override
    public void addItemToGambitQueue(GambitItem gambitItem) {
        SimplifiedGambitItem item = new SimplifiedGambitItem(gambitItem);
        if (!this.gambitItemBuffer.contains(item)) {
            this.gambitItemBuffer.add(item);
        }
    }

    @Override
    public void addItemsToLootpoolQueue(Region region, List<class_1799> items) {
        String shortName = region.getShortName();
        if (region.getRegionType() == RegionType.LOOTRUN) {
            this.lootpoolBuffer.computeIfAbsent(shortName, k -> new Lootpool(region)).addItems(LootpoolItem.createLootpoolItemsFromItemStack(items));
        } else if (region.getRegionType() == RegionType.RAID) {
            this.raidpoolBuffer.computeIfAbsent(shortName, k -> new Lootpool(region)).addItems(LootpoolItem.createLootpoolItemsFromItemStack(items));
        }
    }

    @Override
    public List<TradeMarketItem> getQueuedMarketItems() {
        return this.marketItemBuffer;
    }

    @Override
    public List<SimplifiedGambitItem> getQueuedGambitItems() {
        return this.gambitItemBuffer;
    }

    @Override
    public Map<String, Lootpool> getQueuedLootpools() {
        return this.lootpoolBuffer;
    }

    @Override
    public Map<String, Lootpool> getQueuedRaidpools() {
        return this.raidpoolBuffer;
    }
}

