/*
 * Decompiled with CFR 0.152.
 */
package com.wynnventory.mixin;

import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.guides.aspect.GuideAspectItemStack;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynnventory.accessor.ItemQueueAccessor;
import com.wynnventory.config.ConfigManager;
import com.wynnventory.enums.Region;
import com.wynnventory.enums.RegionType;
import com.wynnventory.mixin.AbstractContainerScreenAccessor;
import com.wynnventory.model.item.Lootpool;
import com.wynnventory.ui.WynnventoryItemButton;
import com.wynnventory.util.AspectTooltipHelper;
import com.wynnventory.util.ItemStackUtils;
import com.wynnventory.util.LootpoolManager;
import com.wynnventory.util.PriceTooltipHelper;
import com.wynnventory.util.RaidDisplayQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_465.class})
public abstract class TooltipMixin {
    private static final String MARKET_TITLE = "\udaff\udfe8\ue011";
    private static final String PARTY_FINDER_TITLE = "Party Finder";
    private final ConfigManager config = ConfigManager.getInstance();
    private final ItemQueueAccessor accessor = (ItemQueueAccessor)McUtils.mc().method_1562();

    @Inject(method={"renderTooltip(Lnet/minecraft/client/gui/GuiGraphics;II)V"}, at={@At(value="RETURN")})
    private void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY, CallbackInfo ci) {
        String title;
        class_437 screen = class_310.method_1551().field_1755;
        if (screen == null) {
            return;
        }
        class_1735 slot = ((AbstractContainerScreenAccessor)((Object)this)).getHoveredSlot();
        if (slot == null || !slot.method_7681()) {
            return;
        }
        class_1799 stack = slot.method_7677();
        if (this.config.isShowTooltips()) {
            Models.Item.getWynnItem(stack).ifPresent(wynnItem -> this.renderPriceTooltip(guiGraphics, mouseX, mouseY, stack));
        }
        if (MARKET_TITLE.equalsIgnoreCase(title = screen.method_25440().getString())) {
            this.enqueueForMarket(stack);
        } else if (PARTY_FINDER_TITLE.equalsIgnoreCase(title)) {
            this.renderPartyFinderAspects(guiGraphics, mouseX, mouseY, stack);
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    public void renderRaidAspects(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (!RaidDisplayQueue.shouldShowRaidAspects()) {
            return;
        }
        Map aspectStacks = Models.Aspect.getAllAspectInfos().map(info -> new GuideAspectItemStack(info, 1)).collect(Collectors.toMap(stack -> stack.getAspectInfo().name(), Function.identity()));
        List<Lootpool> raidPools = LootpoolManager.getRaidPools();
        ArrayList tooltipButtons = new ArrayList();
        int x = 20;
        int y = 75;
        int itemSize = 16;
        int spacing = 22;
        for (Lootpool pool : raidPools) {
            Region region = Region.getRegionByShortName(pool.getRegion());
            if (region == null) continue;
            class_5250 title = class_2561.method_43470((String)(region.getShortName() + " Mythic Aspects")).method_27695(new class_124[]{class_124.field_1068, class_124.field_1067});
            guiGraphics.method_27535(McUtils.mc().field_1772, (class_2561)title, x, y, 0xFFFFFF);
            int[] buttonX = new int[]{x};
            int buttonY = y + 12;
            pool.getMythicAspects().forEach(lootItem -> {
                GuideAspectItemStack stack = (GuideAspectItemStack)aspectStacks.get(lootItem.getName());
                if (stack == null) {
                    return;
                }
                WynnventoryItemButton<GuideAspectItemStack> button = new WynnventoryItemButton<GuideAspectItemStack>(buttonX[0], buttonY, itemSize, itemSize, stack, false);
                button.method_48229(buttonX[0], buttonY);
                button.method_48579(guiGraphics, mouseX, mouseY, partialTick);
                tooltipButtons.add(button);
                buttonX[0] = buttonX[0] + spacing;
            });
            y += 40;
        }
        for (WynnventoryItemButton button : tooltipButtons) {
            if (!this.isMouseOver(button, mouseX, mouseY)) continue;
            guiGraphics.method_51446(FontRenderer.getInstance().getFont(), button.getItemStack(), mouseX, mouseY);
            PriceTooltipHelper.renderPriceInfoTooltip(guiGraphics, mouseX, mouseY, button.getItemStack(), ItemStackUtils.getTooltips(button.getItemStack()), false);
        }
    }

    @Unique
    private boolean isMouseOver(WynnventoryItemButton<?> button, int mouseX, int mouseY) {
        return mouseX >= button.method_46426() && mouseX <= button.method_46426() + button.method_25368() && mouseY >= button.method_46427() && mouseY <= button.method_46427() + button.method_25364();
    }

    @Unique
    private void renderPriceTooltip(class_332 guiGraphics, int x, int y, class_1799 stack) {
        List<class_2561> tooltips = ItemStackUtils.getTooltips(stack);
        PriceTooltipHelper.renderPriceInfoTooltip(guiGraphics, x, y, stack, tooltips, this.config.isAnchorTooltips());
    }

    @Unique
    private void enqueueForMarket(class_1799 stack) {
        this.accessor.addItemToTrademarketQueue(stack);
    }

    @Unique
    private void renderPartyFinderAspects(class_332 guiGraphics, int x, int y, class_1799 stack) {
        StyledText originalName = ItemStackUtils.getWynntilsOriginalName(stack);
        if (originalName == null) {
            return;
        }
        String name = originalName.getStringWithoutFormatting();
        Region region = Region.getRegionByName(name);
        if (region == null || region.getRegionType() != RegionType.RAID) {
            return;
        }
        LootpoolManager.getRaidPools().stream().filter(pool -> pool.getRegion().equalsIgnoreCase(region.getShortName())).findFirst().ifPresent(pool -> AspectTooltipHelper.renderAspectTooltip(guiGraphics, x, y, pool));
    }
}

