/*
 * Decompiled with CFR 0.152.
 */
package com.wynnventory.model.item;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.wynntils.core.components.Models;
import com.wynntils.models.gear.GearModel;
import com.wynntils.models.gear.type.GearInfo;
import com.wynntils.models.gear.type.GearInstance;
import com.wynntils.models.gear.type.GearRestrictions;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.items.game.AmplifierItem;
import com.wynntils.models.items.items.game.AspectItem;
import com.wynntils.models.items.items.game.DungeonKeyItem;
import com.wynntils.models.items.items.game.EmeraldItem;
import com.wynntils.models.items.items.game.GearBoxItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.models.items.items.game.InsulatorItem;
import com.wynntils.models.items.items.game.MiscItem;
import com.wynntils.models.items.items.game.PowderItem;
import com.wynntils.models.items.items.game.RuneItem;
import com.wynntils.models.items.items.game.SimulatorItem;
import com.wynntils.models.items.items.game.TomeItem;
import com.wynntils.models.items.properties.GearTierItemProperty;
import com.wynntils.models.stats.type.ShinyStat;
import com.wynnventory.core.ModInfo;
import com.wynnventory.model.item.Icon;
import com.wynnventory.util.IconManager;
import com.wynnventory.util.ItemStackUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1799;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LootpoolItem {
    private String itemType;
    private int amount;
    private String name;
    private String rarity;
    private ShinyStat shinyStat;
    @JsonAlias(value={"subtype"})
    private String type;
    private Icon icon;
    protected static final List<Class<? extends WynnItem>> LOOT_CLASSES = Arrays.asList(GearItem.class, InsulatorItem.class, SimulatorItem.class, EmeraldItem.class, MiscItem.class, RuneItem.class, DungeonKeyItem.class, AspectItem.class, AmplifierItem.class, PowderItem.class, GearBoxItem.class, TomeItem.class);

    public LootpoolItem() {
    }

    public LootpoolItem(String itemType, int amount, String name, String rarity, ShinyStat shinyStat, String type) {
        this.itemType = itemType;
        this.amount = amount;
        this.name = name;
        this.rarity = rarity;
        this.shinyStat = shinyStat;
        this.type = type;
        this.icon = IconManager.getIcon(name);
    }

    public LootpoolItem(WynnItem wynnItem) {
        this.itemType = wynnItem.getClass().getSimpleName();
        this.name = ItemStackUtils.getWynntilsOriginalNameAsString(wynnItem);
        this.amount = ((class_1799)wynnItem.getData().get("itemstack")).method_7947();
        this.name = this.name.replace("Unidentified ", "");
        this.type = wynnItem.getClass().getSimpleName().replace("Item", "");
        this.rarity = "Common";
        this.icon = IconManager.getIcon(this.name);
        if (wynnItem instanceof GearItem) {
            GearItem gearItem = (GearItem)wynnItem;
            GearInstance gearInstance = new GearModel().parseInstance(gearItem.getItemInfo(), (class_1799)wynnItem.getData().get("itemstack"));
            gearInstance.shinyStat().ifPresent(stat -> {
                this.shinyStat = stat;
            });
            this.name = gearItem.getName();
            this.icon = IconManager.getIcon(this.name);
            this.rarity = gearItem.getGearTier().getName();
            this.type = gearItem.getGearType().name();
        } else if (wynnItem instanceof SimulatorItem || wynnItem instanceof InsulatorItem) {
            this.rarity = ((GearTierItemProperty)wynnItem).getGearTier().getName();
        } else if (wynnItem instanceof TomeItem) {
            TomeItem tomeItem = (TomeItem)wynnItem;
            this.name = tomeItem.getName();
            this.rarity = tomeItem.getGearTier().getName();
            this.type = tomeItem.getItemInfo().type().name();
        } else if (wynnItem instanceof AspectItem) {
            AspectItem aspectItem = (AspectItem)wynnItem;
            this.rarity = aspectItem.getGearTier().getName();
            String classReq = aspectItem.getRequiredClass().getName();
            if (classReq != null && !classReq.isEmpty()) {
                this.type = classReq + this.type;
            }
        } else if (wynnItem instanceof EmeraldItem) {
            EmeraldItem emeraldItem = (EmeraldItem)wynnItem;
            this.type = emeraldItem.getUnit().name();
        } else if (wynnItem instanceof RuneItem) {
            RuneItem runeItem = (RuneItem)wynnItem;
            this.type = runeItem.getType().name();
        } else if (wynnItem instanceof PowderItem) {
            PowderItem powderItem = (PowderItem)wynnItem;
            this.name = ItemStackUtils.getPowderName(powderItem);
            this.type = ItemStackUtils.getPowderType(powderItem);
        } else if (wynnItem instanceof AmplifierItem) {
            AmplifierItem amplifierItem = (AmplifierItem)wynnItem;
            this.rarity = amplifierItem.getGearTier().getName();
            this.type = ItemStackUtils.getAmplifierType(amplifierItem);
        }
    }

    public static List<LootpoolItem> createLootpoolItemsFromWynnItem(List<WynnItem> wynnItems) {
        ArrayList<LootpoolItem> lootpoolItems = new ArrayList<LootpoolItem>();
        for (WynnItem wynnItem : wynnItems) {
            lootpoolItems.addAll(LootpoolItem.createLootpoolItemFromWynnItem(wynnItem));
        }
        return lootpoolItems;
    }

    public static List<LootpoolItem> createLootpoolItemsFromItemStack(List<class_1799> items) {
        ArrayList<WynnItem> wynnItems = new ArrayList<WynnItem>();
        items.forEach(item -> Models.Item.getWynnItem(item).ifPresent(wynnItems::add));
        return LootpoolItem.createLootpoolItemsFromWynnItem(wynnItems);
    }

    public static List<LootpoolItem> createLootpoolItemFromWynnItem(WynnItem wynnItem) {
        GearItem gearItem;
        GearInfo itemInfo;
        ArrayList<LootpoolItem> lootpoolItems = new ArrayList<LootpoolItem>();
        if (wynnItem instanceof GearBoxItem) {
            GearBoxItem gearBoxItem = (GearBoxItem)wynnItem;
            List possibleGear = Models.Gear.getPossibleGears(gearBoxItem);
            for (GearInfo gearInfo : possibleGear) {
                if (gearInfo.requirements().quest().isPresent() || gearInfo.metaInfo().restrictions() == GearRestrictions.UNTRADABLE || gearInfo.metaInfo().restrictions() == GearRestrictions.QUEST_ITEM) continue;
                String name = gearInfo.name();
                String rarity = gearInfo.tier().name();
                String type = gearInfo.type().name();
                lootpoolItems.add(new LootpoolItem("GearItem", 1, name, rarity, null, type));
            }
            return lootpoolItems;
        }
        if (wynnItem instanceof GearItem && ((itemInfo = (gearItem = (GearItem)wynnItem).getItemInfo()).requirements().quest().isPresent() || itemInfo.metaInfo().restrictions() == GearRestrictions.UNTRADABLE || itemInfo.metaInfo().restrictions() == GearRestrictions.QUEST_ITEM)) {
            return lootpoolItems;
        }
        if (LOOT_CLASSES.contains(wynnItem.getClass())) {
            lootpoolItems.add(new LootpoolItem(wynnItem));
        } else {
            ModInfo.logDebug("Unknown class: " + String.valueOf(wynnItem.getClass()));
        }
        return lootpoolItems;
    }

    public static List<LootpoolItem> createLootpoolItemFromItemStack(class_1799 item) {
        Optional wynnItem = Models.Item.getWynnItem(item);
        return wynnItem.map(LootpoolItem::createLootpoolItemFromWynnItem).orElseGet(ArrayList::new);
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRarity() {
        return this.rarity;
    }

    public void setRarity(String rarity) {
        this.rarity = rarity;
    }

    public void setShinyStat(ShinyStat shinyStat) {
        this.shinyStat = shinyStat;
    }

    public Optional<ShinyStat> getShinyStat() {
        return Optional.ofNullable(this.shinyStat);
    }

    public boolean isShiny() {
        return this.shinyStat != null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LootpoolItem that = (LootpoolItem)o;
        return this.amount == that.amount && Objects.equals(this.itemType, that.itemType) && Objects.equals(this.name, that.name) && Objects.equals(this.rarity, that.rarity) && Objects.equals(this.shinyStat, that.shinyStat) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.itemType, this.amount, this.name, this.rarity, this.shinyStat, this.type);
    }

    @JsonIgnore
    public class_124 getRarityColor() {
        return ItemStackUtils.getRarityColor(this.rarity);
    }
}

