/*
 * Decompiled with CFR 0.152.
 */
package com.wynnventory.model.item.simplified;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.wynntils.models.gear.GearModel;
import com.wynntils.models.gear.type.GearInstance;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.models.stats.type.ShinyStat;
import com.wynntils.models.stats.type.StatActualValue;
import com.wynntils.models.stats.type.StatPossibleValues;
import com.wynnventory.model.item.simplified.SimplifiedItem;
import com.wynnventory.model.stat.ActualStatWithPercentage;
import com.wynnventory.util.IconManager;
import com.wynnventory.util.ItemStackUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1799;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SimplifiedGearItem
extends SimplifiedItem {
    private final boolean unidentified;
    private final int rerollCount;
    private final Optional<ShinyStat> shinyStat;
    private final float overallRollPercentage;
    private final List<ActualStatWithPercentage> actualStatsWithPercentage = new ArrayList<ActualStatWithPercentage>();

    public SimplifiedGearItem(GearItem item) {
        super(item.getName(), item.getGearTier().getName(), "GearItem", item.getGearType().name(), IconManager.getIcon(item.getName()));
        this.unidentified = item.isUnidentified();
        this.rerollCount = item.getRerollCount();
        this.overallRollPercentage = item.getOverallPercentage();
        GearInstance gearInstance = new GearModel().parseInstance(item.getItemInfo(), (class_1799)item.getData().get("itemstack"));
        this.shinyStat = Optional.of(gearInstance.shinyStat()).orElse(Optional.empty());
        List actualValues = item.getIdentifications();
        List possibleValues = item.getPossibleValues();
        for (StatActualValue actual : actualValues) {
            StatPossibleValues possibleValue = possibleValues.stream().filter(p -> p.statType().getKey().equals(actual.statType().getKey())).findFirst().orElse(null);
            this.actualStatsWithPercentage.add(new ActualStatWithPercentage(actual, possibleValue));
        }
    }

    public boolean isUnidentified() {
        return this.unidentified;
    }

    public Optional<ShinyStat> getShinyStat() {
        return this.shinyStat;
    }

    public float getOverallRollPercentage() {
        return this.overallRollPercentage;
    }

    public String getOverallRollPercentageColor() {
        return ItemStackUtils.getRollPercentColor(Float.valueOf(this.getOverallRollPercentage()));
    }

    public int getRerollCount() {
        return this.rerollCount;
    }

    public List<ActualStatWithPercentage> getActualStatsWithPercentage() {
        return this.actualStatsWithPercentage;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimplifiedGearItem) {
            SimplifiedGearItem other = (SimplifiedGearItem)o;
            return this.unidentified == other.unidentified && Objects.equals(this.name, other.name) && Objects.equals(this.rarity, other.rarity) && Objects.equals(this.shinyStat, other.shinyStat) && Objects.equals(this.rerollCount, other.rerollCount) && Objects.equals(this.actualStatsWithPercentage, other.actualStatsWithPercentage) && Objects.equals(this.itemType, other.itemType) && Objects.equals(this.type, other.type);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.rarity, this.unidentified, this.rerollCount, this.shinyStat, this.actualStatsWithPercentage, this.itemType, this.type);
    }
}

