/*
 * Decompiled with CFR 0.152.
 */
package com.wynnventory.model.item.simplified;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.items.game.DungeonKeyItem;
import com.wynntils.models.items.items.game.InsulatorItem;
import com.wynntils.models.items.items.game.RuneItem;
import com.wynntils.models.items.items.game.SimulatorItem;
import com.wynnventory.model.item.Icon;
import com.wynnventory.util.IconManager;
import com.wynnventory.util.ItemStackUtils;
import com.wynnventory.util.StringUtils;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SimplifiedItem {
    protected String name;
    protected String rarity;
    protected String itemType;
    protected String type;
    protected Icon icon;

    public SimplifiedItem() {
    }

    public SimplifiedItem(String name, String rarity, String itemType, String type) {
        this(name, rarity, itemType, type, null);
    }

    public SimplifiedItem(String name, String rarity, String itemType, String type, Icon icon) {
        this.name = name;
        this.rarity = rarity;
        this.itemType = itemType;
        this.type = type;
        this.icon = icon;
    }

    public SimplifiedItem(SimulatorItem simulatorItem) {
        this.name = ItemStackUtils.getWynntilsOriginalNameAsString((WynnItem)simulatorItem);
        this.rarity = simulatorItem.getGearTier().getName();
        this.itemType = "SimulatorItem";
        this.type = StringUtils.toCamelCase(this.name);
        this.icon = IconManager.getIcon(this.name);
    }

    public SimplifiedItem(InsulatorItem insulatorItem) {
        this.name = ItemStackUtils.getWynntilsOriginalNameAsString((WynnItem)insulatorItem);
        this.rarity = insulatorItem.getGearTier().getName();
        this.itemType = "InsulatorItem";
        this.type = StringUtils.toCamelCase(this.name);
        this.icon = IconManager.getIcon(this.name);
    }

    public SimplifiedItem(RuneItem runeItem) {
        this.name = ItemStackUtils.getWynntilsOriginalNameAsString((WynnItem)runeItem);
        this.rarity = "Normal";
        this.itemType = "RuneItem";
        this.type = StringUtils.toCamelCase(this.name);
        this.icon = IconManager.getIcon(this.name);
    }

    public SimplifiedItem(DungeonKeyItem dungeonKeyItem) {
        this.name = ItemStackUtils.getWynntilsOriginalNameAsString((WynnItem)dungeonKeyItem);
        this.rarity = "Normal";
        this.itemType = "DungeonKeyItem";
        this.type = StringUtils.toCamelCase(this.name);
        this.icon = IconManager.getIcon(this.name);
    }

    public String getName() {
        return this.name;
    }

    public String getRarity() {
        return this.rarity;
    }

    @JsonProperty(value="item_type")
    public String getItemType() {
        return this.itemType;
    }

    public String getType() {
        return this.type;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRarity(String rarity) {
        this.rarity = rarity;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimplifiedItem) {
            SimplifiedItem other = (SimplifiedItem)o;
            return Objects.equals(this.name, other.name) && Objects.equals(this.rarity, other.rarity) && Objects.equals(this.itemType, other.itemType) && Objects.equals(this.type, other.type);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.rarity, this.itemType, this.type);
    }
}

