/*
 * Decompiled with CFR 0.152.
 */
package com.wynnventory.model.item.simplified;

import com.wynntils.models.items.items.game.AmplifierItem;
import com.wynntils.models.items.items.game.EmeraldPouchItem;
import com.wynntils.models.items.items.game.HorseItem;
import com.wynntils.models.items.items.game.IngredientItem;
import com.wynntils.models.items.items.game.MaterialItem;
import com.wynntils.models.items.items.game.PowderItem;
import com.wynnventory.model.item.simplified.SimplifiedItem;
import com.wynnventory.util.IconManager;
import com.wynnventory.util.ItemStackUtils;
import com.wynnventory.util.StringUtils;
import java.util.Objects;

public class SimplifiedTieredItem
extends SimplifiedItem {
    protected final int tier;

    public SimplifiedTieredItem(IngredientItem ingredientItem) {
        super(ingredientItem.getName(), null, "IngredientItem", ingredientItem.getIngredientInfo().professions().toString(), IconManager.getIcon(ingredientItem.getName()));
        this.tier = ingredientItem.getQualityTier();
    }

    public SimplifiedTieredItem(MaterialItem materialItem) {
        this.name = ItemStackUtils.getMaterialName(materialItem);
        this.rarity = null;
        this.itemType = "MaterialItem";
        this.type = materialItem.getProfessionTypes().toString();
        this.tier = materialItem.getQualityTier();
        this.icon = IconManager.getIcon(this.name, this.tier);
    }

    public SimplifiedTieredItem(PowderItem powderItem) {
        this.name = ItemStackUtils.getPowderName(powderItem);
        this.rarity = null;
        this.itemType = "PowderItem";
        this.type = powderItem.getPowderProfile().element().getName() + "Powder";
        this.tier = powderItem.getTier();
        this.icon = IconManager.getIcon(this.name, this.tier);
    }

    public SimplifiedTieredItem(AmplifierItem amplifierItem) {
        this.name = ItemStackUtils.getAmplifierName(amplifierItem);
        this.rarity = amplifierItem.getGearTier().getName();
        this.itemType = "AmplifierItem";
        this.type = StringUtils.toCamelCase(this.name);
        this.tier = amplifierItem.getTier();
        this.icon = IconManager.getIcon(this.name, this.tier);
    }

    public SimplifiedTieredItem(HorseItem horseItem) {
        this.name = ItemStackUtils.getHorseName(horseItem);
        this.rarity = "Normal";
        this.itemType = "HorseItem";
        this.type = StringUtils.toCamelCase(this.name);
        this.tier = horseItem.getTier().getNumeral();
        this.icon = IconManager.getIcon(this.name, this.tier);
    }

    public SimplifiedTieredItem(EmeraldPouchItem emeraldPouchItem) {
        this.name = "Emerald Pouch";
        this.rarity = "Normal";
        this.itemType = "EmeraldPouchItem";
        this.type = StringUtils.toCamelCase(this.name);
        this.tier = emeraldPouchItem.getTier();
        this.icon = IconManager.getIcon(this.name, this.tier);
    }

    public int getTier() {
        return this.tier;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimplifiedTieredItem) {
            SimplifiedTieredItem other = (SimplifiedTieredItem)o;
            return this.tier == other.getTier() && Objects.equals(this.name, other.name) && Objects.equals(this.itemType, other.itemType) && Objects.equals(this.type, other.type);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tier, this.name, this.itemType, this.type);
    }
}

