/*
 * Decompiled with CFR 0.152.
 */
package com.wynnventory.model.item.trademarket;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.wynntils.core.components.Models;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.items.game.AmplifierItem;
import com.wynntils.models.items.items.game.DungeonKeyItem;
import com.wynntils.models.items.items.game.EmeraldPouchItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.models.items.items.game.HorseItem;
import com.wynntils.models.items.items.game.IngredientItem;
import com.wynntils.models.items.items.game.InsulatorItem;
import com.wynntils.models.items.items.game.MaterialItem;
import com.wynntils.models.items.items.game.PowderItem;
import com.wynntils.models.items.items.game.RuneItem;
import com.wynntils.models.items.items.game.SimulatorItem;
import com.wynntils.models.trademarket.type.TradeMarketPriceInfo;
import com.wynnventory.model.item.CrowdSourcedData;
import com.wynnventory.model.item.simplified.SimplifiedGearItem;
import com.wynnventory.model.item.simplified.SimplifiedItem;
import com.wynnventory.model.item.simplified.SimplifiedTieredItem;
import com.wynnventory.util.TradeMarketPriceParser;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1799;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TradeMarketItem
extends CrowdSourcedData {
    private final SimplifiedItem item;
    private final int listingPrice;
    private final int amount;

    protected TradeMarketItem(SimplifiedItem item, int listingPrice, int amount) {
        this.item = item;
        this.listingPrice = listingPrice;
        this.amount = amount;
    }

    public static TradeMarketItem from(class_1799 itemStack) {
        WynnItem wynnItem;
        Optional wynnItemOptional = Models.Item.getWynnItem(itemStack);
        if (wynnItemOptional.isEmpty()) {
            return null;
        }
        TradeMarketPriceInfo priceInfo = TradeMarketPriceParser.calculateItemPriceInfo(itemStack);
        WynnItem wynnItem2 = wynnItem = (WynnItem)wynnItemOptional.get();
        Objects.requireNonNull(wynnItem2);
        WynnItem wynnItem3 = wynnItem2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GearItem.class, IngredientItem.class, MaterialItem.class, PowderItem.class, AmplifierItem.class, InsulatorItem.class, SimulatorItem.class, HorseItem.class, EmeraldPouchItem.class, RuneItem.class, DungeonKeyItem.class}, (Object)wynnItem3, n)) {
            case 0 -> {
                GearItem gearItem = (GearItem)wynnItem3;
                yield new TradeMarketItem(new SimplifiedGearItem(gearItem), priceInfo.price(), priceInfo.amount());
            }
            case 1 -> {
                IngredientItem ingredientItem = (IngredientItem)wynnItem3;
                yield new TradeMarketItem(new SimplifiedTieredItem(ingredientItem), priceInfo.price(), priceInfo.amount());
            }
            case 2 -> {
                MaterialItem materialItem = (MaterialItem)wynnItem3;
                yield new TradeMarketItem(new SimplifiedTieredItem(materialItem), priceInfo.price(), priceInfo.amount());
            }
            case 3 -> {
                PowderItem powderItem = (PowderItem)wynnItem3;
                yield new TradeMarketItem(new SimplifiedTieredItem(powderItem), priceInfo.price(), priceInfo.amount());
            }
            case 4 -> {
                AmplifierItem amplifierItem = (AmplifierItem)wynnItem3;
                yield new TradeMarketItem(new SimplifiedTieredItem(amplifierItem), priceInfo.price(), priceInfo.amount());
            }
            case 5 -> {
                InsulatorItem insulatorItem = (InsulatorItem)wynnItem3;
                yield new TradeMarketItem(new SimplifiedItem(insulatorItem), priceInfo.price(), priceInfo.amount());
            }
            case 6 -> {
                SimulatorItem simulatorItem = (SimulatorItem)wynnItem3;
                yield new TradeMarketItem(new SimplifiedItem(simulatorItem), priceInfo.price(), priceInfo.amount());
            }
            case 7 -> {
                HorseItem horseItem = (HorseItem)wynnItem3;
                yield new TradeMarketItem(new SimplifiedTieredItem(horseItem), priceInfo.price(), priceInfo.amount());
            }
            case 8 -> {
                EmeraldPouchItem emeraldPouchItem = (EmeraldPouchItem)wynnItem3;
                yield new TradeMarketItem(new SimplifiedTieredItem(emeraldPouchItem), priceInfo.price(), priceInfo.amount());
            }
            case 9 -> {
                RuneItem runeItem = (RuneItem)wynnItem3;
                yield new TradeMarketItem(new SimplifiedItem(runeItem), priceInfo.price(), priceInfo.amount());
            }
            case 10 -> {
                DungeonKeyItem dungeonKeyItem = (DungeonKeyItem)wynnItem3;
                yield new TradeMarketItem(new SimplifiedItem(dungeonKeyItem), priceInfo.price(), priceInfo.amount());
            }
            default -> null;
        };
    }

    public int getListingPrice() {
        return this.listingPrice;
    }

    public int getAmount() {
        return this.amount;
    }

    public SimplifiedItem getItem() {
        return this.item;
    }

    @JsonProperty(value="hash_code")
    public int getHashCode() {
        return this.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TradeMarketItem) {
            TradeMarketItem other = (TradeMarketItem)o;
            return this.listingPrice == other.listingPrice && this.amount == other.amount && Objects.equals(this.item, other.item);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.item, this.listingPrice, this.amount);
    }
}

