/*
 * Decompiled with CFR 0.152.
 */
package com.wynnventory.model.item.trademarket;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.wynnventory.model.item.trademarket.TradeMarketItemPriceInfo;
import java.time.Instant;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TradeMarketItemPriceHolder {
    private TradeMarketItemPriceInfo priceInfo;
    private final String itemName;
    private final Instant timestamp;

    public TradeMarketItemPriceHolder(TradeMarketItemPriceInfo priceInfo, String itemName) {
        this.priceInfo = priceInfo;
        this.itemName = itemName;
        this.timestamp = Instant.now();
    }

    public void setPriceInfo(TradeMarketItemPriceInfo priceInfo) {
        this.priceInfo = priceInfo;
    }

    public String getItemName() {
        return this.itemName;
    }

    public TradeMarketItemPriceInfo getPriceInfo() {
        return this.priceInfo;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public boolean isPriceExpired(long minutes) {
        Instant now = Instant.now();
        return now.isAfter(this.timestamp.plusSeconds(minutes * 60L));
    }
}

