/*
 * Decompiled with CFR 0.152.
 */
package com.wynnventory.model.stat;

import com.wynntils.models.stats.StatCalculator;
import com.wynntils.models.stats.type.StatActualValue;
import com.wynntils.models.stats.type.StatPossibleValues;
import com.wynntils.utils.type.RangedValue;
import com.wynnventory.util.ItemStackUtils;
import java.util.Objects;

public class ActualStatWithPercentage {
    private final StatActualValue statActualValue;
    private final StatPossibleValues possibleValues;

    public ActualStatWithPercentage(StatActualValue statActualValue, StatPossibleValues possibleValues) {
        this.statActualValue = statActualValue;
        this.possibleValues = possibleValues;
    }

    public String getDisplayName() {
        return this.statActualValue.statType().getDisplayName();
    }

    public String getApiName() {
        return this.statActualValue.statType().getApiName();
    }

    public int getStatRoll() {
        return this.statActualValue.value();
    }

    public RangedValue getStatRange() {
        if (this.possibleValues == null) {
            return null;
        }
        return this.possibleValues.range();
    }

    public String getUnit() {
        return this.statActualValue.statType().getUnit().name();
    }

    public int getStars() {
        return this.statActualValue.stars();
    }

    public RangedValue getInternalRoll() {
        return this.statActualValue.internalRoll();
    }

    public float getRollPercentage() {
        return StatCalculator.getPercentage((StatActualValue)this.statActualValue, (StatPossibleValues)this.possibleValues);
    }

    public String getRollPercentageColor() {
        return ItemStackUtils.getRollPercentColor(Float.valueOf(this.getRollPercentage()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ActualStatWithPercentage) {
            ActualStatWithPercentage other = (ActualStatWithPercentage)o;
            return Objects.equals(this.statActualValue, other.statActualValue);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.statActualValue, Float.valueOf(this.getRollPercentage()));
    }

    public String toString() {
        return "statName=" + this.statActualValue.statType().getKey() + ", actualValue=" + this.statActualValue.value() + ", rollPercent=" + this.getRollPercentage() + ", minRange=" + this.possibleValues.range().low() + ", maxRange=" + this.possibleValues.range().high();
    }
}

