/*
 * Decompiled with CFR 0.152.
 */
package com.wynnventory.ui;

import com.wynntils.core.components.Models;
import com.wynntils.screens.guides.GuideItemStack;
import com.wynntils.screens.guides.aspect.GuideAspectItemStack;
import com.wynntils.screens.guides.gear.GuideGearItemStack;
import com.wynntils.screens.guides.powder.GuidePowderItemStack;
import com.wynntils.screens.guides.tome.GuideTomeItemStack;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynnventory.config.ConfigManager;
import com.wynnventory.enums.RegionType;
import com.wynnventory.input.KeyBindingManager;
import com.wynnventory.model.item.Lootpool;
import com.wynnventory.model.item.LootpoolItem;
import com.wynnventory.ui.ReloadButton;
import com.wynnventory.ui.SettingsButton;
import com.wynnventory.ui.WynnventoryItemButton;
import com.wynnventory.ui.layout.LayoutHelper;
import com.wynnventory.util.ItemStackUtils;
import com.wynnventory.util.LootpoolManager;
import com.wynnventory.util.PriceTooltipHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.apache.commons.lang3.function.BooleanConsumer;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class LootpoolScreen
extends class_437 {
    private final Map<String, List<GuideItemStack>> stacksByName = new HashMap<String, List<GuideItemStack>>();
    private final List<WynnventoryItemButton<GuideItemStack>> elementButtons = new ArrayList<WynnventoryItemButton<GuideItemStack>>();
    private final List<class_4185> filterToggles = new ArrayList<class_4185>();
    private class_4185 lootrunButton;
    private class_4185 raidButton;
    private ReloadButton reloadButton;
    private SettingsButton settingsButton;
    private class_342 searchBar;
    private LayoutHelper layoutHelper;
    private RegionType currentPool = RegionType.LOOTRUN;
    private List<Lootpool> currentPools;
    private String currentQuery = "";

    public LootpoolScreen(class_2561 title) {
        super(title);
        this.loadAllItems();
    }

    protected void method_25426() {
        super.method_25426();
        this.layoutHelper = new LayoutHelper(this.field_22789, this.field_22790);
        this.initTabs();
        this.initSettingsButton();
        this.initReloadButton();
        this.initSearchBar();
        this.initFilters();
        this.updateScreen();
    }

    private void initTabs() {
        int width = 80;
        int height = 20;
        int spacing = 10;
        int[] tabPosition = this.layoutHelper.calculateTabPosition(width, spacing);
        int x = tabPosition[0];
        int y = tabPosition[1];
        this.lootrunButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Lootruns"), b -> this.switchTo(RegionType.LOOTRUN)).method_46434(x, y, width, height).method_46431();
        this.raidButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Raids"), b -> this.switchTo(RegionType.RAID)).method_46434(x + width + spacing, y, width, height).method_46431();
        this.method_37063((class_364)this.lootrunButton);
        this.method_37063((class_364)this.raidButton);
    }

    private void initSearchBar() {
        int width = 175;
        int height = 20;
        int[] position = this.layoutHelper.calculateSearchBarPosition(width, height, this.settingsButton.method_25368(), this.reloadButton.method_25368(), this.raidButton.method_46427());
        int x = position[0];
        int y = position[1];
        this.searchBar = new class_342(this.field_22793, x, y, width, height, (class_2561)class_2561.method_43470((String)""));
        this.searchBar.method_1880(50);
        this.searchBar.method_1863(text -> {
            this.currentQuery = text.trim().toLowerCase();
            this.updateScreen();
        });
        this.method_37063((class_364)this.searchBar);
    }

    private void initReloadButton() {
        int buttonSize = 16;
        int[] position = this.layoutHelper.calculateReloadButtonPosition(buttonSize, this.settingsButton.method_25368(), this.raidButton.method_25364());
        int x = position[0];
        int y = position[1];
        this.reloadButton = new ReloadButton(x, y, () -> {
            LootpoolManager.reloadAllPools();
            this.currentPools = null;
            this.updateScreen();
        });
        this.method_37063((class_364)this.reloadButton);
    }

    private void initSettingsButton() {
        int buttonSize = 16;
        int[] position = this.layoutHelper.calculateSettingsButtonPosition(buttonSize, this.raidButton.method_25364());
        int x = position[0];
        int y = position[1];
        this.settingsButton = new SettingsButton(x, y, () -> class_310.method_1551().method_1507((class_437)AutoConfig.getConfigScreen(ConfigManager.class, (class_437)this).get()));
        this.method_37063((class_364)this.settingsButton);
    }

    private void initFilters() {
        this.filterToggles.clear();
        int width = 80;
        int height = 20;
        int spacing = 5;
        int[] position = this.layoutHelper.calculateFilterTogglePosition(width, height, spacing, this.reloadButton.method_46427(), this.reloadButton.method_25364());
        int startX = position[0];
        int startY = position[1];
        int verticalStep = position[2];
        List<FilterToggle> filters = LootpoolScreen.getFilterToggles();
        for (int i = 0; i < filters.size(); ++i) {
            int y = startY + i * verticalStep;
            FilterToggle toggle = filters.get(i);
            class_4185 button = this.createToggleButton(toggle.label, toggle.getter, toggle.setter, startX, y, width, height);
            this.filterToggles.add(button);
            this.method_37063((class_364)button);
        }
    }

    @NotNull
    private static List<FilterToggle> getFilterToggles() {
        ConfigManager.RarityConfig cfg = ConfigManager.getInstance().getRarityConfig();
        return List.of(new FilterToggle("Mythics", cfg::getShowMythic, cfg::setShowMythic), new FilterToggle("Fableds", cfg::getShowFabled, cfg::setShowFabled), new FilterToggle("Legendaries", cfg::getShowLegendary, cfg::setShowLegendary), new FilterToggle("Uniques", cfg::getShowUnique, cfg::setShowUnique), new FilterToggle("Rares", cfg::getShowRare, cfg::setShowRare), new FilterToggle("Common", cfg::getShowCommon, cfg::setShowCommon), new FilterToggle("Set", cfg::getShowSet, cfg::setShowSet), new FilterToggle("Show Unusable", cfg::getShowUnusable, cfg::setShowUnusable));
    }

    private class_4185 createToggleButton(String label, BooleanSupplier getter, BooleanConsumer setter, int x, int y, int width, int height) {
        return class_4185.method_46430((class_2561)class_2561.method_43470((String)(label + ": " + (getter.getAsBoolean() ? "On" : "Off"))), b -> {
            boolean newValue = !getter.getAsBoolean();
            setter.accept(newValue);
            b.method_25355((class_2561)class_2561.method_43470((String)(label + ": " + (newValue ? "On" : "Off"))));
            AutoConfig.getConfigHolder(ConfigManager.class).save();
            this.currentPools = null;
            this.updateScreen();
        }).method_46434(x, y, width, height).method_46431();
    }

    private void switchTo(RegionType type) {
        this.currentPool = type;
        this.currentPools = null;
        this.updateScreen();
    }

    protected void updateScreen() {
        this.method_37067();
        this.elementButtons.clear();
        this.method_37063((class_364)this.searchBar);
        this.method_37063((class_364)this.reloadButton);
        this.method_37063((class_364)this.settingsButton);
        this.method_37063((class_364)this.lootrunButton);
        this.method_37063((class_364)this.raidButton);
        this.filterToggles.forEach(x$0 -> {
            class_4185 cfr_ignored_0 = (class_4185)this.method_37063((class_364)x$0);
        });
        this.updateTabButtonStyles();
        this.currentPools = this.getCurrentPools();
        this.currentQuery = this.searchBar.method_1882().trim().toLowerCase();
        this.layoutHelper.calculateItemLayout(this.currentPools, this.searchBar, this.filterToggles, this.currentQuery);
        for (int i = 0; i < this.currentPools.size(); ++i) {
            int[] columnPosition = this.layoutHelper.calculateColumnPosition(i);
            int colX = columnPosition[0];
            int colY = columnPosition[1];
            this.buildColumn(this.currentPools.get(i), colX, this.currentQuery);
        }
    }

    private void updateTabButtonStyles() {
        this.lootrunButton.field_22763 = this.currentPool != RegionType.LOOTRUN;
        this.raidButton.field_22763 = this.currentPool != RegionType.RAID;
    }

    private void buildColumn(Lootpool pool, int startX, String query) {
        ConfigManager config = ConfigManager.getInstance();
        int rendered = 0;
        List<LootpoolItem> items = this.currentPool == RegionType.LOOTRUN ? pool.getLootrunSortedItems() : pool.getRaidSortedItems();
        for (LootpoolItem item : items) {
            List<GuideItemStack> stacks;
            String name = item.getName();
            if (!name.toLowerCase().contains(query) || (stacks = this.stacksByName.get(name)) == null || stacks.isEmpty()) continue;
            for (GuideItemStack stack : stacks) {
                if (this.layoutHelper.matchesRarityFilters(stack, item.getRarity(), config)) continue;
                int[] itemPosition = this.layoutHelper.calculateItemPosition(startX, rendered);
                int x = itemPosition[0];
                int y = itemPosition[1];
                int buttonSize = itemPosition[2];
                WynnventoryItemButton<GuideItemStack> button = new WynnventoryItemButton<GuideItemStack>(x, y, buttonSize, buttonSize, stack, item.isShiny());
                this.elementButtons.add(button);
                this.method_37063((class_364)button);
                ++rendered;
            }
        }
    }

    private List<Lootpool> getCurrentPools() {
        if (this.currentPools != null) {
            return this.currentPools;
        }
        return this.currentPool == RegionType.LOOTRUN ? LootpoolManager.getLootrunPools() : LootpoolManager.getRaidPools();
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float partialTick) {
        this.method_25420(g, mouseX, mouseY, partialTick);
        super.method_25394(g, mouseX, mouseY, partialTick);
        if (this.currentPools == null) {
            this.currentPools = this.getCurrentPools();
            this.currentQuery = this.searchBar.method_1882().trim().toLowerCase();
            this.layoutHelper.calculateItemLayout(this.currentPools, this.searchBar, this.filterToggles, this.currentQuery);
        }
        for (int i = 0; i < this.currentPools.size(); ++i) {
            int[] titlePosition = this.layoutHelper.calculateColumnTitlePosition(i);
            int textX = titlePosition[0];
            int titleY = titlePosition[1];
            String regionName = this.currentPools.get(i).getRegion();
            g.method_25300(this.field_22793, regionName, textX, titleY, -1);
        }
        for (WynnventoryItemButton<GuideItemStack> button : this.elementButtons) {
            if (!button.method_49606()) continue;
            g.method_51446(FontRenderer.getInstance().getFont(), (class_1799)button.getItemStack(), mouseX, mouseY);
            PriceTooltipHelper.renderPriceInfoTooltip(g, mouseX, mouseY, (class_1799)button.getItemStack(), ItemStackUtils.getTooltips((class_1799)button.getItemStack()), ConfigManager.getInstance().isAnchorTooltips());
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.searchBar.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (KeyBindingManager.OPEN_POOLS.method_1417(keyCode, scanCode) && !this.searchBar.method_25370()) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        return this.searchBar.method_25400(chr, modifiers) || super.method_25400(chr, modifiers);
    }

    private void loadAllItems() {
        this.addStacks(Models.Gear.getAllGearInfos().map(GuideGearItemStack::new).toList(), s -> s.getGearInfo().name());
        this.addStacks(Models.Rewards.getAllTomeInfos().map(GuideTomeItemStack::new).toList(), s -> s.getTomeInfo().name());
        this.addStacks(Models.Element.getAllPowderTierInfo().stream().map(GuidePowderItemStack::new).toList(), s -> s.getElement().getName() + " Powder " + MathUtils.toRoman((int)s.getTier()));
        this.addStacks(Models.Aspect.getAllAspectInfos().map(info -> new GuideAspectItemStack(info, 1)).toList(), s -> s.getAspectInfo().name());
    }

    private <T extends GuideItemStack> void addStacks(List<T> items, Function<T, String> nameMapper) {
        for (GuideItemStack item : items) {
            this.stacksByName.computeIfAbsent(nameMapper.apply(item), k -> new ArrayList()).add(item);
        }
    }

    private record FilterToggle(String label, BooleanSupplier getter, BooleanConsumer setter) {
    }
}

