/*
 * Decompiled with CFR 0.152.
 */
package com.wynnventory.ui;

import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.guides.GuideItemStack;
import com.wynntils.screens.guides.aspect.GuideAspectItemStack;
import com.wynntils.screens.guides.gear.GuideGearItemStack;
import com.wynntils.screens.guides.powder.GuidePowderItemStack;
import com.wynntils.screens.guides.tome.GuideTomeItemStack;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynnventory.ui.WynnventoryButton;
import com.wynnventory.util.HttpUtil;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class WynnventoryItemButton<T extends GuideItemStack>
extends WynnventoryButton {
    private static final int BASE_SIZE = 16;
    private final T itemStack;
    private final boolean shiny;

    public WynnventoryItemButton(int x, int y, int width, int height, T itemStack, boolean shiny) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.itemStack = itemStack;
        this.shiny = shiny;
        this.buildTooltip();
    }

    public void method_25306() {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!KeyboardUtils.isKeyDown((int)340) && !KeyboardUtils.isKeyDown((int)344)) {
            return false;
        }
        String name = StyledText.fromComponent((class_2561)this.itemStack.method_7964()).getStringWithoutFormatting();
        if (button == 1) {
            class_156.method_668().method_670("https://www.wynnventory.com/history/" + HttpUtil.encodeName(name));
            return true;
        }
        if (button == 0) {
            Services.Favorites.toggleFavorite(name);
            return true;
        }
        return false;
    }

    public void method_48579(class_332 g, int mouseX, int mouseY, float partialTick) {
        T t;
        class_4587 pose = g.method_51448();
        CustomColor color = this.getCustomColor();
        float scale = (float)this.method_25368() / 16.0f;
        pose.method_22903();
        pose.method_46416((float)(this.method_46426() - 1), (float)(this.method_46427() - 1), 0.0f);
        pose.method_22905(scale, scale, scale);
        RenderUtils.drawTexturedRectWithColor((class_4587)pose, (class_2960)Texture.HIGHLIGHT.resource(), (CustomColor)color.withAlpha(1.0f), (float)0.0f, (float)0.0f, (float)0.0f, (float)Math.round((float)(this.method_25368() + 2) / scale), (float)Math.round((float)(this.method_25364() + 2) / scale), (int)Texture.HIGHLIGHT.width(), (int)Texture.HIGHLIGHT.height());
        pose.method_22909();
        pose.method_22903();
        pose.method_46416((float)this.method_46426(), (float)this.method_46427(), 0.0f);
        pose.method_22905(scale, scale, scale);
        g.method_51427(this.itemStack, 0, 0);
        pose.method_22909();
        if (this.shiny) {
            this.renderText("\u2b21", pose, CustomColor.fromChatFormatting((class_124)class_124.field_1068), scale);
        }
        if ((t = this.itemStack) instanceof GuidePowderItemStack) {
            GuidePowderItemStack powder = (GuidePowderItemStack)t;
            this.renderText(MathUtils.toRoman((int)powder.getTier()), pose, color, scale);
        }
        if ((t = this.itemStack) instanceof GuideAspectItemStack) {
            GuideAspectItemStack aspect = (GuideAspectItemStack)t;
            this.renderText(aspect.getAspectInfo().classType().getName().substring(0, 2), pose, color, scale);
        }
        if (Services.Favorites.isFavorite(this.itemStack)) {
            RenderUtils.drawScalingTexturedRect((class_4587)pose, (class_2960)Texture.FAVORITE_ICON.resource(), (float)(this.method_46426() + 12), (float)(this.method_46427() - 4), (float)200.0f, (float)((float)this.method_25368() / 2.0f), (float)((float)this.method_25364() / 2.0f), (int)Texture.FAVORITE_ICON.width(), (int)Texture.FAVORITE_ICON.height());
        }
    }

    private void renderText(String text, class_4587 poseStack, CustomColor color, float scale) {
        poseStack.method_22903();
        poseStack.method_46416((float)this.method_46426(), (float)this.method_46427() - (float)this.method_25364() / 2.0f + 4.0f, 200.0f);
        poseStack.method_22905(scale, scale, scale);
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString((String)text), 0.0f, (float)this.method_25368(), 0.0f, 0.0f, color, HorizontalAlignment.LEFT, TextShadow.OUTLINE);
        poseStack.method_22909();
    }

    private void buildTooltip() {
        T t = this.itemStack;
        if (t instanceof GuideGearItemStack) {
            GuideGearItemStack gear = (GuideGearItemStack)t;
            gear.buildTooltip();
        } else {
            t = this.itemStack;
            if (t instanceof GuideTomeItemStack) {
                GuideTomeItemStack tome = (GuideTomeItemStack)t;
                tome.buildTooltip();
            }
        }
    }

    private CustomColor getCustomColor() {
        T t = this.itemStack;
        if (t instanceof GuideGearItemStack) {
            GuideGearItemStack gear = (GuideGearItemStack)t;
            return CustomColor.fromChatFormatting((class_124)gear.getGearInfo().tier().getChatFormatting());
        }
        t = this.itemStack;
        if (t instanceof GuideTomeItemStack) {
            GuideTomeItemStack tome = (GuideTomeItemStack)t;
            return CustomColor.fromChatFormatting((class_124)tome.getTomeInfo().tier().getChatFormatting());
        }
        t = this.itemStack;
        if (t instanceof GuideAspectItemStack) {
            GuideAspectItemStack aspect = (GuideAspectItemStack)t;
            return CustomColor.fromChatFormatting((class_124)aspect.getAspectInfo().gearTier().getChatFormatting());
        }
        return CustomColor.NONE;
    }

    public T getItemStack() {
        return this.itemStack;
    }
}

