/*
 * Decompiled with CFR 0.152.
 */
package com.wynnventory.ui.layout;

import com.wynntils.core.components.Models;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.screens.guides.GuideItemStack;
import com.wynntils.screens.guides.aspect.GuideAspectItemStack;
import com.wynntils.screens.guides.gear.GuideGearItemStack;
import com.wynnventory.config.ConfigManager;
import com.wynnventory.model.item.Lootpool;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_342;
import net.minecraft.class_4185;

public class LayoutHelper {
    private static final int ITEM_SIZE = 16;
    private static final int ITEMS_PER_ROW = 5;
    private static final int ITEM_PADDING = 8;
    private static final int COL_WIDTH = 120;
    private static final int PANEL_PADDING = 20;
    private static final int GAP_TITLE_TO_ITEMS = 24;
    private static final int GAP_FROM_RIGHT_BORDER = 10;
    private final int screenWidth;
    private final int screenHeight;
    private final int leftBoundary;
    private float overallScale;
    private int startX;
    private int lastTitlesY;
    private int itemsStartY;

    public LayoutHelper(int screenWidth, int screenHeight) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.leftBoundary = 20;
    }

    public int[] calculateTabPosition(int buttonWidth, int spacing) {
        int totalWidth = 2 * buttonWidth + spacing;
        int x = (this.screenWidth - totalWidth) / 2;
        int y = 10;
        return new int[]{x, y, totalWidth};
    }

    public int[] calculateSettingsButtonPosition(int buttonSize, int tabButtonHeight) {
        int x = this.screenWidth - buttonSize - 10;
        int y = 10 + tabButtonHeight / 2 - buttonSize / 2;
        return new int[]{x, y};
    }

    public int[] calculateReloadButtonPosition(int buttonSize, int settingsButtonWidth, int tabButtonHeight) {
        int gap = 5;
        int x = this.screenWidth - buttonSize - settingsButtonWidth - gap - 10;
        int y = 10 + tabButtonHeight / 2 - buttonSize / 2;
        return new int[]{x, y};
    }

    public int[] calculateSearchBarPosition(int width, int height, int settingsButtonWidth, int reloadButtonWidth, int tabButtonY) {
        int x = this.screenWidth - width - settingsButtonWidth - 5 - 10 - reloadButtonWidth - 5;
        int y = tabButtonY;
        return new int[]{x, y};
    }

    public int[] calculateFilterTogglePosition(int buttonWidth, int buttonHeight, int spacing, int reloadButtonY, int reloadButtonHeight) {
        int x = this.screenWidth - buttonWidth - 10;
        int y = reloadButtonY + reloadButtonHeight + 6;
        return new int[]{x, y, buttonHeight + spacing};
    }

    public void calculateItemLayout(List<Lootpool> pools, class_342 searchBar, List<class_4185> filterToggles, String query) {
        int rightBoundary = filterToggles.isEmpty() ? searchBar.method_46426() - 10 : filterToggles.getFirst().method_46426() - 10;
        int availableColumnsWidth = rightBoundary - this.leftBoundary;
        int totalWidth = pools.size() * 120 + (pools.size() - 1) * 20;
        float horizontalScale = 1.0f;
        if (totalWidth > availableColumnsWidth) {
            horizontalScale = (float)availableColumnsWidth / (float)totalWidth;
        }
        this.lastTitlesY = searchBar.method_46427() + searchBar.method_25364() + 10;
        int bottomMargin = 10;
        int availableVertical = this.screenHeight - this.lastTitlesY - bottomMargin;
        int maxColumnHeightUnscaled = this.calculateMaxColumnHeight(pools, query);
        float verticalScale = 1.0f;
        if (maxColumnHeightUnscaled > availableVertical && availableVertical > 0) {
            verticalScale = (float)availableVertical / (float)maxColumnHeightUnscaled;
        }
        this.overallScale = Math.min(horizontalScale, verticalScale);
        int scaledTotalWidth = Math.round((float)totalWidth * this.overallScale);
        this.startX = this.leftBoundary + (availableColumnsWidth - scaledTotalWidth) / 2;
        this.itemsStartY = this.lastTitlesY + 24;
    }

    private int calculateMaxColumnHeight(List<Lootpool> pools, String query) {
        int maxColumnHeightUnscaled = 0;
        for (Lootpool pool : pools) {
            int rendered = pool.getItems().size();
            if (rendered <= 0) continue;
            int rows = (rendered + 5 - 1) / 5;
            int colHeight = rows * 16 + (rows - 1) * 8;
            maxColumnHeightUnscaled = Math.max(maxColumnHeightUnscaled, colHeight);
        }
        return maxColumnHeightUnscaled;
    }

    public boolean matchesRarityFilters(GuideItemStack item, String rarity, ConfigManager config) {
        if (item == null) {
            return false;
        }
        ConfigManager.RarityConfig filter = config.getRarityConfig();
        boolean usable = filter.getShowUnusable() || this.isUsable(item);
        boolean showThisRarity = switch (rarity.toLowerCase()) {
            case "mythic" -> filter.getShowMythic();
            case "fabled" -> filter.getShowFabled();
            case "legendary" -> filter.getShowLegendary();
            case "unique" -> filter.getShowUnique();
            case "rare" -> filter.getShowRare();
            case "common" -> filter.getShowCommon();
            case "set" -> filter.getShowSet();
            default -> true;
        };
        return !showThisRarity || !usable;
    }

    private boolean isUsable(GuideItemStack item) {
        GuideItemStack guideItemStack = item;
        Objects.requireNonNull(guideItemStack);
        GuideItemStack guideItemStack2 = guideItemStack;
        int n = 0;
        Optional<ClassType> req = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GuideGearItemStack.class, GuideAspectItemStack.class}, (Object)guideItemStack2, n)) {
            case 0 -> {
                GuideGearItemStack gear = (GuideGearItemStack)guideItemStack2;
                yield gear.getGearInfo().requirements().classType();
            }
            case 1 -> {
                GuideAspectItemStack aspect = (GuideAspectItemStack)guideItemStack2;
                yield Optional.ofNullable(aspect.getAspectInfo().classType());
            }
            default -> Optional.empty();
        };
        return req.map(ct -> Models.Character.getClassType() == ct).orElse(true);
    }

    public int[] calculateColumnPosition(int columnIndex) {
        int x = this.startX + Math.round((float)(columnIndex * 140) * this.overallScale);
        return new int[]{x, this.itemsStartY};
    }

    public int[] calculateItemPosition(int columnX, int itemIndex) {
        int x = columnX + Math.round((float)(itemIndex % 5 * 24) * this.overallScale);
        int y = this.itemsStartY + Math.round((float)(itemIndex / 5 * 24) * this.overallScale);
        int size = Math.round(16.0f * this.overallScale);
        return new int[]{x, y, size};
    }

    public int[] calculateColumnTitlePosition(int columnIndex) {
        int x = this.startX + Math.round((float)(columnIndex * 140) * this.overallScale);
        int textX = x + Math.round(56.0f * this.overallScale);
        return new int[]{textX, this.lastTitlesY};
    }
}

