/*
 * Decompiled with CFR 0.152.
 */
package com.wynnventory.util;

import com.wynntils.utils.mc.McUtils;
import com.wynnventory.enums.ClassIcon;
import com.wynnventory.model.item.Lootpool;
import com.wynnventory.model.item.LootpoolItem;
import com.wynnventory.util.ItemStackUtils;
import com.wynnventory.util.PriceTooltipHelper;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public final class AspectTooltipHelper {
    private static final class_124 MYTHIC_COLOR = ItemStackUtils.getRarityColor("Mythic");

    private AspectTooltipHelper() {
    }

    public static void renderAspectTooltip(class_332 graphics, int mouseX, int mouseY, Lootpool pool) {
        List<class_2561> tooltipLines = AspectTooltipHelper.buildLines(pool);
        if (tooltipLines.isEmpty()) {
            return;
        }
        AspectTooltipHelper.drawAlignedTooltip(graphics, mouseX, mouseY, tooltipLines);
    }

    private static List<class_2561> buildLines(Lootpool pool) {
        List<LootpoolItem> mythics = pool.getMythicAspects();
        if (mythics.isEmpty()) {
            return Collections.emptyList();
        }
        class_5250 header = class_2561.method_43470((String)"Mythic Aspects").method_27695(new class_124[]{MYTHIC_COLOR, class_124.field_1067});
        List bullets = mythics.stream().map(i -> {
            ClassIcon ic = ClassIcon.fromAspectType(i.getType());
            String txt = (String)(ic != null ? ic.get() + " " : "") + i.getName();
            return class_2561.method_43470((String)("\u2022 " + txt)).method_27692(class_124.field_1080);
        }).collect(Collectors.toList());
        ArrayList<class_2561> out = new ArrayList<class_2561>(bullets.size() + 1);
        out.add((class_2561)header);
        out.addAll(bullets);
        return out;
    }

    public static void drawAlignedTooltip(class_332 g, int mouseX, int mouseY, List<class_2561> tooltipLines) {
        AspectTooltipHelper.drawAlignedTooltip(g, mouseX, mouseY, Collections.emptyList(), tooltipLines);
    }

    private static void drawAlignedTooltip(class_332 g, int mouseX, int mouseY, List<class_2561> primaryLines, List<class_2561> tooltipLines) {
        class_327 font = McUtils.mc().field_1772;
        int sw = g.method_51421();
        int sh = g.method_51443();
        int gs = (int)McUtils.window().method_4495();
        int gap = 5 * gs;
        boolean hasPrimary = !primaryLines.isEmpty();
        Dimension pDim = hasPrimary ? PriceTooltipHelper.calculateTooltipDimension(primaryLines, font) : new Dimension(0, 0);
        int primaryBoxWidth = hasPrimary ? pDim.width + 3 + 2 : 0;
        boolean drawLeft = !hasPrimary || mouseX + primaryBoxWidth + 3 <= sw;
        int availW = drawLeft ? mouseX - gap : sw - gap - (mouseX + primaryBoxWidth);
        float scale = PriceTooltipHelper.calculateScaleFactor(tooltipLines, Math.round((float)sh * 0.8f), availW, 0.4f, 1.0f, font);
        Dimension raw = PriceTooltipHelper.calculateTooltipDimension(tooltipLines, font);
        int w = Math.round((float)raw.width * scale);
        int h = Math.round((float)raw.height * scale);
        float x = drawLeft ? (float)(mouseX - gap - w) : (float)(mouseX + primaryBoxWidth + gap);
        x = class_3532.method_15363((float)x, (float)gap, (float)(sw - gap - w));
        float y = mouseY + h > sh - gap ? (float)(sh - gap - h) : (float)mouseY;
        y = class_3532.method_15363((float)y, (float)gap, (float)(sh - gap - h));
        class_4587 ps = g.method_51448();
        ps.method_22903();
        ps.method_46416(x, y, 0.0f);
        ps.method_22905(scale, scale, 1.0f);
        g.method_51434(font, tooltipLines, 0, 0);
        ps.method_22909();
    }
}

