/*
 * Decompiled with CFR 0.152.
 */
package com.wynnventory.util;

import com.wynntils.models.emeralds.EmeraldModel;
import com.wynntils.models.emeralds.type.EmeraldUnits;

public class EmeraldPrice {
    private static final EmeraldModel EMERALD_MODEL = new EmeraldModel();

    public String getFormattedString(int emeralds, boolean appendZeros) {
        StringBuilder builder = new StringBuilder();
        int[] emeraldAmounts = EMERALD_MODEL.emeraldsPerUnit(emeralds);
        if (emeraldAmounts[3] > 0) {
            builder.append(emeraldAmounts[3]).append(EmeraldUnits.LIQUID_EMERALD_STX.getSymbol()).append(" ");
            double fractionalLe = (double)emeraldAmounts[2] + (double)emeraldAmounts[1] / 64.0 + (double)emeraldAmounts[0] / 4096.0;
            if (fractionalLe > 0.0 || appendZeros) {
                builder.append(String.format("%.1f", fractionalLe)).append(EmeraldUnits.LIQUID_EMERALD.getSymbol()).append(" ");
            }
        } else {
            for (int i = emeraldAmounts.length - 2; i >= 0; --i) {
                if (emeraldAmounts[i] == 0 && !appendZeros) continue;
                builder.append(emeraldAmounts[i]).append(EmeraldUnits.values()[i].getSymbol()).append(" ");
            }
        }
        return builder.toString().trim();
    }
}

