/*
 * Decompiled with CFR 0.152.
 */
package com.wynnventory.util;

import com.wynntils.core.components.Services;
import com.wynntils.utils.mc.McUtils;
import com.wynnventory.config.ConfigManager;
import com.wynnventory.core.ModInfo;
import com.wynnventory.model.item.Lootpool;
import com.wynnventory.model.item.LootpoolItem;
import com.wynnventory.util.LootpoolManager;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_368;
import net.minecraft.class_370;

public class FavouriteNotifier {
    private static final int MAX_TOASTS = ConfigManager.getInstance().getFavouriteNotifierSettings().getMaxToasts();

    private FavouriteNotifier() {
    }

    public static void checkFavourites() {
        if (ConfigManager.getInstance().getFavouriteNotifierSettings().isEnableNotifier()) {
            Set favourites = Services.Favorites.getFavoriteItems();
            if (favourites.isEmpty()) {
                return;
            }
            List<FavouriteMatch> matches = FavouriteNotifier.findMatches(favourites);
            if (matches.isEmpty()) {
                return;
            }
            FavouriteNotifier.showToasts(matches);
        } else {
            ModInfo.logInfo("Favourite Notifier is disabled. No toasts will be displayed");
        }
    }

    private static List<FavouriteMatch> findMatches(Set<String> favourites) {
        boolean mythicsOnly = ConfigManager.getInstance().getFavouriteNotifierSettings().isMythicsOnly();
        HashSet<CallSite> seen = new HashSet<CallSite>();
        ArrayList<FavouriteMatch> result = new ArrayList<FavouriteMatch>();
        List allPools = Stream.concat(LootpoolManager.getLootrunPools().stream(), LootpoolManager.getRaidPools().stream()).toList();
        for (Lootpool pool : allPools) {
            String region = pool.getRegion();
            List<LootpoolItem> itemsToCheck = mythicsOnly ? pool.getMythics() : pool.getItems().stream().toList();
            for (LootpoolItem item : itemsToCheck) {
                String name = item.getName();
                String uniqueKey = name + ":" + region;
                if (!favourites.contains(name) || !seen.add((CallSite)((Object)uniqueKey))) continue;
                result.add(new FavouriteMatch(name, region, item.getRarityColor()));
            }
        }
        return result;
    }

    private static void showToasts(List<FavouriteMatch> matches) {
        int total = matches.size();
        int shown = Math.min(total, MAX_TOASTS - 1);
        for (int i = 0; i < shown; ++i) {
            FavouriteMatch match = matches.get(i);
            FavouriteNotifier.showToast("Favourite Found", (class_2561)class_2561.method_43470((String)(String.valueOf(match.rarityColor()) + match.itemName() + String.valueOf(class_124.field_1068) + " in " + match.region())));
        }
        int remaining = total - shown;
        if (remaining > 0) {
            FavouriteNotifier.showToast("More Favourites", (class_2561)class_2561.method_43470((String)(remaining + " more...")));
        }
    }

    private static void showToast(String title, class_2561 desc) {
        McUtils.mc().method_1566().method_1999((class_368)new class_370(new class_370.class_9037(10000L), (class_2561)class_2561.method_43470((String)title), desc));
    }

    public record FavouriteMatch(String itemName, String region, class_124 rarityColor) {
    }
}

