/*
 * Decompiled with CFR 0.152.
 */
package com.wynnventory.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.wynnventory.core.ModInfo;
import com.wynnventory.model.item.Icon;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.Map;

public class IconManager {
    public static final String GEAR_URL = "https://raw.githubusercontent.com/Wynntils/Static-Storage/main/Reference/gear.json";
    public static final String MATERIALS_URL = "https://raw.githubusercontent.com/Wynntils/Static-Storage/main/Reference/materials.json";
    public static final String INGREDIENTS_URL = "https://raw.githubusercontent.com/Wynntils/Static-Storage/main/Reference/ingredients.json";
    public static final String ASPECTS_URL = "https://raw.githubusercontent.com/Wynntils/Static-Storage/refs/heads/main/Reference/aspects.json";
    public static final String TOMES_URL = "https://raw.githubusercontent.com/Wynntils/Static-Storage/refs/heads/main/Reference/tomes.json";
    private static final Gson GSON = new Gson();
    private static Map<String, JsonObject> allEntries;

    private IconManager() {
    }

    public static void fetchAll() {
        Map<String, JsonObject> gearMap = IconManager.fetchJson(GEAR_URL);
        Map<String, JsonObject> materialsMap = IconManager.fetchJson(MATERIALS_URL);
        Map<String, JsonObject> ingredientsMap = IconManager.fetchJson(INGREDIENTS_URL);
        Map<String, JsonObject> aspectsMap = IconManager.fetchJson(ASPECTS_URL);
        Map<String, JsonObject> tomesMap = IconManager.fetchJson(TOMES_URL);
        allEntries = new HashMap<String, JsonObject>(gearMap);
        allEntries.putAll(materialsMap);
        allEntries.putAll(ingredientsMap);
        allEntries.putAll(IconManager.flattenAspects(aspectsMap));
        allEntries.putAll(tomesMap);
    }

    private static Map<String, JsonObject> fetchJson(String url) {
        try {
            HttpResponse<String> resp = HttpClient.newHttpClient().send(HttpRequest.newBuilder(URI.create(url)).GET().build(), HttpResponse.BodyHandlers.ofString());
            if (resp.statusCode() != 200) {
                throw new IOException("Unexpected response code: " + resp.statusCode());
            }
            return IconManager.parseAndStripUnicodeKeys(resp.body());
        }
        catch (IOException | InterruptedException e) {
            ModInfo.logError("Could not fetch JSON from " + url, e);
            return Map.of();
        }
    }

    public static Icon getIcon(String name, int tier) {
        return IconManager.getIcon(name + " " + tier);
    }

    public static Icon getIcon(String name) {
        JsonObject entry = allEntries.get(name.replaceFirst("^Shiny ", ""));
        if (entry == null) {
            ModInfo.logDebug("No JSON entry for key: " + name);
            return null;
        }
        try {
            String entryType;
            String string = entryType = entry.has("type") ? entry.get("type").getAsString().toLowerCase() : "";
            if ("armour".equals(entryType)) {
                String mat = entry.get("armourMaterial").getAsString();
                String arm = entry.get("armourType").getAsString();
                return new Icon("armour", mat + "_" + arm);
            }
        }
        catch (Exception e) {
            ModInfo.logError("Failed to extract icon for entry: " + String.valueOf(entry), e);
            return null;
        }
        return IconManager.extractIcon(entry);
    }

    private static Icon extractIcon(JsonObject entry) {
        JsonElement valElem;
        if (!entry.has("icon")) {
            ModInfo.logError("Missing icon for entry: " + String.valueOf(entry));
            return null;
        }
        JsonObject iconObj = entry.getAsJsonObject("icon");
        String format = iconObj.get("format").getAsString();
        if (entry.has("tiers")) {
            format = "aspect_attribute";
        }
        String value = (valElem = iconObj.get("value")).isJsonPrimitive() ? valElem.getAsString() : valElem.getAsJsonObject().get("name").getAsString();
        return new Icon(format, value.replaceAll(":", "_"));
    }

    private static Map<String, JsonObject> flattenAspects(Map<String, JsonObject> aspectsMap) {
        HashMap<String, JsonObject> flattenedMap = new HashMap<String, JsonObject>();
        for (Map.Entry<String, JsonObject> classEntry : aspectsMap.entrySet()) {
            JsonObject classAspects = classEntry.getValue();
            if (classAspects == null) continue;
            for (Map.Entry aspectEntry : classAspects.entrySet()) {
                JsonElement val = (JsonElement)aspectEntry.getValue();
                if (val == null || !val.isJsonObject()) continue;
                flattenedMap.put((String)aspectEntry.getKey(), val.getAsJsonObject());
            }
        }
        return flattenedMap;
    }

    public static Map<String, JsonObject> parseAndStripUnicodeKeys(String jsonBody) {
        Type mapType = new TypeToken<Map<String, JsonObject>>(){}.getType();
        Map original = (Map)GSON.fromJson(jsonBody, mapType);
        HashMap<String, JsonObject> cleaned = new HashMap<String, JsonObject>();
        for (Map.Entry entry : original.entrySet()) {
            String rawKey = (String)entry.getKey();
            String strippedKey = rawKey.replaceAll("\\P{ASCII}", "");
            if (cleaned.containsKey(strippedKey)) {
                ModInfo.logWarn("Key collision after stripping Unicode: " + strippedKey);
                continue;
            }
            cleaned.put(strippedKey, (JsonObject)entry.getValue());
        }
        return cleaned;
    }
}

